%{/* -*- C -*- */
/* GI lexer.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: lex.l,v 1.24 1998/07/21 14:54:50 tiggr Exp $  */

/* Get RE_DUP_MAX before it simply redefines what tl/regex.h tells the value
   should be.  */
#import <limits.h>
#import "gi.h"
#import <ctype.h>
#import <float.h>
#import <limits.h>
#import "parse.h"

#define yywrap()  1

%}

%%

"break"			{ if (!num_body_brace) return BREAK; }
"class"			{ if (!num_body_brace) return CLASS; }
"continue"		{ if (!num_body_brace) return CONTINUE; }
"const"			{ if (!num_body_brace) return CONST; }
"deferred"		{ if (!num_body_brace) return DEFERRED; }
"do"			{ if (!num_body_brace) return DO; }
"dynamic"		{ if (!num_body_brace) return DYNAMIC; }
"end"			{ if (!num_body_brace) return END; }
"else"			{ if (!num_body_brace) return ELSE; }
"extension"		{ if (!num_body_brace) return EXTENSION; }
"extern"		{ if (!num_body_brace) return EXTERN; }
"for"			{ if (!num_body_brace) return FOR; }
"id"			{ if (!num_body_brace) return RECEIVER; }
"implementation"	{ if (!num_body_brace) return IMPLEMENTATION; }
"instance"		{ if (!num_body_brace) return INSTANCE; }
"if"			{ if (!num_body_brace) return IF; }
"interface"		{ if (!num_body_brace) return INTERFACE; }
"local"			{ if (!num_body_brace) return LOCAL; }
"mutable"		{ if (!num_body_brace) return MUTABLE; }
"nil"			{ if (!num_body_brace) return NIL; }
"old"			{ if (!num_body_brace) return OLD; }
"posing"		{ if (!num_body_brace) return POSING; }
"post"			{ if (!num_body_brace) return POST; }
"pre"			{ if (!num_body_brace) return PRE; }
"private"		{ if (!num_body_brace) return PRIVATE; }
"protected"		{ if (!num_body_brace) return PROTECTED; }
"public"		{ if (!num_body_brace) return PUBLIC; }
"redeclare"		{ if (!num_body_brace) return REDECLARE; }
"redefine"		{ if (!num_body_brace) return REDEFINE; }
"static"		{ if (!num_body_brace) return STATIC; }
"typedef"		{ if (!num_body_brace) return TYPEDEF; }
"void"			{ if (!num_body_brace) return VOID; }
"while"			{ if (!num_body_brace) return WHILE; }

".."			{ if (!num_body_brace) return DOTDOT; }
"++"			{ if (!num_body_brace) return PLUSPLUS; }
"--"			{ if (!num_body_brace) return MINMIN; }
"*="			{ if (!num_body_brace) return MULIS; }
"/="			{ if (!num_body_brace) return DIVIS; }
"%="			{ if (!num_body_brace) return MODIS; }
"+="			{ if (!num_body_brace) return PLUSIS; }
"-="			{ if (!num_body_brace) return MINIS; }
"<<="			{ if (!num_body_brace) return SHLIS; }
">>="			{ if (!num_body_brace) return SHRIS; }
"&="			{ if (!num_body_brace) return BANDIS; }
"|="			{ if (!num_body_brace) return BORIS; }
"^="			{ if (!num_body_brace) return BEORIS; }
"&&="			{ if (!num_body_brace) return SCANDIS; }
"||="			{ if (!num_body_brace) return SCORIS; }
"=="			{ if (!num_body_brace) return EQ; }
"!="			{ if (!num_body_brace) return NE; }
">="			{ if (!num_body_brace) return GE; }
"<="			{ if (!num_body_brace) return LE; }
"->"			{ if (!num_body_brace) return IMPLIES; }
"&&"			{ if (!num_body_brace) return AND; }
"||"			{ if (!num_body_brace) return OR; }
"<<"			{ if (!num_body_brace) return SHL; }
">>"			{ if (!num_body_brace) return SHR; }

"boolean"		{
  if (!num_body_brace)
    {
      lvalp->v = @"boolean";
      return TYPE;
    }
}
"byte"			{
  if (!num_body_brace)
    {
      lvalp->v = @"byte";
      return TYPE;
    }
}
"char"			{
  if (!num_body_brace)
    {
      lvalp->v = @"char";
      return TYPE;
    }
}
"double"		{
  if (!num_body_brace)
    {
      lvalp->v = @"double";
      return TYPE;
    }
}
"float"			{
  if (!num_body_brace)
    {
      lvalp->v = @"float";
      return TYPE;
    }
}
"int"			{
  if (!num_body_brace)
    {
      lvalp->v = @"int";
      return TYPE;
    }
}
"long"			{
  if (!num_body_brace)
    {
      lvalp->v = @"long";
      return TYPE;
    }
}
"pointer"		{
  if (!num_body_brace)
    {
      lvalp->v = @"pointer";
      return TYPE;
    }
}
"selector"		{
  if (!num_body_brace)
    {
      lvalp->v = @"selector";
      return SELECTOR;
    }
}

"//".*\n		{ current_line++; }
[ \t\f]*\n		{ current_line++; }
[ \t\f]*		{ /* Retry.  */ }

[A-Za-z][-A-Za-z_0-9]*	{
			  if (!num_body_brace)
			    {
			      TLString *s = [TLString stringWithCString: yytext
					     length: yyleng];
			      TLVector *v = [LTTUnit instancesNamed: s];

			      if (v)
				{
				  lvalp->v = s;
				  return TYPE;
				}

			      /* It is an identifier.  */
			      lvalp->v = s;
			      return IDENTIFIER;
			    }
			}

(0[xX])?[0-9a-fA-F]+[lL]? {
		  if (!num_body_brace)
		    {
		      lvalp->v = [TLString stringWithCString: yytext
				  length: yyleng];
		      return NUMBER;
		    }
		}

[0-9]+(\.[0-9]+)?(([eE][-+]?[0-9]+)|([dD][-+]?[0-9]*))? {
		  if (!num_body_brace)
		    {
		      lvalp->v = [TLString stringWithCString: yytext
				  length: yyleng];
		      return NUMBER;
		    }
		}


"/*"	{
  int skip = num_body_brace || no_comments;
  TLMutableString *s = skip ? nil : [TLMutableString mutableString];
  int start_line = current_line;
  int b = 0, c = input ();

  if (!num_body_brace)
    formac (s, @"%s", yytext);

  while (c != EOF)
    {
      if (!num_body_brace)
	[s writeByte: c];

      if (c == '/' && b == '*')
	break;

      if (c == '\n')
	current_line++;
      if (b == '/' && c == '*')
	warning (@"`/*' in comment");
      b = c;
      c = input ();
    }

  if (c == EOF)
    {
      int l = current_line;

      error (@"unterminated comment");
      current_line = start_line;
      cerror (@"comment started here");
      current_line = l;
    }

  if (!skip)
    {
      lvalp->v = s;
      return COMMENT;
    }
}

"<"[a-zA-Z0-9_]*">" {
  TLMutableString *s = !num_body_brace ? [TLMutableString mutableString] : nil;
  int c = input (), state = -1;
  int start_line = current_line;
  char *text = alloca (1 + yyleng);

  /* Copy yytext, as that pointer can be mangled by input().  */
  memcpy (text, yytext, yyleng);

  if (!num_body_brace)
    formac (s, @"%s", yytext);

  while (c != EOF)
    {
      if (!num_body_brace)
	[s writeByte: c];

      if (c == '<')
	state = 0;
      else if (state == 0)
	state = c == '/' ? state + 1 : -1;
      else if (state > 0)
	if (text[state] == c)
	  {
	    if (c == '>')
	      break;
	    state++;
	  }
	else
	  state = -1;

      if (c == '\n')
	current_line++;

      c = input ();
    }

  if (c == EOF)
    {
      int l = current_line;

      error (@"unterminated %s documentation", yytext);
      current_line = start_line;
      cerror (@"%s started here", yytext);
      current_line = l;
    }

  /* Avoid warning about unused yyunput.  */
  { void *v = yyunput; v = *&v; }

  if (!num_body_brace)
    {
      lvalp->v = s;
      return DOC;
    }
}

\"(\\.|\\\\|\\[0-7][0-7]*|[^\\\"])*\"	{
  if (!num_body_brace)
    {
      lvalp->v = [TLString stringWithCString: yytext
			   length: yyleng];
      return STRING_CST;
    }
}

'(\\.|[^'\\])*'	{
  if (!num_body_brace)
    {
      lvalp->v = [TLString stringWithCString: yytext length: yyleng];
      return NUMBER;
    }
}

"{"	{ return '{'; }
"}"	{ return '}'; }
";"	{ if (!num_body_brace || num_body_brace == -1) return yytext[0]; }

.	{ if (!num_body_brace) return yytext[0]; }

%%
/* Parse the file called NAME to be found in the UNIT along the
   searchpath.  */
void
parse_file (id <TLString> name, LTTUnit *unit, FILE *f)
{
  /* Hack needed when switching back from top-level buffer.  It is not
     allowed to switch to the NULL buffer.  Sigh.  */
  static YY_BUFFER_STATE top;
  YY_BUFFER_STATE pyy_buf = YY_CURRENT_BUFFER;
  GCDECL1;

  PARSE_START_CONTEXT (name);

  GCPRO1 (current_filename);

  yy_switch_to_buffer (yy_create_buffer (f, YY_BUF_SIZE));

  num_body_brace = 0;

  gi_parse ();

  PARSE_STOP_CONTEXT;

  if (!top)
    top = yy_create_buffer (NULL, 1);
  yy_switch_to_buffer (pyy_buf ? pyy_buf : top);

  /* No need to GC if we're about to exit.  */
  if (!flag_inhibit_gc && !of)
    [TLObject gc];

  PARSE_END_CONTEXT;

  GCUNPRO;
} /* parse_file */
