<copyright> Garbage Collection over Distributed Objects testcase and example.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: gcdo.t,v 1.5 1998/01/05 00:55:34 tiggr Exp $</id>
    </copyright>

implementation class
gcdo: State, Conditions, Runtime
{
  <doc> The number of invocations done so far, and the limit.  When the
      limit is reached, the program exits.  </doc>
  static int num_invocations, max_invocations;

  <doc> The published server and how it is known at the client side.
      </doc>
  gcdo local_server, remote_server;
}

int
  main Array arguments
{
  ServerInetPort server_port;

  if ([arguments length] > 1)
    {
      [[[stdio err] print ("usage: ", program_name, " [num_invocations]")] nl];
      [Runtime exit 2];
    }
  else if ([arguments length] == 1)
    max_invocations = [arguments[0] intValue];
  else
    max_invocations = 1000;

  /* The bind is only really necessary if we explicitly defined a port
     onto which to bind, but since we pass 0, a suitable (free) port will
     be chosen anyway.  */
  bind ((error,
	 {
	   [[[stdio err] print ("server port allocation failed: ",
				[condition message])] nl];
	   [Runtime exit 1];
	   nil;
	 }))
    server_port = [ServerInetPort with 0 at nil];
  
  ServerConnection con = [[ServerConnection alloc] initWithPort server_port];

  local_server = [self new];
  [con set_root local_server];

  InetHost h = [InetHost named "localhost"];
  ConnectedInetPort client_port = [ConnectedInetPort with [server_port port]
						     at [h addresses][0]];

  remote_server = [[[ConnectedConnection alloc] initWithPort client_port]
		    root];

  Timer t = [Timer withInterval 1d-6
		   invocation [Invocation of selector ("v_trigger") to: self]];

  [t schedule];

  [[RunLoop current] run];
}

void
  trigger
{
  [remote_server ignore [self new]];
}

end;

implementation instance
gcdo

<doc> Tell the {object} to do the same with a new instance of our class.
    </doc>
void
  ignore id object
{
  if (++num_invocations > max_invocations)
    [Runtime exit 0];

  [object ignore [isa new]];
}

end;
