/*
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: alpha.h,v 1.4 1998/05/13 15:38:58 tiggr Exp $  */

#define REG_PROT_START 0
#define REG_PROT_END  (sizeof (__jmp_buf) / sizeof (tom_long))

/* We should start calling these VA_ARG things differently.  Anyway, the
   first 6 arguments are passed in (int or float) registers, so a float as
   one of the first 6 word-sized arguments must be retrieved as a double.  */
#define VA_ARG_FLOAT(AP)  \
  ({									\
    float f = va_arg ((AP), tom_float);					\
    if ((AP).__offset <= 6 * 8)						\
      f = *(tom_double *) ((AP).__base + (AP).__offset - (6 * 8 + 8));	\
    f;									\
  })

#include <config/alpha/alpha.h>
#include <config/linux/target.h>

/* Something's wrong with mmap on RH5.0.  */
#undef HAVE_MMAP
#define HAVE_MMAP 0
