/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: hppa.h,v 1.17 1999/06/03 11:07:16 tiggr Exp $  */

#ifndef RANGES_ARE_ALIGNED
#define RANGES_ARE_ALIGNED  1
#endif

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; tom_double d; } d;	\
  struct { tom_int a, b; tom_float f; } f;	\
}

/* XXX These could be tweaked.
   Mon Sep 23 15:18:30 1996, tiggr@cobra.es.ele.tue.nl  */
#define REG_PROT_START	0
#define REG_PROT_END	(sizeof (jmp_buf) / sizeof (void *))

#define APPLY_ARGS_REG_SIZE  (4 * sizeof (int) + 4 * sizeof (double))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int offset = 0;							\
      int reserved_size = (sizeof (void *) * (SEL)->out->num		\
			   + sizeof (tom_double) * (SEL)->in->num)

#define APPLY_ARGS_STACK_SIZE(SEL)  \
      reserved_size

/* Macro local to this target file to emit a value of some non-floating type
   to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
({									\
    TYPE *addr = (offset < 16						\
		  ? (void *) &args->reg[20 - offset]			\
		  : (void *) ((char *) args->stack + reserved_size	\
			      - offset - 4));				\
    offset += sizeof (TYPE);						\
    *addr = (VALUE);							\
    addr;})

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
({								\
    tom_long *addr;						\
								\
    offset = (offset + 7) & ~7;					\
    addr = (offset < 12						\
	    ? (void *) &args->reg[20 - offset - 4]		\
	    : (void *) ((char *) args->stack + reserved_size	\
			- offset - 8));				\
    offset += sizeof (tom_long);				\
    *addr = (VALUE);						\
    addr;})

/* Apparently, the floating point registers (4 of them, located starting
   at reg + 24, 8 bytes each), though loaded by __builtin_apply, are not
   actually used to pass values!  */

/* Add a float value to the ARGS being built.    */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
({									\
    float f = (VALUE);							\
    APPLY_ARGS_EMIT_INT (*(int *) &f);					\
 })

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
({						\
    double d = (VALUE);				\
    APPLY_ARGS_EMIT_LONG (*(tom_long *) &d);	\
 })

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_COMPLETE()  \
      do							\
	{							\
	  if (offset < 16)					\
	    args->stack = 0;					\
	  else							\
	    args->stack = (void *) ((char *) args->stack	\
				    + reserved_size);	\
	} while (0)

#define APPLY_ARGS_ACTUAL_SIZE()  \
      (offset < 16 ? 0 : (offset + 7) & ~7)

#define APPLY_ARGS_END()  \
    } while (0)

#include <config/hpux/target.h>
