.\"
.\" $Id: tkcvs.n,v 1.7.4.4 1998/10/08 07:00:31 dorothyr Exp $
.\"
.\" Full space in nroff; half space in troff
.de SP
.if n .sp
.if t .sp .5
..
.tr ~
.TH "tkCVS" n "$Date: 1998/10/08 07:00:31 $" "Tcl"
.ad b
.SH NAME
tkCVS \- a Tk/Tcl Graphical Interface to CVS
.SH SYNOPSIS
.B tkcvs
.SH DESCRIPTION
.B tkCVS
is a graphical interface to the CVS (Concurrent Versions System)
revision control system.
.SP
.SH OPTIONS
.TP
.BI \-dir " directory"
Start tkCVS in the specified directory.
.TP
.BI \-\-help
Print a usage message.
.TP
.BI \-root " cvsroot"
Set $CVSROOT to the specified repository.
.TP
.BI \-win " workdir|module"
Start by displaying the directory browser (the default)
or the module browser.  If you start with the module browser,
the directory browser is iconified.
.TP
For example, if you want to browse the modules located in 
.I /jaz/repository,
you would type
.B "tkcvs \-win module \-root /jaz/repository."
.SP
.SH tkCVS USERS GUIDE
The following sections provide a working overview of tkCVS.
.SP
.SH WORKING WITH tkCVS
To work with files from the repository using
.B tkCVS,
first you need
to select a directory (sometimes called a
.I sandbox
) to work in.  You can create a subdirectory
from your home directory (I use 
.I develop
for all of my development
software, you may like to use 
.I src
or 
.I progs
), or you may work
from your home directory.
.SP
After selecting this directory and navigating into it using the directory
display, you can select a
.I module
to work with.  In CVS, groups of files are arranged into modules for
easy access.
.SP
.B tkCVS
arranges modules into
.I directories
and
.I subdirectories
in a tree structure
much in the same way that you would arrange them in your home
directory.  You can navigate through the
.B tkCVS
module tree using the
.I Module Browser
window.
.TP
.B Working with files from the repository
Using the Module Browser window, you can select a module to check out.
Each module has a
.I module code
which is displayed as you browse through the module tree.  When you
check out a module, a new directory is created in your working directory
with the same name as the module code.
.SP
You can then change into the new directory that
.B tkCVS
has created, and all of the files in that module will be in the directory.
.SP
You can use the simple file management and editing features of 
.B tkCVS
to work with files in this directory, or you may use your own text
editor, word processor, or whatever to work with the files.
.SP
Once you have finished your edits (or whenever you have reached a
stable stage in your development, or possibly even on a daily basis),
you can check files back in to 
.B tkCVS
using the
.I Check In
button.
.TP
.B Tagging and Branching
You can tag particular versions of a module or file in the repository.
Normally you will do this when your programs are ready to be released
into a testing or production environment.  Tagging is useful for
taking snapshots
of what the repository contained at a particular date (for example
you can tag all of the files associated with a particular software
release).
.SP
You can also create branches based on tags or on particular versions
of the files in the repository.  This allows you to go back and fix
particular bugs or make important patches to an earlier release of
software while still being able to work on the latest version.
.SP
You can use symbolic tag names to refer to versions of files in the
repository, instead of just numeric version numbers.  For example
you can use the tag name
.I software_release_1_5
to indicate release 1.5 of a group of files destined for a customer
site.
.TP
.B Exporting
Once a software release has been tagged, you can use a special type
of check out called an
.I export.
This allows you to more cleanly check out files from the repository,
without all of the administrivia that
.I CVS
requires you to have while working on the files.  This type of facility
is useful for delivery of a software release to a customer.
.TP
.B Importing
.B tkCVS
contains a special dialog to allow users to import new files into
the repository.  New modules can be assigned places within the
repository, as well as descriptive names (so that other people
know what they are for).
.TP
.B Working inside the repository.
tkCVS contains some features that enable it to work inside the repository.
The
.I module browser
window displays the directories and modules within the repository in
a tree structured manner.
.SP
The module browser also contains a
.I file browser
window that enables you to list the files within the module, and view
a specific version of a file.
.SP
The
.I log browser
window contains a graphical display of a revision log for a file,
and enables you to see the differences between two versions of a file
by pointing and clicking on the versions in the display.
.TP
.B Other Features
Other features of 
.B tkCVS
allow you to tag files, add new files or delete
files from the repository, or view and print reports about the repository
contents.
You can also search the module database for module codes, module names,
and keywords within a module name.
.SH CHECKING OUT MODULES USING tkCVS
To check out a module, first display the 
.B module browser 
dialog using the
.I Module Browse
button.  Note that you do not have to check out modules using this
dialog -- you can use it for just browsing through the modules
in the repository.
.SP
Once you have found the module you are looking for in the module tree,
you can check it out by pressing the 
.I Check Out
button, or export it using the
.I Export
button (see the section on
.I Exporting
later in this manual).
.SH TAGGING AND BRANCHING
.I CVS
uses a system of
.I tags
to indicate places in the development cycle when the repository
(or parts of it) are in a stable state.  These tags can be applied
to modules in the repository or to files within a module.
.TP
.B Tagging Modules
To tag a module, first select the module using the module browser
(note that you may tag a module or a directory tree -- to tag an
entire directory tree including all of its sub-directories and
modules, select the top level directory of the tree).
.SP
Enter the
.I tag name
into the
.I Tag A
entry box.  Note that a tag name may be any alphanumberic string,
but may not contain any spaces.  Sample tag names include things
like
.I software_release_1_0
or
.I integration_test_release.
.SP
If you also enter a tag name into the Tag B entry box,
then all files in that module that are currently tagged
with Tag B will be also tagged with Tag A.
.SP
Select the
.B Tag->Tag Module
menu item from the menu on the Module Browser dialog, and the module
or directory will be tagged with the tag name that you have entered.
.TP
.B Tagging Files
You may tag individual files from within the directory browser.
This is mostly useful when you only want to tag part of the files in a module,
or when you are re-tagging certain files within an already tagged
module.
.SP
Select the files that are to be tagged, and select the
.B File->Tag Files
option from the menu.  This will request that you enter a tag name.
The selected files will then be tagged with this tag name.
.TP
.B Updating to a Tag
Once a file or module has been tagged within the repository, 
you may use the
tag name for checking out files, or updating files to
a tag name.
.SP
If a tag name is entered in the
.I Tag A
field of the browser window when you select a module for check
out, then the tagged version of the module (rather than the latest version)
will be checked out of the repository.
.SP
Similarly, instead of selecting File->Update to Head from the main menu,
you can select 
.B File->Update to Tag
to update a file to a tagged version (instead of the head version).
This will ask you to enter a tag name before the module is updated.
.TP
.B Branching
CVS also supports the concept of branching files.  When you are applying
a tag, the tag may be applied as a
.I branch tag,
which means that all
versions based on this tag will be placed on a branch of the main version
tree instead of on the trunk.
.SP
You should update files to a branch tag before you change them if you
want your changes to not affect the head version.
.SP
To read more about branching and branch tags, read the
.I cvs
manual page.
.SH EXPORTING
An important use of tagging modules is to indicate when a new
release of software is ready to be delivered, and to mark the
versions of all of the files in that release within the
repository.
.SP
When a release is about to be made, you may
.I export
it from the repository.  This is like a check-out, except for
the following:
.TP
.B *
Exported directories do not contain the
.I CVS
or
.I CVS.adm
administrative directories, and are therefore cleaner (but
cannot be used for checking files back in to the repository).
.TP
.B *
Exported files do keyword expansion differently from non-exported
files (to ensure that the keyword information is not lost should
the file be imported into CVS at a different site).
.RE
To export a module or directory, press the
.I Export
button at the bottom of the module browser.  You must supply a
.I tag
name when you are exporting a module -- you cannot just export
the default (head) version.  This is to make sure that you have
the tag in place so that you can reproduce the exported files at
a later date.  This is called good
.I configuration management.
.SH IMPORTING NEW MODULES USING tkCVS
Before importing a new module, first check to make sure that you
have write permission to the repository.  Ask the configuration
management staff at your organisation to determine whether you
can write to the repository.
.SP
You should also take some time and view how the repository is
structured using the check-out dialog (see above).  You will need 
to provide a directory name for your module (which should not
be already in use) and so you will need to know that the parent
directory for your module exists in the repository first. 
Although a module can be imported without the parent directory
existing, this means that the CVS
.I modules
file must be patched manually after the operation is finised
to insert the directory name in the correct place in the
file.
.SP
To import a module, first enter the directory where the module
is located.  Make sure that there is nothing in this directory
except the files that you want to import (create a new empty
directory first and copy the files from the module into it
if necessary).
.SP
Once this is done, press the
.I Import
button.  You will need
to enter the following details:
.TP
.B Module Directory
The location in the module tree where your new module will be
put.  This directory must not already exist, although its
parent directory must exist.
.TP
.B Module Name.
A one-line descriptive name for your module.  This is the name
that will be displayed in the browser.
.TP
.B Version  Number
The current version number of the module.  This should be a
number of the form
.I X.Y.Z
where .Y and .Z are optional.
You can leave this blank, in which case
.I 1
will be used as the first version number.
.TP
.B Module Code
A module code for the module.  This code must not already
exist in the repository.  I strongly suggest that your organisation
settles on a single unambiguous code for modules.  One possibility
is something like:
.SP
<project code>-<subsystem code>-<module code>
.SP
Using this scheme, you could have a 3 digit project code, a 3 letter
subsystem code, and a 4 letter module code for each module, and
everything would be easy to locate.
.SP
.RE
Once you have entered these details, press the
.I OK
button to import the module.
.SH CREATING NEW DIRECTORIES USING tkCVS
.B tkCVS
is not a file manager!  You can't use it to create
directories within your home directory.
.SP
You can, however, use it to create new directories within the
repository.  This is best done while importing new modules.  If
you are about to import a new module, and the parent directory
does not exist in the repository, you can create it using the
.I New Directory
button.
.SP
Press this button and a dialog will appear allowing you to create
the new directory.  You must enter the following information:
.TP
.B New Directory Location
Where (within the module tree) the new directory will be created.
This directory should not already exist, but the parent directory
must exist.
.TP
.B New Directory Name
This is a one-line descriptive name for the new directory.
Something like
.I Accounting software
or
.I Test data for my files
should be sufficient.
.SP
.RE
Once you have entered this information, press the
.I OK
button to create the directory.
.SP
You may use this dialog multiple times in one session to
create multiple directories, or an entire tree of directories
in your repository.
.SP
.SH tkCVS REFERENCE
The following sections provide a complete reference to the
user interface to tkCVS.
.SP
.SH MAIN WINDOW
The 
.B tkCVS
main window comprises a menu bar, a current directory display,
and some command buttons.
.SH MENU
The 
.B tkCVS
menu is displayed at the top of the window.  There are the
following options on the menu:
.TP
.B File->Open
This opens the currently selected files so that they can be edited.
.TP
.B File->Delete
This deletes the currently selected files.
.TP
.B File->Cleanup
This removes any backup files from the current directory.
.TP
.B File->Print
This prints the currently selected files.  For more information
on the print command used, see the section on
.I tkCVS configuration files.
.TP
.B File->Import
Select this to import new files into the repository.  This is
described later.
.TP
.B File->Create Dir
Select this to create and name a new directory into the repository.
You must create and name a directory before you import files into
it.
.TP
.B File->Tag Files
Select this to tag some of the files in the current directory.
A symbolic tag name must be supplied.
If there are files in the current
directory display that have been selected, these will be tagged, otherwise
all of the files in the current directory will be tagged.
.TP
.B File->Update
Select this to update the files in the current directory to the latest
version in the repository.  Only files that have changed in the repository
since the current directory was checked out will be updated.  If there are
files in the current display that have been selected, these will be
updated, otherwise all of the files in the current directory will be updated.
.TP
.B File->Update to Tag
Select this to update the files in the current directory to a particular
tag name.
A symbolic tag name must be supplied.
If there are
files in the current display that have been selected, these will be
updated, otherwise all of the files in the current directory will be updated.
.TP
.B File->Add Files
This is the same as the
.I Add Files
button.  Press this button to add new files to the repository.  The files
you have selected will be added to the repository next time you press the
.I Check In
button.
.TP
.B File->Remove Files
This is the same as the
.I Delete Files
button.  Press this button to remove the selected files from the repository.
.TP
.B File->Log Browse
This option opens the
.I Log Browser
window for each of the selected files.
.TP
.B File->Check In
This is the same as the
.I Check In
button.
.TP
.B File->Check Out
This option opens the
.I Module Browser window
.TP
.B File->Exit
Select this to quit 
.B tkCVS.
.TP
.B Reports->CVS check
Select this option to run a
.I cvscheck
command in the current directory.
.SP
This will list
all of the files that need checking in to the repository.  All files
that have been created but not added to the repository are also listed,
as well as any files that have been removed from the directory but not
removed from the repository.
.SP
This is the same as pressing the
.I Check
button at the bottom of the window.
.TP
.B Reports->CVS status
This option will display a status of all of the files in the current
directory that are part of CVS (to see what files are missing from
CVS or from the current directory, press the
.I Status
button at the
bottom of the screen).
.SP
Each file, along with its version number and the version number contained
in the repository, is shown.
.SP
The report may be limited to specific files by selecting them in the
file list before choosing this menu option.
.TP
.B Reports->CVS diff
This option will display any differences between the files in the
current directory and those in the CVS repository.
.SP
The report may be limited to specific files by selecting them in the
file list before choosing this menu option.
.TP
.B Reports->CVS log
This option will display a version history log of the files in the
current directory.
.SP
The report may be limited to specific files by selecting them in the
file list before choosing this menu option.
.TP
.B Reports->Module Tree
This report shows a formatted (tree structured) view of all of the
modules in the repository.  It may be seen on the screen, printed to
a PostScript printer, or saved to a file in ASCII format.
.TP
.B Reports->Modules Sorted by Name
This report shows an unformatted list of all of the modules in the
repository, sorted in alphabetical order by module name.
.TP
.B Reports->Version Tree
This report is the same as the Module Tree, however it also shows
the version number of each file in the modules in the repository.
.SP
For a very large CVS repository, this command can take a long
time to execute, and produce a very large output, so be careful!
.TP
.B Reports->Version Listing by Name
This report is the same as Modules Sorted by Name, however it also
shows the version number of each file in the modules in the repository.
.SP
For a very large CVS repository, this command can take a long
time to execute, and produce a very large output, so be careful!
.TP
.B Search->Search Repository by Code
This item allows you to search the modules database for a module code.
A dialog will appear asking you to enter the module code that you are
searching for.
The module code must exactly match the code of a module in the database.
If it does match, a window will appear telling you the location of that
module in the database.
If no match is detected, then a window will appear telling you that there
is no match.
You can enter the module code in either upper or lower case -- the search
is case insensitive.
.TP 
.B Search->Search Repository by Name
This item allows you to search the modules database for a module name.
A dialog will appear asking you to enter the module name that you are
searching for.
The module code must exactly match the name of a module in the database.
If it does match, a window will appear telling you the location of that
module in the database.
If no match is detected, then a window will appear telling you that there
is no match.
You can enter the module name in either upper or lower case -- the search
is case insensitive.
.TP
.B Search->Search Repository by Keyword
This item allows you to search the modules database for a particular
word.
A dialog will appear asking you to enter the word that you are
searching for.
The word can be a module name, a module code, or part of a module name
or code.  The entire database will be searched for any module whose
name or code either completely or partially matches the word you have
entered.
If a match is found, then a window will appear telling you the location
of any modules that match.  There may be lots of matches, in which case
you may need to scroll the window to see all of them.
The search is case insensitive \- you can enter the keyword in either
capitals or lower case.
.TP
.B Options->Show hidden files
This item turns on and off the display of hidden files in the current
directory.  Hidden files are those files whose name begins with a
"." (dot).
.TP
.B Options->Check recursively
This item turns on recursive checking of the current directory when
the "Check" button at the bottom of the window is pressed.  Normally
only the files in the current directory are checked.
.TP
.B Options->Show untagged files in tag reports
When selecting a Version Tree for tagged files from the module browser, normally
only the files that have the selected tag are displayed.  With this
option selected, all files will be displayed.  The files that do not
have the selected tag will show a version number of "missing".
.SP
.TP
.B Help->About tkCVS
This item displays a small dialog that tells you about your
release of 
.B tkCVS.
.TP
.B Help->About CVS
This item displays a small dialog that tells you about your
release of CVS.
.SH CURRENT DIRECTORY DISPLAY
The current directory display shows:
.TP
.B *
The name of the current directory,
.TP
.B *
The location of the current directory in the CVS repository.  This will
only be shown if the current directory is contained in the CVS repository.
If it is not contained in the repository you may import it using the
.I Import
button.
.TP
.B *
A list of the files in the current directory.
.RE
You may select a file by clicking on it once with the left mouse button.
You may select a group of files by dragging over them with the mouse.
.SP
You may move into a directory by double-clicking on it.
.SP
Double clicking on a file will load the file into a simple text editor 
so you can edit it.
.SH File Status
When you are in a directory that is contained in the CVS repository,
a file status will be shown next to each file.  The various statuses
that can be shown are:
.TP
.B ok
The file is up to date with respect to the repository.
.TP
.B ????
The file is not contained in the repository.  You may need to add
the file to the repository by pressing the "Add" button.
.TP
.B Locally Modified
The file has been modified in the current directory since being
checked out of the repository.
.TP
.B Locally Added
The file has been added to the repository.  This file will become
permanent in the repository once a commit is made.
.TP
.B < dir >
The file is a directory.
.SH BUTTONS
There are a number of buttons at the bottom of the window.
Depending on the setting of your cvscfg(buttons) variable, the
buttons may be displayed as text or as bitmaps.
Pressing on one of these causes the following actions:
.TP
.B Check
Press this button to run a
.I cvscheck
command in the current directory.
.SP
This will list
all of the files that need checking in to the repository.  All files
that have been created but not added to the repository are also listed,
as well as any files that have been removed from the directory but not
removed from the repository.
.TP
.B View
Press this button to view the selected files in a scrolling window,
without invoking an editor.
.B Edit
Press this button to load the selected files into a text editor.
.TP
.B Delete
Press this button to delete the selected files.  The files will not
be removed from the repository.  To remove the files from the repository
as well as delete them, press the "Remove" button instead.
.TP
.B Unselect
Press this button to un-select all of the selected files.
.TP
.B Refresh
Press this button to re-read the current directory.  You might want to
do this immediately after a check-in or update, and also if you add
new files to the directory.
.TP
.B Log Browse
This button will bring up the log browser window for each of the
selected files in the window.  This window is described later.
.TP
.B Cleanup
This button deletes all of the backup files in the current directory.
Normally you will not want to check these files in to the repository,
so you can remove them with this button.  Check the tkCVS configuration
file to determine the list of files that tkCVS considers to be backup
files.
.TP
.B Add Files
Press this button when you want to add new files to the repository.
.SP
You can do this when you have created a new file in the current directory.
You must create the file before adding it to the repository.
.SP
To add some files, first select them in the list above the buttons.  Then
press the 
.I Add Files
button.
.SP
The files that you have added to the repository will be committed next time
you press the
.I Check In
button.
.TP
.B Remove
This button will delete files.
.SP
To delete a file, first select the file in the list above the buttons.
Then press the
.I Remove
button.
.SP
The file will disappear from the directory and from the file list,
and will be removed from the repository next time you press the
.I Check In
button.
.TP
.B Diff
This compares the selected files with the equivalent files in the
repository.  Note that a separate program called "TkDiff" (also
supplied with tkCVS) is used to do this.
.SP
For more information on TkDiff, press the help button on the bottom
of the TkDiff main window.
.TP
.B Check In
This button commits your changes to the repository.  This includes
adding new files and removing deleted files.
.SP
When you press this button, a dialog will appear asking you for
the version number of the files you want to commit, and a comment.
.SP
You need only enter a version number if you want to bring the files in
the repository up to the next major version number.  For example, if
a file is version
.I 1.10,
and you do not enter a version number, it will
be checked in as version
.I 1.11.
If you enter the version number
.I 3,
then it will be checked in as version
.I 3.0
instead.
.TP
.B Update
This updates your sandbox directory with any changes committed to
the repository by other developers.
.TP
.B Module Browse
Press this button to see the Module browser window.  This is described later.
.TP
.B Import
Press this button to import new files into the repository.  This is
described later.
.TP
.B Quit
Press this button to leave 
.B tkCVS.
.SH THE MODULE BROWSER
Most of the file related actions of
.B tkCVS
are performed within the main window.  The module related actions of
.B tkCVS
are performed within the module browser.  The module browser is displayed
using the
.I Module Browse
button from the main window.
.SP
When the dialog is displayed, it shows 3 lists.  The first list is
the names of all of the items in the repository.  The second list shows whether
the item is a directory (which may contain other directories or
modules), or whether it is a module (which may be checked out
from 
.B tkCVS
).
.SP
The third list shows the module code or directory location
in the repository, for reference.
.SP
You can double-click on a directory to open it.  This displays the name
and code of all of the modules and subdirectories within a directory.
.SP
Double clicking on a directory a second time closes it.
.SP
You can close the dialog by pressing the 
.I Quit
button.
.SH Module Browser Menu
The module browser also contains a menu, with the following 
options:
.TP
.B Reports
This menu contains 4 options.  These are 
.B Module Tree
,
.B Modules Sorted by Name
,
.B Version Tree
, and
.B Version Listing by Name
.SP
These perform the same functions as the equivalent items on the
.B tkCVS
main menu, except for the following note:
.SP
Each of these options restricts itself to the currently selected
module or directory in the module browser.  The version reports
do not report the head version, instead they report the version
number attached to the tag name given in the
.I Tag A
field of the module browser.
.SP
.TP
.B Search
This menu contains 3 options.  These are
.B Search Repository by Code
,
.B Search Repository by Name
, and
.B Search Repository by Keyword
.SP
These perform the same functions as the equivalent items on the
.B tkCVS
main menu.
.SP
.TP
.B Patch->Make Patch File
This item creates a Larry Wall format patch(1) file in the current
directory of the module selected.  Note that a tag name must be
entered into the
.I Tag A
field of the module browser.
If a second tag name is entered into the
.I Tag B
field, then the patch file will contain differences between the
two tagged versions of the module.
Otherwise the patch file will contain differences between the
head version and the tagged version of the module.
.TP
.B Patch->View Patch Summary
This item displays a short summary of the differences between
two versions of a module.
Note that a tag name must be entered into the 
.I Tag A
field of the module browser.
If a second tag name is entered into the  
.T Tag 2 
field, then the summary will list the changes between the
two tagged versions of the module.
Otherwise the summary will list differences between the 
head version and the tagged version of the module.
.SP
.TP
.B Tag
See the section titled
.I Tagging and Branching
for more information on the options on this menu.
.SH Module Browser Buttons
The module browser contains the following buttons:
.TP
.B Check Out
Checks out the current version of a module.  If a tag
name is entered into the
.I Tag A
field, then the tagged version is checked out rather than
the head version.
.TP
.B Export
See the section titled
.I Exporting
for more information on exporting modules from the repository.
.TP
.B Patch Summary
This button displays a short summary of the differences
between two versions of a module. Note that a tag name
must be entered into the
.I Tag A
field of the
module browser. If a second tag name is entered into
the
.I Tag B
field, then the summary will list the changes
between the two tagged versions of the module. Otherwise the
summary will list differences between the head
version and the tagged version of the module.
.TP
.B File Browse
Select a module in the module browser and press this button to
display the file browser window.
.TP
.B Quit
This button closes the module browser.
.SH THE FILE BROWSER
Pressing the
.I File Browse
button in the module browser window displays the
.B tkCVS
file browser.
This window shows a list of each file contained in the selected
module, and contains three buttons.  These are:
.TP
.B View
This displays a window showing the contents of the file.  The file
may be viewed but not edited using this window.
(To edit a file in the repository, you must check the file
out of the repository).
.SP
Note that if a tag name or version number is entered into the
.I Version / Tag
field at the top of the window, the specified version of the file is
displayed, and not the head version.
.TP
.B Log
This displays the log browser window for the file.
.TP
.B Quit
This button closes the file browser.
.SH THE LOG BROWSER
The
.B tkCVS
.I Log Browser
window enables you to view a graphical display of the revision log
of a file, including all previous versions, and any branched versions.
.SP
You can get to the log browser window in two ways, either by selecting
a file within the main window of
.B tkCVS
and pressing the
.I Log Browse
button, or by selecting a file in the file browser window (available
from within the module browser) and pressing the
.I Log Browse
button.
.SP
The two forms of the log browser are slightly different.  From within
the main window it is possible to perform merge operations on a file,
and the results of the merge are stored in the current directory.  From
within the module browser (working directly within the repository)
merge operations are not possible.
.TP
.B Log Browser Window
The log browser window has three components.  These are the file name
and version information section at the top, the log display in the middle,
and a row of buttons along the bottom.
.TP
.B Log Display
The main log display is fairly self explanatory.  It shows a group of
boxes connected by small lines indicating the main trunk of the file
development (on the left hand side) and any branches that the file
has (which spread out to the right of the main trunk).
.SP
Each box contains the version number and author of the version.
.TP
.B Version Numbers
Once a file is loaded into the log browser, up to two version numbers 
may be selected.  The primary version is selected by clicking the left
mouse button on a version box in the main log display.
.SP
The secondary version (Version B) is selected by clicking the right
mouse button on a version box in the main log display.
.SP
Operations such as "View" and "Merge Branch to Head" always operate
only on the primary version selected.
.SP
Operations such as "Diff" and "Merge Changes to Head" require two
versions to be selected.
.SH Log Browser Buttons
The log browser contains the following buttons:
.TP
.B View
Pressing this button displays a window containing the primary version
of the file selected.
.TP
.B Diff
Pressing this button runs the "tkdiff" program (by John Klassa) to
display the differences between version A and 
version B.
.TP
.B Merge Branch to Head
To use this button, first select a branch version of the file as the
primary version.
.SP
The changes made along the branch up to that version will then be
merged into the head version, and stored in the current directory.
The version of the file in the current directory will be over-written.
.TP
.B Merge Changes to Head
To use this button, first select two versions anywhere in the file
log (although two adjacent branch versions are more commonly selected).
It is expected that in most cases version B will be later
than version A.
.SP
CVS will then calculate the changes made between the two versions
selected and merge the differences to the head version.
.SP
Note that if version A is later (higher on the trunk or
further along the branch) than version B, a "reverse diff"
will be created.  This will have the effect of removing the changes
from the head version.
.SP
For example, if the head version is 1.6, version A
is 1.5, and version B is 1.3, this button will remove
all of the changes made between versions 1.3 and 1.5 from the head
version.
.SP
It may not make sense to select two branch versions on different
branches for this function.
.TP
.B View Tags
This button displays a window showing the tags contained in the
file.
.TP
.B Quit
This button closes the Log Browser.
.SP
.SH CONFIGURATION FILES
There are two configuration files for 
.B tkCVS.
The first is stored in the directory in which the *.tcl files for
.B tkCVS
are installed.  This is called
.I tkcvs_def.tcl.
.SP
Values in this file can be over-ridden by including a
.I .tkcvs
file in your home directory.
Commands in either of these files should be Tcl scripts.  In other
words, to set a variable name, you should have the following command
in your
.I .tkcvs
file:
.SP
set <variable-name> <value>
.SP
for example:
.SP
set cvscfg(papersize) "A4"
.SP
The following variables are supported by
.B tkCVS:
.TP
.B cvscfg(papersize)
The paper size to print on.  Set this to "A4" for international standard
A4 size paper, or "8x11" for US letter paper.
.TP
.B cvscfg(pointsize)
The basic point size to use in reports.
.TP
.B cvscfg(headingsize)
The point size to use for heading text in reports.
.TP
.B cvscfg(subheadingsize)
The point size to use for sub headings in reports.
.TP
.B cvscfg(glb_background)
The background colour to use for all items in
.B tkCVS.
.TP
.B cvscfg(glb_highlight)
The background colour to use for highlighted items.
.TP
.B cvscfg(bt_lookhere)
The background colour to use for non-highlighted items of particular
interest, in particular buttons, scrollbars, etc.
.TP
.B cvscfg(bt_pressme)
The background colour to use for highlighted buttons, scrollbars, etc.
.TP
.B cvscfg(glb_dir_mark_color)
The colour to use to indicate directories
.TP
.B cvscfg(ldetail)
The default log file detail to be reported; one of
"last" (report only the comment from the last checkin);
"summary" (version number and comment string for all check-ins); or
"verbose" (all logfile detail possible, including symbolic tags).
.TP
.B cvscfg(rdetail)
The default detail for status reports; one of
"terse" (report "status" only and only on those files which
are not "up-to-date");
"summary" (report the "status" and include "up-to-date"); or
"verbose" (provide the report as it would appear unmodified).
.TP
.B cvscfg(y_size)
The number of files that the main working listbox should accomodate.
.TP
.B cvscfg(file_filter)
The default pattern to be used by the main listbox filter.  Use any valid
pattern that can be used for a pattern for 'ls'. An empty string
is equilivant to the entire directory (minus hidden files).
.TP
.B cvscfg(rm_cmd) and cvscfg(rm_flags)
This determines which operating system command is to be used to delete files.
.TP
.B cvscfg(print_cmd)
This determines which operating system command is to be used to print files.
.TP
.B cvscfg(clean_these)
This determines the pattern to be used for cleaning a directory; i.e., the
removal of unwanted files.  Typically these files are not under CVS.
.TP
.B cvscfg(confirm_prompt)
This determines the default value for confirmation prompting before performing an
operation over selected files.
.TP
.B cvscfg(editor)
To override the default editor (setup when tkcvs is configured and
installed) a user can set the cvscfg(editor) variable to the editor
of choice in their .tkcvs file (if they have one).
Note that the editor must be an Xwindow
application.
.TP
.B cvscfg(buttonstyle)
This determines what sort of buttons you get on the main window.
.TP
.B TOOLTIPS_OFF
ToolTips are the small pop-up descriptions of the buttons that
appear under the buttons when the cursor is placed over them.
Setting this variable to 1 will turn ToolTips for the main window
buttons off.
.TP
.B cvs
The location of your CVS executable.  This can be a full path name
or just the string "cvs" in which case your PATH environment variable
will be searched for the CVS programs.
.TP
.B cvscfg(allfiles)
Set this to 0 to see normal files only in the directory browser, set
it to 1 to see all files including hidden files.
This option may be turned on and off within the program by using the
.B Options->Show Hidden Files
menu option.
.SH ENVIRONMENT VARIABLES
You must have the
.B CVSROOT
environment variable pointing to the location of your
.B CVS
repository before you run 
.B tkCVS.
.SH USER CONFIGURABLE MENU EXTENSIONS
It is possible to extend the tkCVS menu by inserting additional commands
into the
.I .tkcvs
or
.I tkcvs_def.tcl
files.  These extensions appear on an extra menu to the right of the
.B tkCVS Options
menu.
.SP
To create new menu entries on the user-defined menu, set the following
variables:
.TP
.B cvsmenu(command)
Setting a variable with this name to a value like "commandname"
causes the CVS command "cvs commandname" to be run when this menu option
is selected.  For example, the following line:
.SP
set cvsmenu(update_A) "update -A"
.SP
Causes a new menu option titled "update_A" to be added to the user
defined menu that will run the command "cvs update -A" on the
selected files when it is activated.
.SP
(This example command, for versions of CVS later than 1.3, will
force an update to the head version of a file, ignoring any sticky
tags or versions attached to the file).
.TP
.B usermenu(command)
Setting a variable with this name to a value like "commandname"
causes the command "commandname" to be run when this menu option
is selected.  For example, the following line:
.SP
set cvsmenu(view) "cat"
.SP
Causes a new menu option titled "update_A" to be added to the User
defined menu that will run the command "cat" on the selected files
when it is activated.
.SP
.RE
Any user-defined commands will be passed a list of file names
corresponding to the files selected on the directory listing
on the main menu as arguments.
.SP
The output of the user defined commands will be displayed in
a window when the command is finished.
.SH CVS modules FILE
.I CVS
maintains a file called
.I modules
in the $CVSROOT/CVSROOT (or $CVSROOT/CVSROOT.adm for versions
prior to 1.3) directory in which it stores the location of all of the
modules in the CVS repository.  
.B tkCVS
maintains a set of backwards -
compatible extensions to this file to store the names of directories
and modules.
.SP
The extensions are:
.TP
.B Directory Name
#D <TAB> 
.I directory
<TAB> 
.I directory name.
.SP
eg:
.SP
#D <TAB> source/account/charge <TAB> Charge accounting software
.SP
.TP
.B Module Name
#M <TAB> 
.I module code
<TAB> 
.I module name
.SP
Where
.I module code
is the same as the module code that CVS uses to refer to the module
in the 
.I modules
file.
.SP
The #M line must be after the #D line for the directory in which the
module is contained, but must be before the line containing the
module code line used by CVS.
.SP
.RE
When you are installing 
.B tkCVS,
you may like to add these additional
lines to the modules file (remember to check out the
.I modules
module
from the repository, and then commit it again when you have finished
the edits).
.SP
Note that all of these extension lines commence with a "#" character,
and so CVS interprets them as comments.  Only 
.B tkCVS
uses them for
naming modules.  They can be safely left in the file whether you are
using 
.B tkCVS
or not (in fact they are a useful reference when browsing
your modules file).
.SH BUGS
Sure.  Mostly because I haven't finished it yet.
.SP
The text editor doesn't work so well with non-ASCII files.
.SP
If you find any other
bugs, write out what you were doing at the time the bug happened
on the back of a clean $100 note and post it to me.
.SH SEE ALSO
.BR cvs,
.BR rcs.
.SH AUTHOR
Del (del@babel.dialix.oz.au)
