#
# Tcl Library for tkCVS
#
 
# 
# $Id: tag.tcl,v 1.5.2.5 1999/09/23 07:48:30 dorothyr Exp $
#
# Set up a small tag dialog.
#

proc tag_setup {} {

  toplevel .tag
  frame .tag.top -relief groove -border 2
  frame .tag.middle
  frame .tag.middle.left
  frame .tag.middle.right
  frame .tag.down

  pack .tag.top -side top -fill x
  pack .tag.middle -side top -fill x
  pack .tag.middle.left -side left -fill y -expand 1
  pack .tag.middle.right -side left -fill y -expand 1

  message .tag.top.explain -justify left -aspect 300 -relief groove \
    -text "Apply a new tag or branch tag\
           to the marked files, recursively.\
           Will apply tag to repository and,\
           if a branch, also update local directory.\
           With the -F option, will move the tag\
           if it already exists.
\ "

  label .tag.lname -text "Tag Name" -anchor w
  entry .tag.tname -relief sunken -textvariable usertagname
  pack .tag.lname -in .tag.middle.left \
    -side top -fill x -pady 3
  pack .tag.tname -in .tag.middle.right \
    -side top -fill x -pady 3

  checkbutton .tag.top.force -text "-F (force)" \
     -variable forceflag -onvalue "-F" -offvalue ""

  pack .tag.top.explain -side top -fill x -pady 1
  pack .tag.down -side bottom -fill x -expand 1
  pack .tag.top.force -side bottom

  button .tag.tag -text "Tag" \
    -command {
      eval "cvs_tag {$usertagname} {$forceflag} {no} [workdir_list_files]"
      wm withdraw .tag
    }
  button .tag.branchtag -text "Branch Tag (-b)" \
    -command {
      eval "cvs_tag {$usertagname} {$forceflag} {yes} [workdir_list_files]"
      wm withdraw .tag
    }
  button .tag.quit -text "Quit" -command { wm withdraw .tag }
 
  pack .tag.tag .tag.branchtag .tag.quit -in .tag.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1
 
  wm withdraw .tag
  wm title .tag "Tag a Module"
  wm minsize .tag 1 1
}

proc tag_run {} {
  global incvs
  global cvscfg

  if {$cvscfg(cvsver) < 1.3} {
    cvsfail "This function is not supported in CVS version $cvscfg(cvsver).
 
Please upgrade your CVS to version 1.3"
    return
  }

  if {! $incvs} {
    cvsfail "This directory is not in CVS.\nPlease import it first."
    return 1
  }

  wm deiconify .tag
  raise .tag
}
