

  functor HTMLLrValsFn (
    structure Token : TOKEN
    structure HTMLAttrs : HTML_ATTRS) = 
struct
structure ParserData=
struct
structure Header = 
struct
(* html-gram
 *
 * COPYRIGHT (c) 1996 AT&T Research.
 *
 * This grammar parses HTML 3.2.  Note that it does not enforce exclusions
 * (for the content of FORM, PRE, etc).  Exclusions should be enforced as
 * a second pass over the parse tree.
 *)

fun textList [text] = text
  | textList l = HTML.TextList l

fun blockList [blk] = blk
  | blockList l = HTML.BlockList l

fun textBlock l = HTML.TextBlock(textList l)
    
(* The elements of a definition list (<DL>) are tags (<DT>) and items (<DD>).
 * To avoid shift/reduce problems, we parse them and then group them.
 *)
datatype deflist_item
  = DL_tag of HTML.text
  | DL_item of HTML.block

fun groupDefListContents [] = []
  | groupDefListContents [DL_tag tag] = [{dt=[tag], dd=HTML.BlockList[]}]
  | groupDefListContents (DL_item blk :: r) =
      {dt=[], dd=blk} :: (groupDefListContents r)
  | groupDefListContents (DL_tag tag :: r) = let
      val {dt, dd} :: r' = groupDefListContents r
      in
	{dt=tag::dt, dd=dd} :: r'
      end

(* A list of Text, paragraphs and blocks requires grouping the Text items and
 * making an implicit paragraph.  We cannot directly use TextList because of
 * conflicts.
 *)
datatype blklist_item
  = BL_text of HTML.text list
  | BL_block of HTML.block list

fun consText (txt, BL_text tl :: r) = BL_text(txt::tl) :: r
  | consText (txt, l) = BL_text[txt] :: l

fun consBlock (blk, BL_block bl :: r) = BL_block(blk::bl) :: r
  | consBlock (blk, l) = BL_block[blk] :: l

fun mkBlock blks = let
      fun f (BL_text tl) = textBlock tl
	| f (BL_block bl) = blockList bl
      in
	blockList(List.map f blks)
      end

fun mkBody blks = HTML.BODY{
	background = NONE,
	bgcolor = NONE,
	text = NONE,
	link = NONE,
	vlink = NONE,
	alink = NONE,
	content = mkBlock blks
      }


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\000\000\
\\001\000\002\000\081\000\004\000\080\000\006\000\079\000\009\000\078\000\
\\012\000\077\000\014\000\076\000\016\000\075\000\018\000\074\000\
\\021\000\073\000\023\000\072\000\025\000\071\000\029\000\070\000\
\\031\000\069\000\033\000\068\000\035\000\067\000\039\000\066\000\
\\041\000\065\000\043\000\064\000\045\000\063\000\047\000\062\000\
\\049\000\061\000\051\000\060\000\053\000\059\000\055\000\058\000\
\\057\000\057\000\061\000\056\000\064\000\055\000\066\000\054\000\
\\067\000\053\000\069\000\052\000\074\000\051\000\076\000\050\000\
\\079\000\049\000\083\000\048\000\085\000\047\000\086\000\046\000\
\\088\000\045\000\092\000\044\000\094\000\043\000\096\000\042\000\
\\098\000\041\000\102\000\040\000\104\000\039\000\106\000\038\000\
\\110\000\037\000\118\000\036\000\120\000\035\000\122\000\034\000\
\\124\000\033\000\126\000\032\000\127\000\031\000\128\000\030\000\000\000\
\\001\000\003\000\241\000\000\000\
\\001\000\005\000\240\000\000\000\
\\001\000\007\000\235\000\000\000\
\\001\000\010\000\234\000\000\000\
\\001\000\013\000\233\000\000\000\
\\001\000\015\000\232\000\000\000\
\\001\000\020\000\004\001\000\000\
\\001\000\022\000\231\000\000\000\
\\001\000\024\000\230\000\000\000\
\\001\000\026\000\229\000\000\000\
\\001\000\030\000\228\000\000\000\
\\001\000\032\000\227\000\000\000\
\\001\000\034\000\226\000\000\000\
\\001\000\036\000\223\000\000\000\
\\001\000\040\000\221\000\000\000\
\\001\000\042\000\220\000\000\000\
\\001\000\044\000\219\000\000\000\
\\001\000\046\000\218\000\000\000\
\\001\000\048\000\217\000\000\000\
\\001\000\050\000\216\000\000\000\
\\001\000\052\000\215\000\000\000\
\\001\000\054\000\214\000\000\000\
\\001\000\056\000\213\000\000\000\
\\001\000\058\000\212\000\000\000\
\\001\000\065\000\211\000\000\000\
\\001\000\070\000\210\000\000\000\
\\001\000\075\000\208\000\000\000\
\\001\000\077\000\207\000\000\000\
\\001\000\080\000\206\000\000\000\
\\001\000\087\000\205\000\000\000\
\\001\000\089\000\204\000\000\000\
\\001\000\091\000\170\000\000\000\
\\001\000\091\000\244\000\000\000\
\\001\000\093\000\202\000\000\000\
\\001\000\095\000\201\000\000\000\
\\001\000\097\000\200\000\000\000\
\\001\000\099\000\199\000\000\000\
\\001\000\101\000\169\000\000\000\
\\001\000\103\000\198\000\000\000\
\\001\000\105\000\197\000\000\000\
\\001\000\107\000\255\000\000\000\
\\001\000\108\000\003\001\112\000\002\001\000\000\
\\001\000\111\000\192\000\000\000\
\\001\000\114\000\083\000\000\000\
\\001\000\115\000\242\000\000\000\
\\001\000\116\000\195\000\000\000\
\\001\000\119\000\191\000\000\000\
\\001\000\121\000\190\000\000\000\
\\001\000\123\000\185\000\000\000\
\\001\000\125\000\183\000\000\000\
\\029\001\000\000\
\\030\001\062\000\004\000\000\000\
\\031\001\000\000\
\\032\001\063\000\109\000\000\000\
\\033\001\000\000\
\\034\001\000\000\
\\035\001\059\000\007\000\000\000\
\\036\001\000\000\
\\037\001\060\000\085\000\000\000\
\\038\001\000\000\
\\039\001\000\000\
\\040\001\011\000\016\000\068\000\015\000\073\000\014\000\078\000\013\000\
\\090\000\012\000\100\000\011\000\000\000\
\\041\001\000\000\
\\042\001\000\000\
\\043\001\000\000\
\\044\001\000\000\
\\045\001\000\000\
\\046\001\000\000\
\\047\001\000\000\
\\048\001\000\000\
\\049\001\017\000\107\000\000\000\
\\050\001\000\000\
\\051\001\000\000\
\\052\001\000\000\
\\053\001\000\000\
\\054\001\000\000\
\\055\001\000\000\
\\056\001\000\000\
\\057\001\000\000\
\\058\001\002\000\081\000\004\000\080\000\006\000\079\000\009\000\078\000\
\\012\000\077\000\014\000\076\000\018\000\074\000\021\000\073\000\
\\023\000\072\000\025\000\071\000\029\000\070\000\031\000\069\000\
\\033\000\068\000\035\000\067\000\039\000\066\000\041\000\065\000\
\\043\000\064\000\045\000\063\000\047\000\062\000\049\000\061\000\
\\051\000\060\000\053\000\059\000\055\000\058\000\057\000\057\000\
\\061\000\056\000\064\000\055\000\066\000\054\000\067\000\053\000\
\\068\000\098\000\069\000\052\000\074\000\051\000\076\000\050\000\
\\079\000\049\000\083\000\048\000\085\000\047\000\086\000\046\000\
\\088\000\045\000\090\000\097\000\092\000\044\000\094\000\043\000\
\\096\000\042\000\098\000\041\000\102\000\040\000\104\000\039\000\
\\106\000\038\000\110\000\037\000\118\000\036\000\120\000\035\000\
\\122\000\034\000\124\000\033\000\126\000\032\000\127\000\031\000\
\\128\000\030\000\000\000\
\\059\001\000\000\
\\060\001\000\000\
\\061\001\000\000\
\\062\001\000\000\
\\063\001\000\000\
\\064\001\004\000\080\000\014\000\076\000\021\000\073\000\031\000\069\000\
\\033\000\068\000\035\000\067\000\045\000\063\000\047\000\062\000\
\\049\000\061\000\051\000\060\000\053\000\059\000\055\000\058\000\
\\057\000\057\000\061\000\056\000\068\000\098\000\076\000\050\000\
\\079\000\049\000\083\000\048\000\084\000\103\000\086\000\046\000\
\\106\000\038\000\122\000\034\000\000\000\
\\064\001\004\000\080\000\014\000\076\000\021\000\073\000\031\000\069\000\
\\033\000\068\000\035\000\067\000\045\000\063\000\047\000\062\000\
\\049\000\061\000\051\000\060\000\053\000\059\000\055\000\058\000\
\\057\000\057\000\061\000\056\000\068\000\098\000\076\000\050\000\
\\079\000\049\000\083\000\048\000\084\000\173\000\086\000\046\000\
\\106\000\038\000\122\000\034\000\000\000\
\\064\001\004\000\080\000\014\000\076\000\021\000\073\000\031\000\069\000\
\\033\000\068\000\035\000\067\000\045\000\063\000\047\000\062\000\
\\049\000\061\000\051\000\060\000\053\000\059\000\055\000\058\000\
\\057\000\057\000\061\000\056\000\068\000\098\000\076\000\050\000\
\\079\000\049\000\083\000\048\000\084\000\178\000\086\000\046\000\
\\106\000\038\000\122\000\034\000\000\000\
\\065\001\000\000\
\\066\001\000\000\
\\067\001\000\000\
\\068\001\000\000\
\\069\001\000\000\
\\070\001\000\000\
\\071\001\000\000\
\\072\001\000\000\
\\073\001\000\000\
\\074\001\000\000\
\\075\001\000\000\
\\076\001\002\000\081\000\006\000\079\000\009\000\078\000\012\000\077\000\
\\018\000\074\000\023\000\072\000\025\000\071\000\029\000\070\000\
\\039\000\066\000\041\000\065\000\043\000\064\000\064\000\055\000\
\\066\000\054\000\067\000\053\000\069\000\052\000\074\000\051\000\
\\083\000\048\000\085\000\047\000\088\000\045\000\090\000\097\000\
\\092\000\044\000\094\000\043\000\096\000\042\000\098\000\041\000\
\\102\000\040\000\104\000\039\000\110\000\037\000\118\000\036\000\
\\120\000\035\000\124\000\033\000\126\000\032\000\127\000\031\000\
\\128\000\030\000\000\000\
\\077\001\000\000\
\\078\001\000\000\
\\079\001\000\000\
\\080\001\083\000\048\000\084\000\239\000\000\000\
\\080\001\083\000\048\000\084\000\012\001\000\000\
\\081\001\000\000\
\\082\001\000\000\
\\083\001\000\000\
\\084\001\000\000\
\\085\001\000\000\
\\086\001\000\000\
\\087\001\000\000\
\\088\001\000\000\
\\089\001\000\000\
\\090\001\000\000\
\\091\001\000\000\
\\092\001\000\000\
\\093\001\000\000\
\\094\001\000\000\
\\095\001\000\000\
\\096\001\000\000\
\\097\001\000\000\
\\098\001\000\000\
\\099\001\071\000\115\000\000\000\
\\100\001\000\000\
\\101\001\000\000\
\\102\001\027\000\151\000\037\000\150\000\000\000\
\\103\001\000\000\
\\104\001\000\000\
\\105\001\000\000\
\\106\001\002\000\081\000\006\000\079\000\009\000\078\000\012\000\077\000\
\\014\000\076\000\018\000\074\000\021\000\073\000\023\000\072\000\
\\025\000\071\000\029\000\070\000\031\000\069\000\033\000\068\000\
\\035\000\067\000\039\000\066\000\041\000\065\000\043\000\064\000\
\\045\000\063\000\061\000\056\000\064\000\055\000\066\000\054\000\
\\067\000\053\000\068\000\098\000\069\000\052\000\074\000\051\000\
\\076\000\050\000\079\000\049\000\083\000\048\000\085\000\047\000\
\\086\000\046\000\088\000\045\000\090\000\097\000\092\000\044\000\
\\094\000\043\000\096\000\042\000\098\000\041\000\102\000\040\000\
\\104\000\039\000\106\000\038\000\110\000\037\000\118\000\036\000\
\\120\000\035\000\122\000\034\000\124\000\033\000\126\000\032\000\
\\127\000\031\000\128\000\030\000\000\000\
\\107\001\000\000\
\\108\001\000\000\
\\109\001\000\000\
\\110\001\000\000\
\\111\001\014\000\076\000\021\000\073\000\031\000\069\000\033\000\068\000\
\\035\000\067\000\045\000\063\000\061\000\056\000\068\000\098\000\
\\076\000\050\000\079\000\049\000\083\000\048\000\084\000\252\000\
\\086\000\046\000\106\000\038\000\122\000\034\000\000\000\
\\111\001\014\000\076\000\021\000\073\000\031\000\069\000\033\000\068\000\
\\035\000\067\000\045\000\063\000\061\000\056\000\068\000\098\000\
\\076\000\050\000\079\000\049\000\083\000\048\000\084\000\016\001\
\\086\000\046\000\106\000\038\000\122\000\034\000\000\000\
\\112\001\000\000\
\\113\001\000\000\
\\114\001\000\000\
\\115\001\072\000\248\000\000\000\
\\116\001\000\000\
\\117\001\038\000\008\001\000\000\
\\118\001\000\000\
\\119\001\028\000\010\001\000\000\
\\120\001\000\000\
\\121\001\000\000\
\\122\001\019\000\120\000\000\000\
\\123\001\000\000\
\\124\001\116\000\195\000\000\000\
\\125\001\000\000\
\\126\001\117\000\020\001\000\000\
\\127\001\000\000\
\\128\001\108\000\003\001\112\000\002\001\000\000\
\\129\001\000\000\
\\130\001\000\000\
\\131\001\113\000\026\001\000\000\
\\132\001\000\000\
\\133\001\109\000\027\001\000\000\
\\134\001\000\000\
\\135\001\002\000\081\000\006\000\079\000\009\000\078\000\012\000\077\000\
\\018\000\074\000\023\000\072\000\025\000\071\000\029\000\070\000\
\\039\000\066\000\041\000\065\000\043\000\064\000\064\000\055\000\
\\066\000\054\000\067\000\053\000\069\000\052\000\074\000\051\000\
\\085\000\047\000\088\000\045\000\090\000\097\000\092\000\044\000\
\\094\000\043\000\096\000\042\000\098\000\041\000\102\000\040\000\
\\104\000\039\000\110\000\037\000\118\000\036\000\120\000\035\000\
\\124\000\033\000\126\000\032\000\127\000\031\000\128\000\030\000\000\000\
\\136\001\000\000\
\\137\001\000\000\
\\138\001\000\000\
\\139\001\000\000\
\\140\001\000\000\
\\141\001\000\000\
\\142\001\000\000\
\\143\001\000\000\
\\144\001\000\000\
\\145\001\000\000\
\\146\001\000\000\
\\147\001\000\000\
\\148\001\000\000\
\\149\001\000\000\
\\150\001\000\000\
\\151\001\000\000\
\\152\001\000\000\
\\153\001\000\000\
\\154\001\000\000\
\\155\001\000\000\
\\156\001\000\000\
\\157\001\000\000\
\\158\001\000\000\
\\159\001\000\000\
\\160\001\000\000\
\\161\001\000\000\
\\162\001\000\000\
\\163\001\000\000\
\\164\001\000\000\
\\165\001\000\000\
\\166\001\000\000\
\\167\001\000\000\
\\168\001\000\000\
\\169\001\008\000\134\000\000\000\
\\170\001\000\000\
\\171\001\000\000\
\\172\001\000\000\
\\173\001\000\000\
\\174\001\081\000\127\000\000\000\
\\175\001\000\000\
\\176\001\082\000\006\001\000\000\
\\177\001\000\000\
\\178\001\000\000\
\\179\001\126\000\032\000\127\000\031\000\128\000\030\000\000\000\
\\180\001\000\000\
\\181\001\000\000\
\\182\001\000\000\
\\183\001\000\000\
\"
val actionRowNumbers =
"\053\000\058\000\054\000\063\000\
\\001\000\059\000\063\000\045\000\
\\060\000\206\000\206\000\065\000\
\\066\000\067\000\068\000\164\000\
\\168\000\167\000\166\000\165\000\
\\081\000\110\000\109\000\087\000\
\\081\000\081\000\072\000\055\000\
\\210\000\209\000\208\000\162\000\
\\125\000\162\000\162\000\206\000\
\\149\000\162\000\162\000\162\000\
\\162\000\162\000\201\000\162\000\
\\162\000\195\000\162\000\125\000\
\\125\000\196\000\162\000\198\000\
\\189\000\162\000\115\000\162\000\
\\162\000\162\000\162\000\162\000\
\\162\000\081\000\162\000\162\000\
\\162\000\128\000\081\000\125\000\
\\162\000\162\000\162\000\081\000\
\\193\000\081\000\081\000\162\000\
\\162\000\162\000\101\000\162\000\
\\064\000\206\000\057\000\061\000\
\\206\000\205\000\039\000\033\000\
\\081\000\169\000\088\000\081\000\
\\117\000\081\000\076\000\206\000\
\\118\000\089\000\081\000\081\000\
\\080\000\081\000\078\000\077\000\
\\071\000\073\000\052\000\056\000\
\\162\000\161\000\051\000\125\000\
\\050\000\132\000\049\000\048\000\
\\044\000\047\000\162\000\041\000\
\\040\000\038\000\037\000\036\000\
\\035\000\206\000\032\000\031\000\
\\119\000\030\000\029\000\028\000\
\\196\000\027\000\026\000\025\000\
\\024\000\023\000\022\000\021\000\
\\020\000\074\000\019\000\018\000\
\\017\000\016\000\128\000\015\000\
\\162\000\132\000\014\000\013\000\
\\012\000\011\000\010\000\009\000\
\\075\000\007\000\006\000\005\000\
\\004\000\101\000\105\000\003\000\
\\002\000\046\000\207\000\069\000\
\\070\000\082\000\086\000\081\000\
\\084\000\083\000\034\000\093\000\
\\081\000\091\000\090\000\079\000\
\\163\000\186\000\126\000\120\000\
\\132\000\142\000\137\000\132\000\
\\174\000\171\000\200\000\151\000\
\\042\000\043\000\008\000\179\000\
\\178\000\181\000\175\000\177\000\
\\199\000\203\000\184\000\148\000\
\\121\000\123\000\194\000\197\000\
\\185\000\172\000\099\000\098\000\
\\097\000\096\000\095\000\094\000\
\\114\000\192\000\191\000\180\000\
\\129\000\124\000\144\000\146\000\
\\111\000\122\000\183\000\182\000\
\\187\000\112\000\113\000\176\000\
\\173\000\190\000\102\000\106\000\
\\104\000\101\000\100\000\188\000\
\\063\000\085\000\170\000\092\000\
\\133\000\127\000\143\000\136\000\
\\138\000\132\000\132\000\134\000\
\\152\000\116\000\155\000\153\000\
\\081\000\081\000\150\000\201\000\
\\204\000\130\000\145\000\131\000\
\\147\000\108\000\101\000\103\000\
\\062\000\141\000\132\000\139\000\
\\135\000\156\000\154\000\158\000\
\\160\000\202\000\107\000\140\000\
\\157\000\159\000\000\000"
val gotoT =
"\
\\001\000\026\001\002\000\001\000\000\000\
\\004\000\004\000\005\000\003\000\000\000\
\\000\000\
\\007\000\008\000\008\000\007\000\009\000\006\000\000\000\
\\010\000\027\000\014\000\026\000\017\000\025\000\020\000\024\000\
\\022\000\023\000\023\000\022\000\033\000\021\000\041\000\020\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\008\000\080\000\009\000\006\000\000\000\
\\000\000\
\\006\000\082\000\000\000\
\\050\000\086\000\051\000\085\000\052\000\084\000\000\000\
\\050\000\087\000\051\000\085\000\052\000\084\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\094\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\016\000\100\000\017\000\099\000\020\000\092\000\021\000\098\000\
\\022\000\097\000\023\000\022\000\033\000\021\000\000\000\
\\015\000\102\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\015\000\103\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\012\000\104\000\000\000\
\\003\000\106\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\039\000\110\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\024\000\112\000\025\000\111\000\000\000\
\\039\000\114\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\115\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\050\000\116\000\051\000\085\000\052\000\084\000\000\000\
\\034\000\117\000\000\000\
\\039\000\119\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\120\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\121\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\122\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\123\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\048\000\124\000\000\000\
\\039\000\126\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\127\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\039\000\128\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\024\000\129\000\025\000\111\000\000\000\
\\024\000\130\000\025\000\111\000\000\000\
\\046\000\131\000\000\000\
\\039\000\133\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\039\000\134\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\039\000\135\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\136\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\137\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\138\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\139\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\140\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\013\000\142\000\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\039\000\143\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\144\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\145\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\026\000\147\000\027\000\146\000\000\000\
\\013\000\150\000\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\024\000\151\000\025\000\111\000\000\000\
\\039\000\152\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\153\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\154\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\013\000\155\000\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\013\000\156\000\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\013\000\157\000\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\039\000\158\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\159\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\160\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\018\000\163\000\022\000\162\000\041\000\089\000\042\000\161\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\039\000\164\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\050\000\165\000\051\000\085\000\052\000\084\000\000\000\
\\000\000\
\\000\000\
\\051\000\166\000\052\000\084\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\169\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\016\000\170\000\017\000\099\000\020\000\092\000\021\000\098\000\
\\022\000\097\000\023\000\022\000\033\000\021\000\000\000\
\\015\000\172\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\015\000\173\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\050\000\174\000\051\000\085\000\052\000\084\000\000\000\
\\000\000\
\\016\000\175\000\017\000\099\000\020\000\092\000\021\000\098\000\
\\022\000\097\000\023\000\022\000\033\000\021\000\000\000\
\\015\000\177\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\015\000\178\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\015\000\179\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\040\000\180\000\041\000\089\000\042\000\108\000\043\000\019\000\
\\044\000\018\000\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\024\000\182\000\025\000\111\000\000\000\
\\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\185\000\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\035\000\192\000\036\000\191\000\000\000\
\\039\000\194\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\050\000\201\000\051\000\085\000\052\000\084\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\046\000\207\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\026\000\220\000\027\000\146\000\000\000\
\\000\000\
\\039\000\222\000\040\000\109\000\041\000\089\000\042\000\108\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\223\000\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\018\000\234\000\022\000\162\000\041\000\089\000\042\000\161\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\019\000\236\000\022\000\235\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\241\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\015\000\243\000\017\000\093\000\020\000\092\000\021\000\091\000\
\\022\000\090\000\023\000\022\000\033\000\021\000\041\000\089\000\
\\042\000\088\000\043\000\019\000\044\000\018\000\045\000\017\000\
\\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\244\000\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\030\000\245\000\000\000\
\\020\000\092\000\021\000\249\000\022\000\248\000\023\000\022\000\
\\029\000\247\000\033\000\021\000\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\251\000\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\035\000\252\000\036\000\191\000\000\000\
\\000\000\
\\037\000\255\000\038\000\254\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\049\000\003\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\031\000\005\001\000\000\
\\032\000\007\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\019\000\009\001\022\000\235\000\000\000\
\\000\000\
\\018\000\011\001\022\000\162\000\041\000\089\000\042\000\161\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\008\000\012\001\009\000\006\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\092\000\021\000\249\000\022\000\248\000\023\000\022\000\
\\029\000\013\001\033\000\021\000\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\015\001\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\016\001\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\037\000\017\001\038\000\254\000\000\000\
\\000\000\
\\013\000\019\001\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\013\000\020\001\015\000\141\000\017\000\093\000\020\000\092\000\
\\021\000\091\000\022\000\090\000\023\000\022\000\033\000\021\000\
\\041\000\089\000\042\000\088\000\043\000\019\000\044\000\018\000\
\\045\000\017\000\047\000\016\000\052\000\015\000\000\000\
\\000\000\
\\048\000\021\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\018\000\022\001\022\000\162\000\041\000\089\000\042\000\161\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\020\000\092\000\021\000\187\000\022\000\186\000\023\000\022\000\
\\028\000\023\001\033\000\021\000\041\000\089\000\042\000\184\000\
\\043\000\019\000\044\000\018\000\045\000\017\000\047\000\016\000\
\\052\000\015\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 283
val numrules = 155
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = int -> HTMLAttrs.context
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | ENTITY_REF of  (string)
 | CHAR_REF of  (string) | PCDATA of  (string)
 | START_UL of  (HTMLAttrVals.attrs)
 | START_TR of  (HTMLAttrVals.attrs)
 | START_TH of  (HTMLAttrVals.attrs)
 | START_TEXTAREA of  (HTMLAttrVals.attrs)
 | START_TD of  (HTMLAttrVals.attrs)
 | START_TABLE of  (HTMLAttrVals.attrs)
 | START_SELECT of  (HTMLAttrVals.attrs)
 | START_PRE of  (HTMLAttrVals.attrs)
 | TAG_PARAM of  (HTMLAttrVals.attrs)
 | START_P of  (HTMLAttrVals.attrs)
 | START_OPTION of  (HTMLAttrVals.attrs)
 | START_OL of  (HTMLAttrVals.attrs)
 | TAG_META of  (HTMLAttrVals.attrs)
 | START_MENU of  (HTMLAttrVals.attrs)
 | START_MAP of  (HTMLAttrVals.attrs)
 | TAG_LINK of  (HTMLAttrVals.attrs)
 | START_LI of  (HTMLAttrVals.attrs)
 | TAG_ISINDEX of  (HTMLAttrVals.attrs)
 | TAG_INPUT of  (HTMLAttrVals.attrs)
 | TAG_IMG of  (HTMLAttrVals.attrs) | TAG_HR of  (HTMLAttrVals.attrs)
 | START_H6 of  (HTMLAttrVals.attrs)
 | START_H5 of  (HTMLAttrVals.attrs)
 | START_H4 of  (HTMLAttrVals.attrs)
 | START_H3 of  (HTMLAttrVals.attrs)
 | START_H2 of  (HTMLAttrVals.attrs)
 | START_H1 of  (HTMLAttrVals.attrs)
 | START_FORM of  (HTMLAttrVals.attrs)
 | START_BASEFONT of  (HTMLAttrVals.attrs)
 | START_FONT of  (HTMLAttrVals.attrs)
 | START_DL of  (HTMLAttrVals.attrs)
 | START_DIV of  (HTMLAttrVals.attrs)
 | START_DIR of  (HTMLAttrVals.attrs)
 | START_CAPTION of  (HTMLAttrVals.attrs)
 | TAG_BR of  (HTMLAttrVals.attrs)
 | START_BODY of  (HTMLAttrVals.attrs)
 | TAG_BASE of  (HTMLAttrVals.attrs)
 | TAG_AREA of  (HTMLAttrVals.attrs)
 | START_APPLET of  (HTMLAttrVals.attrs)
 | START_A of  (HTMLAttrVals.attrs) | PCDataElem of  (HTML.pcdata)
 | PCDataList of  (HTML.pcdata list) | PCData of  (HTML.pcdata)
 | OptionList of  (HTML.select_option list) | Form of  (HTML.text)
 | AreaList of  (HTML.area list) | Special of  (HTML.text)
 | Phrase of  (HTML.text) | Font of  (HTML.text)
 | Text of  (HTML.text) | TextWOScript of  (HTML.text)
 | TextList' of  (HTML.text list) | TextList of  (HTML.text)
 | TableCell of  (HTML.table_cell)
 | TableCellList of  (HTML.table_cell list) | TableRow of  (HTML.tr)
 | TableRowList of  (HTML.tr list)
 | optCaption of  (HTML.caption option)
 | Preformatted of  (HTML.block) | Flow2 of  (blklist_item list)
 | Flow1 of  (blklist_item list) | DLItem of  (deflist_item)
 | DLItemList of  (deflist_item list) | ListItem of  (HTML.list_item)
 | ListItemList of  (HTML.list_item list) | List of  (HTML.block)
 | Paragraph of  (HTML.block) | Block of  (HTML.block)
 | BlockWOIndex of  (HTML.block)
 | AddressContent2 of  (blklist_item list)
 | AddressContent1 of  (blklist_item list)
 | BodyElement of  (HTML.block) | BodyContent2 of  (blklist_item list)
 | BodyContent1 of  (blklist_item list) | BodyContent0 of  (HTML.body)
 | BodyContent of  (HTML.block) | Body of  (HTML.body)
 | HeadElement of  (HTML.head_content)
 | HeadElements of  (HTML.head_content list)
 | HeadContents of  (HTML.head_content list)
 | Head of  (HTML.head_content list)
 | StartHTML of  (HTML.cdata option) | Document of  (HTML.html)
end
type svalue = MlyValue.svalue
type result = HTML.html
end
structure EC=
struct
open LrTable
val is_keyword =
fn _ => false
val preferred_change = 
nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "START_A"
  | (T 2) => "END_A"
  | (T 3) => "START_ADDRESS"
  | (T 4) => "END_ADDRESS"
  | (T 5) => "START_APPLET"
  | (T 6) => "END_APPLET"
  | (T 7) => "TAG_AREA"
  | (T 8) => "START_B"
  | (T 9) => "END_B"
  | (T 10) => "TAG_BASE"
  | (T 11) => "START_BIG"
  | (T 12) => "END_BIG"
  | (T 13) => "START_BLOCKQUOTE"
  | (T 14) => "END_BLOCKQUOTE"
  | (T 15) => "START_BODY"
  | (T 16) => "END_BODY"
  | (T 17) => "TAG_BR"
  | (T 18) => "START_CAPTION"
  | (T 19) => "END_CAPTION"
  | (T 20) => "START_CENTER"
  | (T 21) => "END_CENTER"
  | (T 22) => "START_CITE"
  | (T 23) => "END_CITE"
  | (T 24) => "START_CODE"
  | (T 25) => "END_CODE"
  | (T 26) => "START_DD"
  | (T 27) => "END_DD"
  | (T 28) => "START_DFN"
  | (T 29) => "END_DFN"
  | (T 30) => "START_DIR"
  | (T 31) => "END_DIR"
  | (T 32) => "START_DIV"
  | (T 33) => "END_DIV"
  | (T 34) => "START_DL"
  | (T 35) => "END_DL"
  | (T 36) => "START_DT"
  | (T 37) => "END_DT"
  | (T 38) => "START_EM"
  | (T 39) => "END_EM"
  | (T 40) => "START_FONT"
  | (T 41) => "END_FONT"
  | (T 42) => "START_BASEFONT"
  | (T 43) => "END_BASEFONT"
  | (T 44) => "START_FORM"
  | (T 45) => "END_FORM"
  | (T 46) => "START_H1"
  | (T 47) => "END_H1"
  | (T 48) => "START_H2"
  | (T 49) => "END_H2"
  | (T 50) => "START_H3"
  | (T 51) => "END_H3"
  | (T 52) => "START_H4"
  | (T 53) => "END_H4"
  | (T 54) => "START_H5"
  | (T 55) => "END_H5"
  | (T 56) => "START_H6"
  | (T 57) => "END_H6"
  | (T 58) => "START_HEAD"
  | (T 59) => "END_HEAD"
  | (T 60) => "TAG_HR"
  | (T 61) => "START_HTML"
  | (T 62) => "END_HTML"
  | (T 63) => "START_I"
  | (T 64) => "END_I"
  | (T 65) => "TAG_IMG"
  | (T 66) => "TAG_INPUT"
  | (T 67) => "TAG_ISINDEX"
  | (T 68) => "START_KBD"
  | (T 69) => "END_KBD"
  | (T 70) => "START_LI"
  | (T 71) => "END_LI"
  | (T 72) => "TAG_LINK"
  | (T 73) => "START_MAP"
  | (T 74) => "END_MAP"
  | (T 75) => "START_MENU"
  | (T 76) => "END_MENU"
  | (T 77) => "TAG_META"
  | (T 78) => "START_OL"
  | (T 79) => "END_OL"
  | (T 80) => "START_OPTION"
  | (T 81) => "END_OPTION"
  | (T 82) => "START_P"
  | (T 83) => "END_P"
  | (T 84) => "TAG_PARAM"
  | (T 85) => "START_PRE"
  | (T 86) => "END_PRE"
  | (T 87) => "START_SAMP"
  | (T 88) => "END_SAMP"
  | (T 89) => "START_SCRIPT"
  | (T 90) => "END_SCRIPT"
  | (T 91) => "START_SELECT"
  | (T 92) => "END_SELECT"
  | (T 93) => "START_SMALL"
  | (T 94) => "END_SMALL"
  | (T 95) => "START_STRIKE"
  | (T 96) => "END_STRIKE"
  | (T 97) => "START_STRONG"
  | (T 98) => "END_STRONG"
  | (T 99) => "START_STYLE"
  | (T 100) => "END_STYLE"
  | (T 101) => "START_SUB"
  | (T 102) => "END_SUB"
  | (T 103) => "START_SUP"
  | (T 104) => "END_SUP"
  | (T 105) => "START_TABLE"
  | (T 106) => "END_TABLE"
  | (T 107) => "START_TD"
  | (T 108) => "END_TD"
  | (T 109) => "START_TEXTAREA"
  | (T 110) => "END_TEXTAREA"
  | (T 111) => "START_TH"
  | (T 112) => "END_TH"
  | (T 113) => "START_TITLE"
  | (T 114) => "END_TITLE"
  | (T 115) => "START_TR"
  | (T 116) => "END_TR"
  | (T 117) => "START_TT"
  | (T 118) => "END_TT"
  | (T 119) => "START_U"
  | (T 120) => "END_U"
  | (T 121) => "START_UL"
  | (T 122) => "END_UL"
  | (T 123) => "START_VAR"
  | (T 124) => "END_VAR"
  | (T 125) => "PCDATA"
  | (T 126) => "CHAR_REF"
  | (T 127) => "ENTITY_REF"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 1) => MlyValue.START_A(([])) | 
(T 5) => MlyValue.START_APPLET((
[
    ("CODE", HTMLAttrs.NAME ""),
    ("WIDTH", HTMLAttrs.NAME ""),
    ("HEIGHT", HTMLAttrs.NAME "")
  ]
)) | 
(T 7) => MlyValue.TAG_AREA(([("ALT", HTMLAttrs.NAME "")])) | 
(T 10) => MlyValue.TAG_BASE(([("URL", HTMLAttrs.NAME "")])) | 
(T 15) => MlyValue.START_BODY(([])) | 
(T 17) => MlyValue.TAG_BR(([])) | 
(T 18) => MlyValue.START_CAPTION(([])) | 
(T 30) => MlyValue.START_DIR(([])) | 
(T 32) => MlyValue.START_DIV(([])) | 
(T 34) => MlyValue.START_DL(([])) | 
(T 40) => MlyValue.START_FONT(([])) | 
(T 42) => MlyValue.START_BASEFONT(([])) | 
(T 44) => MlyValue.START_FORM(([])) | 
(T 46) => MlyValue.START_H1(([])) | 
(T 48) => MlyValue.START_H2(([])) | 
(T 50) => MlyValue.START_H3(([])) | 
(T 52) => MlyValue.START_H4(([])) | 
(T 54) => MlyValue.START_H5(([])) | 
(T 56) => MlyValue.START_H6(([])) | 
(T 60) => MlyValue.TAG_HR(([])) | 
(T 65) => MlyValue.TAG_IMG(([("SRC", HTMLAttrs.NAME "")])) | 
(T 66) => MlyValue.TAG_INPUT(([])) | 
(T 67) => MlyValue.TAG_ISINDEX(([])) | 
(T 72) => MlyValue.TAG_LINK(([])) | 
(T 73) => MlyValue.START_MAP(([])) | 
(T 75) => MlyValue.START_MENU(([])) | 
(T 77) => MlyValue.TAG_META(([("CONTENT", HTMLAttrs.NAME "")])) | 
(T 78) => MlyValue.START_OL(([])) | 
(T 80) => MlyValue.START_OPTION(([])) | 
(T 82) => MlyValue.START_P(([])) | 
(T 84) => MlyValue.TAG_PARAM(([("NAME", HTMLAttrs.NAME "")])) | 
(T 85) => MlyValue.START_PRE(([])) | 
(T 91) => MlyValue.START_SELECT(([("NAME", HTMLAttrs.NAME "")])) | 
(T 105) => MlyValue.START_TABLE(([])) | 
(T 107) => MlyValue.START_TD(([])) | 
(T 109) => MlyValue.START_TEXTAREA((
[
    ("NAME", HTMLAttrs.NAME ""),
    ("ROWS", HTMLAttrs.NAME "0"),
    ("COLS", HTMLAttrs.NAME "0")
  ]
)) | 
(T 111) => MlyValue.START_TH(([])) | 
(T 115) => MlyValue.START_TR(([])) | 
(T 121) => MlyValue.START_UL(([])) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 2) :: (T 3) :: (T 4) :: (T 6) :: (T 8) :: (T 9
) :: (T 11) :: (T 12) :: (T 13) :: (T 14) :: (T 16) :: (T 19) :: (T 20
) :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: (T 26) :: (T 27
) :: (T 28) :: (T 29) :: (T 31) :: (T 33) :: (T 35) :: (T 36) :: (T 37
) :: (T 38) :: (T 39) :: (T 41) :: (T 43) :: (T 45) :: (T 47) :: (T 49
) :: (T 51) :: (T 53) :: (T 55) :: (T 57) :: (T 58) :: (T 59) :: (T 61
) :: (T 62) :: (T 63) :: (T 64) :: (T 68) :: (T 69) :: (T 71) :: (T 74
) :: (T 76) :: (T 79) :: (T 81) :: (T 83) :: (T 86) :: (T 87) :: (T 88
) :: (T 89) :: (T 90) :: (T 92) :: (T 93) :: (T 94) :: (T 95) :: (T 96
) :: (T 97) :: (T 98) :: (T 99) :: (T 100) :: (T 101) :: (T 102) :: 
(T 103) :: (T 104) :: (T 106) :: (T 108) :: (T 110) :: (T 112) :: (T 
113) :: (T 114) :: (T 116) :: (T 117) :: (T 118) :: (T 119) :: (T 120)
 :: (T 122) :: (T 123) :: (T 124) :: nil
end
structure Actions =
struct 
exception mlyAction of int
local open Header in
val actions = 
fn (i392,defaultPos,stack,
    (ctx):arg) =>
case (i392,stack)
of (0,(_,(_,_,EndHTML1right))::(_,(MlyValue.Body Body,_,_))::(_,(
MlyValue.Head Head,_,_))::(_,(MlyValue.StartHTML StartHTML,
StartHTML1left,_))::rest671) => let val result=MlyValue.Document((
HTML.HTML{version=StartHTML, head=Head, body=Body}))
 in (LrTable.NT 0,(result,StartHTML1left,EndHTML1right),rest671) end
| (1,rest671) => let val result=MlyValue.StartHTML((NONE))
 in (LrTable.NT 1,(result,defaultPos,defaultPos),rest671) end
| (2,(_,(_,START_HTML1left,START_HTML1right))::rest671) => let val 
result=MlyValue.StartHTML((NONE))
 in (LrTable.NT 1,(result,START_HTML1left,START_HTML1right),rest671)
 end
| (3,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 2,(result,defaultPos,defaultPos),rest671) end
| (4,(_,(_,END_HTML1left,END_HTML1right))::rest671) => let val result=
MlyValue.ntVOID(())
 in (LrTable.NT 2,(result,END_HTML1left,END_HTML1right),rest671) end
| (5,(_,(_,_,EndHEAD1right))::(_,(MlyValue.HeadContents HeadContents,_
,_))::(_,(_,StartHEAD1left,_))::rest671) => let val result=
MlyValue.Head((HeadContents))
 in (LrTable.NT 3,(result,StartHEAD1left,EndHEAD1right),rest671) end
| (6,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 4,(result,defaultPos,defaultPos),rest671) end
| (7,(_,(_,START_HEAD1left,START_HEAD1right))::rest671) => let val 
result=MlyValue.ntVOID(())
 in (LrTable.NT 4,(result,START_HEAD1left,START_HEAD1right),rest671)
 end
| (8,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 5,(result,defaultPos,defaultPos),rest671) end
| (9,(_,(_,END_HEAD1left,END_HEAD1right))::rest671) => let val result=
MlyValue.ntVOID(())
 in (LrTable.NT 5,(result,END_HEAD1left,END_HEAD1right),rest671) end
| (10,(_,(MlyValue.HeadElements HeadElements2,_,HeadElements2right))::
_::(_,(MlyValue.PCData PCData,_,_))::_::(_,(MlyValue.HeadElements 
HeadElements1,HeadElements1left,_))::rest671) => let val result=
MlyValue.HeadContents((
HeadElements1 @ (HTML.Head_TITLE PCData :: HeadElements2)))
 in (LrTable.NT 6,(result,HeadElements1left,HeadElements2right),
rest671) end
| (11,rest671) => let val result=MlyValue.HeadElements(([]))
 in (LrTable.NT 7,(result,defaultPos,defaultPos),rest671) end
| (12,(_,(MlyValue.HeadElements HeadElements,_,HeadElements1right))::(
_,(MlyValue.HeadElement HeadElement,HeadElement1left,_))::rest671) => 
let val result=MlyValue.HeadElements((HeadElement :: HeadElements))
 in (LrTable.NT 7,(result,HeadElement1left,HeadElements1right),rest671
) end
| (13,(_,(MlyValue.TAG_META TAG_META,TAG_METAleft as TAG_META1left,
TAG_META1right))::rest671) => let val result=MlyValue.HeadElement((
HTMLAttrs.mkMETA(ctx TAG_METAleft, TAG_META)))
 in (LrTable.NT 8,(result,TAG_META1left,TAG_META1right),rest671) end
| (14,(_,(MlyValue.TAG_LINK TAG_LINK,TAG_LINKleft as TAG_LINK1left,
TAG_LINK1right))::rest671) => let val result=MlyValue.HeadElement((
HTMLAttrs.mkLINK(ctx TAG_LINKleft, TAG_LINK)))
 in (LrTable.NT 8,(result,TAG_LINK1left,TAG_LINK1right),rest671) end
| (15,(_,(MlyValue.TAG_ISINDEX TAG_ISINDEX,TAG_ISINDEXleft as 
TAG_ISINDEX1left,TAG_ISINDEX1right))::rest671) => let val result=
MlyValue.HeadElement((
let val stuff =
		    HTMLAttrs.mkISINDEX (ctx TAG_ISINDEXleft, TAG_ISINDEX)
		  in HTML.Head_ISINDEX stuff end
		
))
 in (LrTable.NT 8,(result,TAG_ISINDEX1left,TAG_ISINDEX1right),rest671)
 end
| (16,(_,(MlyValue.TAG_BASE TAG_BASE,TAG_BASEleft as TAG_BASE1left,
TAG_BASE1right))::rest671) => let val result=MlyValue.HeadElement((
HTMLAttrs.mkBASE(ctx TAG_BASEleft, TAG_BASE)))
 in (LrTable.NT 8,(result,TAG_BASE1left,TAG_BASE1right),rest671) end
| (17,(_,(_,_,END_STYLE1right))::(_,(MlyValue.PCData PCData,_,_))::(_,
(_,START_STYLE1left,_))::rest671) => let val result=
MlyValue.HeadElement((HTML.Head_STYLE(PCData)))
 in (LrTable.NT 8,(result,START_STYLE1left,END_STYLE1right),rest671)
 end
| (18,(_,(_,_,END_SCRIPT1right))::(_,(MlyValue.PCData PCData,_,_))::(_
,(_,START_SCRIPT1left,_))::rest671) => let val result=
MlyValue.HeadElement((HTML.Head_SCRIPT(PCData)))
 in (LrTable.NT 8,(result,START_SCRIPT1left,END_SCRIPT1right),rest671)
 end
| (19,(_,(_,_,EndBODY1right))::(_,(MlyValue.BodyContent0 BodyContent0,
BodyContent01left,_))::rest671) => let val result=MlyValue.Body((
BodyContent0))
 in (LrTable.NT 9,(result,BodyContent01left,EndBODY1right),rest671)
 end
| (20,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 11,(result,defaultPos,defaultPos),rest671) end
| (21,(_,(_,END_BODY1left,END_BODY1right))::rest671) => let val result
=MlyValue.ntVOID(())
 in (LrTable.NT 11,(result,END_BODY1left,END_BODY1right),rest671) end
| (22,(_,(MlyValue.BodyContent1 BodyContent1,BodyContent11left,
BodyContent11right))::rest671) => let val result=MlyValue.BodyContent(
(mkBlock BodyContent1))
 in (LrTable.NT 12,(result,BodyContent11left,BodyContent11right),
rest671) end
| (23,(_,(MlyValue.BodyContent BodyContent,_,BodyContent1right))::(_,(
MlyValue.START_BODY START_BODY,START_BODYleft as START_BODY1left,_))::
rest671) => let val result=MlyValue.BodyContent0((
HTMLAttrs.mkBODY(ctx START_BODYleft, START_BODY, BodyContent)))
 in (LrTable.NT 13,(result,START_BODY1left,BodyContent1right),rest671)
 end
| (24,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.TextWOScript TextWOScript,TextWOScript1left,_))::rest671)
 => let val result=MlyValue.BodyContent0((
mkBody(consText(TextWOScript, BodyContent1))))
 in (LrTable.NT 13,(result,TextWOScript1left,BodyContent11right),
rest671) end
| (25,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.BodyElement BodyElement,BodyElement1left,_))::rest671) => 
let val result=MlyValue.BodyContent0((
mkBody(consBlock(BodyElement, BodyContent1))))
 in (LrTable.NT 13,(result,BodyElement1left,BodyContent11right),
rest671) end
| (26,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.BlockWOIndex BlockWOIndex,BlockWOIndex1left,_))::rest671)
 => let val result=MlyValue.BodyContent0((
mkBody(consBlock(BlockWOIndex, BodyContent1))))
 in (LrTable.NT 13,(result,BlockWOIndex1left,BodyContent11right),
rest671) end
| (27,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::_
::(_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => 
let val result=MlyValue.BodyContent0((
mkBody(consBlock(Paragraph, BodyContent1))))
 in (LrTable.NT 13,(result,Paragraph1left,BodyContent11right),rest671)
 end
| (28,(_,(MlyValue.BodyContent2 BodyContent2,_,BodyContent21right))::(
_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => let 
val result=MlyValue.BodyContent0((
mkBody(consBlock(Paragraph, BodyContent2))))
 in (LrTable.NT 13,(result,Paragraph1left,BodyContent21right),rest671)
 end
| (29,rest671) => let val result=MlyValue.BodyContent1(([]))
 in (LrTable.NT 14,(result,defaultPos,defaultPos),rest671) end
| (30,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.Text Text,Text1left,_))::rest671) => let val result=
MlyValue.BodyContent1((consText(Text, BodyContent1)))
 in (LrTable.NT 14,(result,Text1left,BodyContent11right),rest671) end
| (31,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.BodyElement BodyElement,BodyElement1left,_))::rest671) => 
let val result=MlyValue.BodyContent1((
consBlock(BodyElement, BodyContent1)))
 in (LrTable.NT 14,(result,BodyElement1left,BodyContent11right),
rest671) end
| (32,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.Block Block,Block1left,_))::rest671) => let val result=
MlyValue.BodyContent1((consBlock(Block, BodyContent1)))
 in (LrTable.NT 14,(result,Block1left,BodyContent11right),rest671) end
| (33,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::_
::(_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => 
let val result=MlyValue.BodyContent1((
consBlock(Paragraph, BodyContent1)))
 in (LrTable.NT 14,(result,Paragraph1left,BodyContent11right),rest671)
 end
| (34,(_,(MlyValue.BodyContent2 BodyContent2,_,BodyContent21right))::(
_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => let 
val result=MlyValue.BodyContent1((consBlock(Paragraph, BodyContent2)))
 in (LrTable.NT 14,(result,Paragraph1left,BodyContent21right),rest671)
 end
| (35,rest671) => let val result=MlyValue.BodyContent2(([]))
 in (LrTable.NT 15,(result,defaultPos,defaultPos),rest671) end
| (36,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.BodyElement BodyElement,BodyElement1left,_))::rest671) => 
let val result=MlyValue.BodyContent2((
consBlock(BodyElement, BodyContent1)))
 in (LrTable.NT 15,(result,BodyElement1left,BodyContent11right),
rest671) end
| (37,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::(
_,(MlyValue.Block Block,Block1left,_))::rest671) => let val result=
MlyValue.BodyContent2((consBlock(Block, BodyContent1)))
 in (LrTable.NT 15,(result,Block1left,BodyContent11right),rest671) end
| (38,(_,(MlyValue.BodyContent1 BodyContent1,_,BodyContent11right))::_
::(_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => 
let val result=MlyValue.BodyContent2((
consBlock(Paragraph, BodyContent1)))
 in (LrTable.NT 15,(result,Paragraph1left,BodyContent11right),rest671)
 end
| (39,(_,(MlyValue.BodyContent2 BodyContent2,_,BodyContent21right))::(
_,(MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => let 
val result=MlyValue.BodyContent2((consBlock(Paragraph, BodyContent2)))
 in (LrTable.NT 15,(result,Paragraph1left,BodyContent21right),rest671)
 end
| (40,(_,(_,_,END_H11right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H1 START_H1,START_H1left as START_H11left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(1, ctx START_H1left, START_H1, TextList)))
 in (LrTable.NT 16,(result,START_H11left,END_H11right),rest671) end
| (41,(_,(_,_,END_H21right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H2 START_H2,START_H2left as START_H21left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(2, ctx START_H2left, START_H2, TextList)))
 in (LrTable.NT 16,(result,START_H21left,END_H21right),rest671) end
| (42,(_,(_,_,END_H31right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H3 START_H3,START_H3left as START_H31left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(3, ctx START_H3left, START_H3, TextList)))
 in (LrTable.NT 16,(result,START_H31left,END_H31right),rest671) end
| (43,(_,(_,_,END_H41right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H4 START_H4,START_H4left as START_H41left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(4, ctx START_H4left, START_H4, TextList)))
 in (LrTable.NT 16,(result,START_H41left,END_H41right),rest671) end
| (44,(_,(_,_,END_H51right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H5 START_H5,START_H5left as START_H51left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(5, ctx START_H5left, START_H5, TextList)))
 in (LrTable.NT 16,(result,START_H51left,END_H51right),rest671) end
| (45,(_,(_,_,END_H61right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_H6 START_H6,START_H6left as START_H61left,_))::
rest671) => let val result=MlyValue.BodyElement((
HTMLAttrs.mkHn(6, ctx START_H6left, START_H6, TextList)))
 in (LrTable.NT 16,(result,START_H61left,END_H61right),rest671) end
| (46,(_,(_,_,END_ADDRESS1right))::(_,(MlyValue.AddressContent1 
AddressContent1,_,_))::(_,(_,START_ADDRESS1left,_))::rest671) => let 
val result=MlyValue.BodyElement((HTML.ADDRESS(mkBlock AddressContent1)
))
 in (LrTable.NT 16,(result,START_ADDRESS1left,END_ADDRESS1right),
rest671) end
| (47,rest671) => let val result=MlyValue.AddressContent1(([]))
 in (LrTable.NT 17,(result,defaultPos,defaultPos),rest671) end
| (48,(_,(MlyValue.AddressContent1 AddressContent1,_,
AddressContent11right))::(_,(MlyValue.Text Text,Text1left,_))::rest671
) => let val result=MlyValue.AddressContent1((
consText(Text, AddressContent1)))
 in (LrTable.NT 17,(result,Text1left,AddressContent11right),rest671)
 end
| (49,(_,(MlyValue.AddressContent1 AddressContent1,_,
AddressContent11right))::_::(_,(MlyValue.Paragraph Paragraph,
Paragraph1left,_))::rest671) => let val result=
MlyValue.AddressContent1((consBlock(Paragraph, AddressContent1)))
 in (LrTable.NT 17,(result,Paragraph1left,AddressContent11right),
rest671) end
| (50,(_,(MlyValue.AddressContent2 AddressContent2,_,
AddressContent21right))::(_,(MlyValue.Paragraph Paragraph,
Paragraph1left,_))::rest671) => let val result=
MlyValue.AddressContent1((consBlock(Paragraph, AddressContent2)))
 in (LrTable.NT 17,(result,Paragraph1left,AddressContent21right),
rest671) end
| (51,rest671) => let val result=MlyValue.AddressContent2(([]))
 in (LrTable.NT 18,(result,defaultPos,defaultPos),rest671) end
| (52,(_,(MlyValue.AddressContent1 AddressContent1,_,
AddressContent11right))::_::(_,(MlyValue.Paragraph Paragraph,
Paragraph1left,_))::rest671) => let val result=
MlyValue.AddressContent2((consBlock(Paragraph, AddressContent1)))
 in (LrTable.NT 18,(result,Paragraph1left,AddressContent11right),
rest671) end
| (53,(_,(MlyValue.AddressContent2 AddressContent2,_,
AddressContent21right))::(_,(MlyValue.Paragraph Paragraph,
Paragraph1left,_))::rest671) => let val result=
MlyValue.AddressContent2((consBlock(Paragraph, AddressContent2)))
 in (LrTable.NT 18,(result,Paragraph1left,AddressContent21right),
rest671) end
| (54,(_,(MlyValue.List List,List1left,List1right))::rest671) => let 
val result=MlyValue.BlockWOIndex((List))
 in (LrTable.NT 19,(result,List1left,List1right),rest671) end
| (55,(_,(MlyValue.Preformatted Preformatted,Preformatted1left,
Preformatted1right))::rest671) => let val result=MlyValue.BlockWOIndex
((Preformatted))
 in (LrTable.NT 19,(result,Preformatted1left,Preformatted1right),
rest671) end
| (56,(_,(_,_,END_DIV1right))::(_,(MlyValue.BodyContent BodyContent,_,
_))::(_,(MlyValue.START_DIV START_DIV,START_DIVleft as START_DIV1left,
_))::rest671) => let val result=MlyValue.BlockWOIndex((
HTMLAttrs.mkDIV(ctx START_DIVleft, START_DIV, BodyContent)))
 in (LrTable.NT 19,(result,START_DIV1left,END_DIV1right),rest671) end
| (57,(_,(_,_,END_CENTER1right))::(_,(MlyValue.BodyContent BodyContent
,_,_))::(_,(_,START_CENTER1left,_))::rest671) => let val result=
MlyValue.BlockWOIndex((HTML.CENTER BodyContent))
 in (LrTable.NT 19,(result,START_CENTER1left,END_CENTER1right),rest671
) end
| (58,(_,(_,_,END_BLOCKQUOTE1right))::(_,(MlyValue.BodyContent 
BodyContent,_,_))::(_,(_,START_BLOCKQUOTE1left,_))::rest671) => let 
val result=MlyValue.BlockWOIndex((HTML.BLOCKQUOTE BodyContent))
 in (LrTable.NT 19,(result,START_BLOCKQUOTE1left,END_BLOCKQUOTE1right)
,rest671) end
| (59,(_,(_,_,END_FORM1right))::(_,(MlyValue.BodyContent BodyContent,_
,_))::(_,(MlyValue.START_FORM START_FORM,START_FORMleft as 
START_FORM1left,_))::rest671) => let val result=MlyValue.BlockWOIndex(
(HTMLAttrs.mkFORM(ctx START_FORMleft, START_FORM, BodyContent)))
 in (LrTable.NT 19,(result,START_FORM1left,END_FORM1right),rest671)
 end
| (60,(_,(MlyValue.TAG_HR TAG_HR,TAG_HRleft as TAG_HR1left,
TAG_HR1right))::rest671) => let val result=MlyValue.BlockWOIndex((
HTMLAttrs.mkHR(ctx TAG_HRleft, TAG_HR)))
 in (LrTable.NT 19,(result,TAG_HR1left,TAG_HR1right),rest671) end
| (61,(_,(_,_,END_TABLE1right))::(_,(MlyValue.TableRowList 
TableRowList,_,_))::(_,(MlyValue.optCaption optCaption,_,_))::(_,(
MlyValue.START_TABLE START_TABLE,START_TABLEleft as START_TABLE1left,_
))::rest671) => let val result=MlyValue.BlockWOIndex((
HTMLAttrs.mkTABLE(
		    ctx START_TABLEleft, START_TABLE,
		    {caption = optCaption, body = TableRowList})
		
))
 in (LrTable.NT 19,(result,START_TABLE1left,END_TABLE1right),rest671)
 end
| (62,(_,(MlyValue.BlockWOIndex BlockWOIndex,BlockWOIndex1left,
BlockWOIndex1right))::rest671) => let val result=MlyValue.Block((
BlockWOIndex))
 in (LrTable.NT 20,(result,BlockWOIndex1left,BlockWOIndex1right),
rest671) end
| (63,(_,(MlyValue.TAG_ISINDEX TAG_ISINDEX,TAG_ISINDEXleft as 
TAG_ISINDEX1left,TAG_ISINDEX1right))::rest671) => let val result=
MlyValue.Block((
let val stuff =
		    HTMLAttrs.mkISINDEX (ctx TAG_ISINDEXleft, TAG_ISINDEX)
		  in HTML.ISINDEX stuff end
		
))
 in (LrTable.NT 20,(result,TAG_ISINDEX1left,TAG_ISINDEX1right),rest671
) end
| (64,(_,(MlyValue.TextList TextList,_,TextList1right))::(_,(
MlyValue.START_P START_P,START_Pleft as START_P1left,_))::rest671) => 
let val result=MlyValue.Paragraph((
HTMLAttrs.mkP(ctx START_Pleft, START_P, TextList)))
 in (LrTable.NT 21,(result,START_P1left,TextList1right),rest671) end
| (65,(_,(_,_,END_UL1right))::(_,(MlyValue.ListItemList ListItemList,_
,_))::(_,(MlyValue.START_UL START_UL,START_ULleft as START_UL1left,_))
::rest671) => let val result=MlyValue.List((
HTMLAttrs.mkUL(ctx START_ULleft, START_UL, ListItemList)))
 in (LrTable.NT 22,(result,START_UL1left,END_UL1right),rest671) end
| (66,(_,(_,_,END_OL1right))::(_,(MlyValue.ListItemList ListItemList,_
,_))::(_,(MlyValue.START_OL START_OL,START_OLleft as START_OL1left,_))
::rest671) => let val result=MlyValue.List((
HTMLAttrs.mkOL(ctx START_OLleft, START_OL, ListItemList)))
 in (LrTable.NT 22,(result,START_OL1left,END_OL1right),rest671) end
| (67,(_,(_,_,END_DIR1right))::(_,(MlyValue.ListItemList ListItemList,
_,_))::(_,(MlyValue.START_DIR START_DIR,START_DIRleft as 
START_DIR1left,_))::rest671) => let val result=MlyValue.List((
HTMLAttrs.mkDIR(ctx START_DIRleft, START_DIR, ListItemList)))
 in (LrTable.NT 22,(result,START_DIR1left,END_DIR1right),rest671) end
| (68,(_,(_,_,END_MENU1right))::(_,(MlyValue.ListItemList ListItemList
,_,_))::(_,(MlyValue.START_MENU START_MENU,START_MENUleft as 
START_MENU1left,_))::rest671) => let val result=MlyValue.List((
HTMLAttrs.mkMENU(ctx START_MENUleft, START_MENU, ListItemList)))
 in (LrTable.NT 22,(result,START_MENU1left,END_MENU1right),rest671)
 end
| (69,(_,(_,_,END_DL1right))::(_,(MlyValue.DLItemList DLItemList,_,_))
::(_,(MlyValue.START_DL START_DL,START_DLleft as START_DL1left,_))::
rest671) => let val result=MlyValue.List((
HTMLAttrs.mkDL(
		  ctx START_DLleft, START_DL,
		  groupDefListContents DLItemList)
		
))
 in (LrTable.NT 22,(result,START_DL1left,END_DL1right),rest671) end
| (70,rest671) => let val result=MlyValue.ListItemList(([]))
 in (LrTable.NT 23,(result,defaultPos,defaultPos),rest671) end
| (71,(_,(MlyValue.ListItemList ListItemList,_,ListItemList1right))::(
_,(MlyValue.ListItem ListItem,ListItem1left,_))::rest671) => let val 
result=MlyValue.ListItemList((ListItem :: ListItemList))
 in (LrTable.NT 23,(result,ListItem1left,ListItemList1right),rest671)
 end
| (72,(_,(_,_,EndLI1right))::(_,(MlyValue.Flow1 Flow1,_,_))::(_,(
MlyValue.START_LI START_LI,START_LIleft as START_LI1left,_))::rest671)
 => let val result=MlyValue.ListItem((
HTMLAttrs.mkLI(ctx START_LIleft, START_LI, mkBlock Flow1)))
 in (LrTable.NT 24,(result,START_LI1left,EndLI1right),rest671) end
| (73,rest671) => let val result=MlyValue.DLItemList(([]))
 in (LrTable.NT 25,(result,defaultPos,defaultPos),rest671) end
| (74,(_,(MlyValue.DLItemList DLItemList,_,DLItemList1right))::(_,(
MlyValue.DLItem DLItem,DLItem1left,_))::rest671) => let val result=
MlyValue.DLItemList((DLItem :: DLItemList))
 in (LrTable.NT 25,(result,DLItem1left,DLItemList1right),rest671) end
| (75,(_,(_,_,EndDT1right))::(_,(MlyValue.TextList TextList,_,_))::(_,
(_,START_DT1left,_))::rest671) => let val result=MlyValue.DLItem((
DL_tag TextList))
 in (LrTable.NT 26,(result,START_DT1left,EndDT1right),rest671) end
| (76,(_,(_,_,EndDD1right))::(_,(MlyValue.Flow1 Flow1,_,_))::(_,(_,
START_DD1left,_))::rest671) => let val result=MlyValue.DLItem((
DL_item(mkBlock Flow1)))
 in (LrTable.NT 26,(result,START_DD1left,EndDD1right),rest671) end
| (77,rest671) => let val result=MlyValue.Flow1(([]))
 in (LrTable.NT 27,(result,defaultPos,defaultPos),rest671) end
| (78,(_,(MlyValue.Flow1 Flow1,_,Flow11right))::(_,(MlyValue.Text Text
,Text1left,_))::rest671) => let val result=MlyValue.Flow1((
consText(Text, Flow1)))
 in (LrTable.NT 27,(result,Text1left,Flow11right),rest671) end
| (79,(_,(MlyValue.Flow1 Flow1,_,Flow11right))::(_,(MlyValue.Block 
Block,Block1left,_))::rest671) => let val result=MlyValue.Flow1((
consBlock(Block, Flow1)))
 in (LrTable.NT 27,(result,Block1left,Flow11right),rest671) end
| (80,(_,(MlyValue.Flow1 Flow1,_,Flow11right))::_::(_,(
MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => let val 
result=MlyValue.Flow1((consBlock(Paragraph, Flow1)))
 in (LrTable.NT 27,(result,Paragraph1left,Flow11right),rest671) end
| (81,(_,(MlyValue.Flow2 Flow2,_,Flow21right))::(_,(MlyValue.Paragraph
 Paragraph,Paragraph1left,_))::rest671) => let val result=
MlyValue.Flow1((consBlock(Paragraph, Flow2)))
 in (LrTable.NT 27,(result,Paragraph1left,Flow21right),rest671) end
| (82,rest671) => let val result=MlyValue.Flow2(([]))
 in (LrTable.NT 28,(result,defaultPos,defaultPos),rest671) end
| (83,(_,(MlyValue.Flow1 Flow1,_,Flow11right))::(_,(MlyValue.Block 
Block,Block1left,_))::rest671) => let val result=MlyValue.Flow2((
consBlock(Block, Flow1)))
 in (LrTable.NT 28,(result,Block1left,Flow11right),rest671) end
| (84,(_,(MlyValue.Flow1 Flow1,_,Flow11right))::_::(_,(
MlyValue.Paragraph Paragraph,Paragraph1left,_))::rest671) => let val 
result=MlyValue.Flow2((consBlock(Paragraph, Flow1)))
 in (LrTable.NT 28,(result,Paragraph1left,Flow11right),rest671) end
| (85,(_,(MlyValue.Flow2 Flow2,_,Flow21right))::(_,(MlyValue.Paragraph
 Paragraph,Paragraph1left,_))::rest671) => let val result=
MlyValue.Flow2((consBlock(Paragraph, Flow2)))
 in (LrTable.NT 28,(result,Paragraph1left,Flow21right),rest671) end
| (86,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 29,(result,defaultPos,defaultPos),rest671) end
| (87,(_,(_,END_LI1left,END_LI1right))::rest671) => let val result=
MlyValue.ntVOID(())
 in (LrTable.NT 29,(result,END_LI1left,END_LI1right),rest671) end
| (88,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 30,(result,defaultPos,defaultPos),rest671) end
| (89,(_,(_,END_DT1left,END_DT1right))::rest671) => let val result=
MlyValue.ntVOID(())
 in (LrTable.NT 30,(result,END_DT1left,END_DT1right),rest671) end
| (90,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 31,(result,defaultPos,defaultPos),rest671) end
| (91,(_,(_,END_DD1left,END_DD1right))::rest671) => let val result=
MlyValue.ntVOID(())
 in (LrTable.NT 31,(result,END_DD1left,END_DD1right),rest671) end
| (92,(_,(_,_,END_PRE1right))::(_,(MlyValue.TextList TextList,_,_))::(
_,(MlyValue.START_PRE START_PRE,START_PREleft as START_PRE1left,_))::
rest671) => let val result=MlyValue.Preformatted((
HTMLAttrs.mkPRE(ctx START_PREleft, START_PRE, TextList)))
 in (LrTable.NT 32,(result,START_PRE1left,END_PRE1right),rest671) end
| (93,rest671) => let val result=MlyValue.optCaption((NONE))
 in (LrTable.NT 33,(result,defaultPos,defaultPos),rest671) end
| (94,(_,(_,_,END_CAPTION1right))::(_,(MlyValue.TextList TextList,_,_)
)::(_,(MlyValue.START_CAPTION START_CAPTION,START_CAPTIONleft as 
START_CAPTION1left,_))::rest671) => let val result=MlyValue.optCaption
((
SOME(HTMLAttrs.mkCAPTION(
		  ctx START_CAPTIONleft, START_CAPTION, TextList))
))
 in (LrTable.NT 33,(result,START_CAPTION1left,END_CAPTION1right),
rest671) end
| (95,(_,(MlyValue.TableRow TableRow,TableRow1left,TableRow1right))::
rest671) => let val result=MlyValue.TableRowList(([TableRow]))
 in (LrTable.NT 34,(result,TableRow1left,TableRow1right),rest671) end
| (96,(_,(MlyValue.TableRowList TableRowList,_,TableRowList1right))::(
_,(MlyValue.TableRow TableRow,TableRow1left,_))::rest671) => let val 
result=MlyValue.TableRowList((TableRow :: TableRowList))
 in (LrTable.NT 34,(result,TableRow1left,TableRowList1right),rest671)
 end
| (97,(_,(MlyValue.TableCellList TableCellList,_,TableCellList1right))
::(_,(MlyValue.START_TR START_TR,START_TRleft as START_TR1left,_))::
rest671) => let val result=MlyValue.TableRow((
HTMLAttrs.mkTR(ctx START_TRleft, START_TR, TableCellList)))
 in (LrTable.NT 35,(result,START_TR1left,TableCellList1right),rest671)
 end
| (98,(_,(_,_,END_TR1right))::(_,(MlyValue.TableCellList TableCellList
,_,_))::(_,(MlyValue.START_TR START_TR,START_TRleft as START_TR1left,_
))::rest671) => let val result=MlyValue.TableRow((
HTMLAttrs.mkTR(ctx START_TRleft, START_TR, TableCellList)))
 in (LrTable.NT 35,(result,START_TR1left,END_TR1right),rest671) end
| (99,(_,(MlyValue.TableCell TableCell,TableCell1left,TableCell1right)
)::rest671) => let val result=MlyValue.TableCellList(([TableCell]))
 in (LrTable.NT 36,(result,TableCell1left,TableCell1right),rest671)
 end
| (100,(_,(MlyValue.TableCellList TableCellList,_,TableCellList1right)
)::(_,(MlyValue.TableCell TableCell,TableCell1left,_))::rest671) => 
let val result=MlyValue.TableCellList((TableCell :: TableCellList))
 in (LrTable.NT 36,(result,TableCell1left,TableCellList1right),rest671
) end
| (101,(_,(_,_,END_TH1right))::(_,(MlyValue.BodyContent BodyContent,_,
_))::(_,(MlyValue.START_TH START_TH,START_THleft as START_TH1left,_))
::rest671) => let val result=MlyValue.TableCell((
HTMLAttrs.mkTH(ctx START_THleft, START_TH, BodyContent)))
 in (LrTable.NT 37,(result,START_TH1left,END_TH1right),rest671) end
| (102,(_,(MlyValue.BodyContent BodyContent,_,BodyContent1right))::(_,
(MlyValue.START_TH START_TH,START_THleft as START_TH1left,_))::rest671
) => let val result=MlyValue.TableCell((
HTMLAttrs.mkTH(ctx START_THleft, START_TH, BodyContent)))
 in (LrTable.NT 37,(result,START_TH1left,BodyContent1right),rest671)
 end
| (103,(_,(_,_,END_TD1right))::(_,(MlyValue.BodyContent BodyContent,_,
_))::(_,(MlyValue.START_TD START_TD,START_TDleft as START_TD1left,_))
::rest671) => let val result=MlyValue.TableCell((
HTMLAttrs.mkTD(ctx START_TDleft, START_TD, BodyContent)))
 in (LrTable.NT 37,(result,START_TD1left,END_TD1right),rest671) end
| (104,(_,(MlyValue.BodyContent BodyContent,_,BodyContent1right))::(_,
(MlyValue.START_TD START_TD,START_TDleft as START_TD1left,_))::rest671
) => let val result=MlyValue.TableCell((
HTMLAttrs.mkTD(ctx START_TDleft, START_TD, BodyContent)))
 in (LrTable.NT 37,(result,START_TD1left,BodyContent1right),rest671)
 end
| (105,(_,(MlyValue.TextList' TextList',TextList'1left,TextList'1right
))::rest671) => let val result=MlyValue.TextList((textList TextList'))
 in (LrTable.NT 38,(result,TextList'1left,TextList'1right),rest671)
 end
| (106,rest671) => let val result=MlyValue.TextList'(([]))
 in (LrTable.NT 39,(result,defaultPos,defaultPos),rest671) end
| (107,(_,(MlyValue.TextList' TextList',_,TextList'1right))::(_,(
MlyValue.Text Text,Text1left,_))::rest671) => let val result=
MlyValue.TextList'((Text :: TextList'))
 in (LrTable.NT 39,(result,Text1left,TextList'1right),rest671) end
| (108,(_,(MlyValue.PCDataElem PCDataElem,PCDataElem1left,
PCDataElem1right))::rest671) => let val result=MlyValue.TextWOScript((
HTML.PCDATA PCDataElem))
 in (LrTable.NT 40,(result,PCDataElem1left,PCDataElem1right),rest671)
 end
| (109,(_,(MlyValue.Font Font,Font1left,Font1right))::rest671) => let 
val result=MlyValue.TextWOScript((Font))
 in (LrTable.NT 40,(result,Font1left,Font1right),rest671) end
| (110,(_,(MlyValue.Phrase Phrase,Phrase1left,Phrase1right))::rest671)
 => let val result=MlyValue.TextWOScript((Phrase))
 in (LrTable.NT 40,(result,Phrase1left,Phrase1right),rest671) end
| (111,(_,(MlyValue.Special Special,Special1left,Special1right))::
rest671) => let val result=MlyValue.TextWOScript((Special))
 in (LrTable.NT 40,(result,Special1left,Special1right),rest671) end
| (112,(_,(MlyValue.Form Form,Form1left,Form1right))::rest671) => let 
val result=MlyValue.TextWOScript((Form))
 in (LrTable.NT 40,(result,Form1left,Form1right),rest671) end
| (113,(_,(MlyValue.TextWOScript TextWOScript,TextWOScript1left,
TextWOScript1right))::rest671) => let val result=MlyValue.Text((
TextWOScript))
 in (LrTable.NT 41,(result,TextWOScript1left,TextWOScript1right),
rest671) end
| (114,(_,(_,_,END_SCRIPT1right))::(_,(MlyValue.PCData PCData,_,_))::(
_,(_,START_SCRIPT1left,_))::rest671) => let val result=MlyValue.Text((
HTML.SCRIPT PCData))
 in (LrTable.NT 41,(result,START_SCRIPT1left,END_SCRIPT1right),rest671
) end
| (115,(_,(_,_,END_TT1right))::(_,(MlyValue.TextList TextList,_,_))::(
_,(_,START_TT1left,_))::rest671) => let val result=MlyValue.Font((
HTML.TT(TextList)))
 in (LrTable.NT 42,(result,START_TT1left,END_TT1right),rest671) end
| (116,(_,(_,_,END_I1right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(_,START_I1left,_))::rest671) => let val result=MlyValue.Font((
HTML.I(TextList)))
 in (LrTable.NT 42,(result,START_I1left,END_I1right),rest671) end
| (117,(_,(_,_,END_B1right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(_,START_B1left,_))::rest671) => let val result=MlyValue.Font((
HTML.B(TextList)))
 in (LrTable.NT 42,(result,START_B1left,END_B1right),rest671) end
| (118,(_,(_,_,END_U1right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(_,START_U1left,_))::rest671) => let val result=MlyValue.Font((
HTML.U(TextList)))
 in (LrTable.NT 42,(result,START_U1left,END_U1right),rest671) end
| (119,(_,(_,_,END_STRIKE1right))::(_,(MlyValue.TextList TextList,_,_)
)::(_,(_,START_STRIKE1left,_))::rest671) => let val result=
MlyValue.Font((HTML.STRIKE(TextList)))
 in (LrTable.NT 42,(result,START_STRIKE1left,END_STRIKE1right),rest671
) end
| (120,(_,(_,_,END_BIG1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_BIG1left,_))::rest671) => let val result=MlyValue.Font((
HTML.BIG(TextList)))
 in (LrTable.NT 42,(result,START_BIG1left,END_BIG1right),rest671) end
| (121,(_,(_,_,END_SMALL1right))::(_,(MlyValue.TextList TextList,_,_))
::(_,(_,START_SMALL1left,_))::rest671) => let val result=MlyValue.Font
((HTML.SMALL(TextList)))
 in (LrTable.NT 42,(result,START_SMALL1left,END_SMALL1right),rest671)
 end
| (122,(_,(_,_,END_SUB1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_SUB1left,_))::rest671) => let val result=MlyValue.Font((
HTML.SUB(TextList)))
 in (LrTable.NT 42,(result,START_SUB1left,END_SUB1right),rest671) end
| (123,(_,(_,_,END_SUP1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_SUP1left,_))::rest671) => let val result=MlyValue.Font((
HTML.SUP(TextList)))
 in (LrTable.NT 42,(result,START_SUP1left,END_SUP1right),rest671) end
| (124,(_,(_,_,END_EM1right))::(_,(MlyValue.TextList TextList,_,_))::(
_,(_,START_EM1left,_))::rest671) => let val result=MlyValue.Phrase((
HTML.EM(TextList)))
 in (LrTable.NT 43,(result,START_EM1left,END_EM1right),rest671) end
| (125,(_,(_,_,END_STRONG1right))::(_,(MlyValue.TextList TextList,_,_)
)::(_,(_,START_STRONG1left,_))::rest671) => let val result=
MlyValue.Phrase((HTML.STRONG(TextList)))
 in (LrTable.NT 43,(result,START_STRONG1left,END_STRONG1right),rest671
) end
| (126,(_,(_,_,END_CODE1right))::(_,(MlyValue.TextList TextList,_,_))
::(_,(_,START_CODE1left,_))::rest671) => let val result=
MlyValue.Phrase((HTML.CODE(TextList)))
 in (LrTable.NT 43,(result,START_CODE1left,END_CODE1right),rest671)
 end
| (127,(_,(_,_,END_DFN1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_DFN1left,_))::rest671) => let val result=MlyValue.Phrase((
HTML.DFN(TextList)))
 in (LrTable.NT 43,(result,START_DFN1left,END_DFN1right),rest671) end
| (128,(_,(_,_,END_SAMP1right))::(_,(MlyValue.TextList TextList,_,_))
::(_,(_,START_SAMP1left,_))::rest671) => let val result=
MlyValue.Phrase((HTML.SAMP(TextList)))
 in (LrTable.NT 43,(result,START_SAMP1left,END_SAMP1right),rest671)
 end
| (129,(_,(_,_,END_KBD1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_KBD1left,_))::rest671) => let val result=MlyValue.Phrase((
HTML.KBD(TextList)))
 in (LrTable.NT 43,(result,START_KBD1left,END_KBD1right),rest671) end
| (130,(_,(_,_,END_VAR1right))::(_,(MlyValue.TextList TextList,_,_))::
(_,(_,START_VAR1left,_))::rest671) => let val result=MlyValue.Phrase((
HTML.VAR(TextList)))
 in (LrTable.NT 43,(result,START_VAR1left,END_VAR1right),rest671) end
| (131,(_,(_,_,END_CITE1right))::(_,(MlyValue.TextList TextList,_,_))
::(_,(_,START_CITE1left,_))::rest671) => let val result=
MlyValue.Phrase((HTML.CITE(TextList)))
 in (LrTable.NT 43,(result,START_CITE1left,END_CITE1right),rest671)
 end
| (132,(_,(_,_,END_A1right))::(_,(MlyValue.TextList TextList,_,_))::(_
,(MlyValue.START_A START_A,START_Aleft as START_A1left,_))::rest671)
 => let val result=MlyValue.Special((
HTMLAttrs.mkA(ctx START_Aleft, START_A, TextList)))
 in (LrTable.NT 44,(result,START_A1left,END_A1right),rest671) end
| (133,(_,(MlyValue.TAG_IMG TAG_IMG,TAG_IMGleft as TAG_IMG1left,
TAG_IMG1right))::rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkIMG(ctx TAG_IMGleft, TAG_IMG)))
 in (LrTable.NT 44,(result,TAG_IMG1left,TAG_IMG1right),rest671) end
| (134,(_,(_,_,END_APPLET1right))::(_,(MlyValue.TextList TextList,_,_)
)::(_,(MlyValue.START_APPLET START_APPLET,START_APPLETleft as 
START_APPLET1left,_))::rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkAPPLET(ctx START_APPLETleft, START_APPLET, TextList)))
 in (LrTable.NT 44,(result,START_APPLET1left,END_APPLET1right),rest671
) end
| (135,(_,(_,_,END_FONT1right))::(_,(MlyValue.TextList TextList,_,_))
::(_,(MlyValue.START_FONT START_FONT,START_FONTleft as START_FONT1left
,_))::rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkFONT(ctx START_FONTleft, START_FONT, TextList)))
 in (LrTable.NT 44,(result,START_FONT1left,END_FONT1right),rest671)
 end
| (136,(_,(_,_,END_BASEFONT1right))::(_,(MlyValue.TextList TextList,_,
_))::(_,(MlyValue.START_BASEFONT START_BASEFONT,START_BASEFONTleft as 
START_BASEFONT1left,_))::rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkBASEFONT(
		  ctx START_BASEFONTleft, START_BASEFONT, TextList)
		
))
 in (LrTable.NT 44,(result,START_BASEFONT1left,END_BASEFONT1right),
rest671) end
| (137,(_,(MlyValue.TAG_BR TAG_BR,TAG_BRleft as TAG_BR1left,
TAG_BR1right))::rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkBR(ctx TAG_BRleft, TAG_BR)))
 in (LrTable.NT 44,(result,TAG_BR1left,TAG_BR1right),rest671) end
| (138,(_,(_,_,END_MAP1right))::(_,(MlyValue.AreaList AreaList,_,_))::
(_,(MlyValue.START_MAP START_MAP,START_MAPleft as START_MAP1left,_))::
rest671) => let val result=MlyValue.Special((
HTMLAttrs.mkMAP(ctx START_MAPleft, START_MAP, AreaList)))
 in (LrTable.NT 44,(result,START_MAP1left,END_MAP1right),rest671) end
| (139,(_,(MlyValue.TAG_PARAM TAG_PARAM,TAG_PARAMleft as 
TAG_PARAM1left,TAG_PARAM1right))::rest671) => let val result=
MlyValue.Special((HTMLAttrs.mkPARAM(ctx TAG_PARAMleft, TAG_PARAM)))
 in (LrTable.NT 44,(result,TAG_PARAM1left,TAG_PARAM1right),rest671)
 end
| (140,rest671) => let val result=MlyValue.AreaList(([]))
 in (LrTable.NT 45,(result,defaultPos,defaultPos),rest671) end
| (141,(_,(MlyValue.AreaList AreaList,_,AreaList1right))::(_,(
MlyValue.TAG_AREA TAG_AREA,TAG_AREAleft as TAG_AREA1left,_))::rest671)
 => let val result=MlyValue.AreaList((
HTMLAttrs.mkAREA(ctx TAG_AREAleft, TAG_AREA) :: AreaList))
 in (LrTable.NT 45,(result,TAG_AREA1left,AreaList1right),rest671) end
| (142,(_,(MlyValue.TAG_INPUT TAG_INPUT,TAG_INPUTleft as 
TAG_INPUT1left,TAG_INPUT1right))::rest671) => let val result=
MlyValue.Form((HTMLAttrs.mkINPUT(ctx TAG_INPUTleft, TAG_INPUT)))
 in (LrTable.NT 46,(result,TAG_INPUT1left,TAG_INPUT1right),rest671)
 end
| (143,(_,(_,_,END_SELECT1right))::(_,(MlyValue.OptionList OptionList,
_,_))::(_,(MlyValue.START_SELECT START_SELECT,START_SELECTleft as 
START_SELECT1left,_))::rest671) => let val result=MlyValue.Form((
HTMLAttrs.mkSELECT(ctx START_SELECTleft, START_SELECT, OptionList)))
 in (LrTable.NT 46,(result,START_SELECT1left,END_SELECT1right),rest671
) end
| (144,(_,(_,_,END_TEXTAREA1right))::(_,(MlyValue.PCData PCData,_,_))
::(_,(MlyValue.START_TEXTAREA START_TEXTAREA,START_TEXTAREAleft as 
START_TEXTAREA1left,_))::rest671) => let val result=MlyValue.Form((
HTMLAttrs.mkTEXTAREA(
		  ctx START_TEXTAREAleft, START_TEXTAREA,
		  PCData)
		
))
 in (LrTable.NT 46,(result,START_TEXTAREA1left,END_TEXTAREA1right),
rest671) end
| (145,rest671) => let val result=MlyValue.OptionList(([]))
 in (LrTable.NT 47,(result,defaultPos,defaultPos),rest671) end
| (146,(_,(MlyValue.OptionList OptionList,_,OptionList1right))::_::(_,
(MlyValue.PCData PCData,_,_))::(_,(MlyValue.START_OPTION START_OPTION,
START_OPTIONleft as START_OPTION1left,_))::rest671) => let val result=
MlyValue.OptionList((
HTMLAttrs.mkOPTION(ctx START_OPTIONleft, START_OPTION, PCData)
		  :: OptionList
		
))
 in (LrTable.NT 47,(result,START_OPTION1left,OptionList1right),rest671
) end
| (147,rest671) => let val result=MlyValue.ntVOID(())
 in (LrTable.NT 48,(result,defaultPos,defaultPos),rest671) end
| (148,(_,(_,END_OPTION1left,END_OPTION1right))::rest671) => let val 
result=MlyValue.ntVOID(())
 in (LrTable.NT 48,(result,END_OPTION1left,END_OPTION1right),rest671)
 end
| (149,(_,(MlyValue.PCDataList PCDataList,PCDataList1left,
PCDataList1right))::rest671) => let val result=MlyValue.PCData((
concat PCDataList))
 in (LrTable.NT 49,(result,PCDataList1left,PCDataList1right),rest671)
 end
| (150,rest671) => let val result=MlyValue.PCDataList(([]))
 in (LrTable.NT 50,(result,defaultPos,defaultPos),rest671) end
| (151,(_,(MlyValue.PCDataList PCDataList,_,PCDataList1right))::(_,(
MlyValue.PCDataElem PCDataElem,PCDataElem1left,_))::rest671) => let 
val result=MlyValue.PCDataList((PCDataElem :: PCDataList))
 in (LrTable.NT 50,(result,PCDataElem1left,PCDataList1right),rest671)
 end
| (152,(_,(MlyValue.PCDATA PCDATA,PCDATA1left,PCDATA1right))::rest671)
 => let val result=MlyValue.PCDataElem((PCDATA))
 in (LrTable.NT 51,(result,PCDATA1left,PCDATA1right),rest671) end
| (153,(_,(MlyValue.CHAR_REF CHAR_REF,CHAR_REF1left,CHAR_REF1right))::
rest671) => let val result=MlyValue.PCDataElem((CHAR_REF))
 in (LrTable.NT 51,(result,CHAR_REF1left,CHAR_REF1right),rest671) end
| (154,(_,(MlyValue.ENTITY_REF ENTITY_REF,ENTITY_REF1left,
ENTITY_REF1right))::rest671) => let val result=MlyValue.PCDataElem((
ENTITY_REF))
 in (LrTable.NT 51,(result,ENTITY_REF1left,ENTITY_REF1right),rest671)
 end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.Document x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : HTML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun START_A (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.START_A i,p1,p2))
fun END_A (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun START_ADDRESS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun END_ADDRESS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun START_APPLET (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.START_APPLET i,p1,p2))
fun END_APPLET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_AREA (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.TAG_AREA i,p1,p2))
fun START_B (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun END_B (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_BASE (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.TAG_BASE i,p1,p2))
fun START_BIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun END_BIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun START_BLOCKQUOTE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun END_BLOCKQUOTE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun START_BODY (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.START_BODY i,p1,p2))
fun END_BODY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_BR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.TAG_BR i,p1,p2))
fun START_CAPTION (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.START_CAPTION i,p1,p2))
fun END_CAPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun START_CENTER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun END_CENTER (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun START_CITE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun END_CITE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun START_CODE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun END_CODE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun END_DD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DFN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun END_DFN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DIR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.START_DIR i,p1,p2))
fun END_DIR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DIV (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.START_DIV i,p1,p2))
fun END_DIV (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.START_DL i,p1,p2))
fun END_DL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun START_DT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun END_DT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun START_EM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun END_EM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun START_FONT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.START_FONT i,p1,p2))
fun END_FONT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun START_BASEFONT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.START_BASEFONT i,p1,p2))
fun END_BASEFONT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun START_FORM (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.START_FORM i,p1,p2))
fun END_FORM (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H1 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.START_H1 i,p1,p2))
fun END_H1 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H2 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.START_H2 i,p1,p2))
fun END_H2 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H3 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.START_H3 i,p1,p2))
fun END_H3 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H4 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.START_H4 i,p1,p2))
fun END_H4 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H5 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.START_H5 i,p1,p2))
fun END_H5 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun START_H6 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.START_H6 i,p1,p2))
fun END_H6 (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun START_HEAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun END_HEAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_HR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.TAG_HR i,p1,p2))
fun START_HTML (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun END_HTML (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun START_I (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun END_I (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_IMG (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.TAG_IMG i,p1,p2))
fun TAG_INPUT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.TAG_INPUT i,p1,p2))
fun TAG_ISINDEX (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.TAG_ISINDEX i,p1,p2))
fun START_KBD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
fun END_KBD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 69,(
ParserData.MlyValue.VOID,p1,p2))
fun START_LI (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 70,(
ParserData.MlyValue.START_LI i,p1,p2))
fun END_LI (p1,p2) = Token.TOKEN (ParserData.LrTable.T 71,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_LINK (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 72,(
ParserData.MlyValue.TAG_LINK i,p1,p2))
fun START_MAP (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 73,(
ParserData.MlyValue.START_MAP i,p1,p2))
fun END_MAP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 74,(
ParserData.MlyValue.VOID,p1,p2))
fun START_MENU (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 75,(
ParserData.MlyValue.START_MENU i,p1,p2))
fun END_MENU (p1,p2) = Token.TOKEN (ParserData.LrTable.T 76,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_META (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 77,(
ParserData.MlyValue.TAG_META i,p1,p2))
fun START_OL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 78,(
ParserData.MlyValue.START_OL i,p1,p2))
fun END_OL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 79,(
ParserData.MlyValue.VOID,p1,p2))
fun START_OPTION (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 80,(
ParserData.MlyValue.START_OPTION i,p1,p2))
fun END_OPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 81,(
ParserData.MlyValue.VOID,p1,p2))
fun START_P (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 82,(
ParserData.MlyValue.START_P i,p1,p2))
fun END_P (p1,p2) = Token.TOKEN (ParserData.LrTable.T 83,(
ParserData.MlyValue.VOID,p1,p2))
fun TAG_PARAM (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 84,(
ParserData.MlyValue.TAG_PARAM i,p1,p2))
fun START_PRE (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 85,(
ParserData.MlyValue.START_PRE i,p1,p2))
fun END_PRE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 86,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SAMP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 87,(
ParserData.MlyValue.VOID,p1,p2))
fun END_SAMP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 88,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SCRIPT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 89,(
ParserData.MlyValue.VOID,p1,p2))
fun END_SCRIPT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 90,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SELECT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 91,(
ParserData.MlyValue.START_SELECT i,p1,p2))
fun END_SELECT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 92,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SMALL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 93,(
ParserData.MlyValue.VOID,p1,p2))
fun END_SMALL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 94,(
ParserData.MlyValue.VOID,p1,p2))
fun START_STRIKE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 95,(
ParserData.MlyValue.VOID,p1,p2))
fun END_STRIKE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 96,(
ParserData.MlyValue.VOID,p1,p2))
fun START_STRONG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 97,(
ParserData.MlyValue.VOID,p1,p2))
fun END_STRONG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 98,(
ParserData.MlyValue.VOID,p1,p2))
fun START_STYLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 99,(
ParserData.MlyValue.VOID,p1,p2))
fun END_STYLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 100,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SUB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 101,(
ParserData.MlyValue.VOID,p1,p2))
fun END_SUB (p1,p2) = Token.TOKEN (ParserData.LrTable.T 102,(
ParserData.MlyValue.VOID,p1,p2))
fun START_SUP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 103,(
ParserData.MlyValue.VOID,p1,p2))
fun END_SUP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 104,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TABLE (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 105,(
ParserData.MlyValue.START_TABLE i,p1,p2))
fun END_TABLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 106,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TD (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 107,(
ParserData.MlyValue.START_TD i,p1,p2))
fun END_TD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 108,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TEXTAREA (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 109,(
ParserData.MlyValue.START_TEXTAREA i,p1,p2))
fun END_TEXTAREA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 110,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TH (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 111,(
ParserData.MlyValue.START_TH i,p1,p2))
fun END_TH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 112,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TITLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 113,(
ParserData.MlyValue.VOID,p1,p2))
fun END_TITLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 114,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 115,(
ParserData.MlyValue.START_TR i,p1,p2))
fun END_TR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 116,(
ParserData.MlyValue.VOID,p1,p2))
fun START_TT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 117,(
ParserData.MlyValue.VOID,p1,p2))
fun END_TT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 118,(
ParserData.MlyValue.VOID,p1,p2))
fun START_U (p1,p2) = Token.TOKEN (ParserData.LrTable.T 119,(
ParserData.MlyValue.VOID,p1,p2))
fun END_U (p1,p2) = Token.TOKEN (ParserData.LrTable.T 120,(
ParserData.MlyValue.VOID,p1,p2))
fun START_UL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 121,(
ParserData.MlyValue.START_UL i,p1,p2))
fun END_UL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 122,(
ParserData.MlyValue.VOID,p1,p2))
fun START_VAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 123,(
ParserData.MlyValue.VOID,p1,p2))
fun END_VAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 124,(
ParserData.MlyValue.VOID,p1,p2))
fun PCDATA (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 125,(
ParserData.MlyValue.PCDATA i,p1,p2))
fun CHAR_REF (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 126,(
ParserData.MlyValue.CHAR_REF i,p1,p2))
fun ENTITY_REF (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 127,(
ParserData.MlyValue.ENTITY_REF i,p1,p2))
end
end
