/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

import java.io.*;

/**
 * The SmallEiffelRuntime class implements some external "SmallEiffel" 
 * features. This class must be present to execute the Java byte-code
 * generated by command `compile_to_jvm'.
 * Do not forget to add this class in your CLASSPATH system
 * environment variable.
 * You can also move this class file in an appropriate directory.
 */
public final class SmallEiffelRuntime {

    /** 
     * To implement Eiffel GENERAL.se_getenv
     */
    public static String se_getenv (Object bytes) {
	String name = bytesToString(bytes);
	return System.getProperty(name);
    }

    /** 
     * To implement Eiffel GENERAL.print_run_time_stack
     */
    public static void print_run_time_stack () {
	Throwable stack = new Throwable();
	System.err.println("Printing the JVM stack:");
	stack.printStackTrace();
    }

    /** 
     * To implement Eiffel GENERAL.die_with_code
     */
    public static void die_with_code (int code) {
	System.exit(code);
    }

    /** 
     * To implement Eiffel GENERAL.se_system
     */
    public static void se_system (Object system_command_line) {
	String scl = bytesToString(system_command_line);
	Process process;
	
	try {
	    process = Runtime.getRuntime().exec(scl);

	    process.waitFor();
	    }
	catch (Exception e) {
	    System.err.print("SmallEiffelRuntime: se_system(\"");
	    System.err.print(scl);
	    System.err.println("\") failed.");
	    print_run_time_stack();
	    System.err.println("Try to continue execution.");
	}
    }

    /**
     * To implement Eiffel FILE_TOOLS.se_remove
     */
    public static void se_remove (Object bytes) {
	String name = bytesToString(bytes);
	File file = new File(name);
	file.delete();
    }

    /**
     * To implement the Eiffel FILE_TOOLS.se_rename
     */
    public static void se_rename (Object old_path, Object new_path) {
	String oldPath = bytesToString(old_path);
	String newPath = bytesToString(new_path);
	File oldFile = new File(oldPath);
	File newFile = new File(newPath);

	oldFile.renameTo(newFile);
    }

    /**
     * To implement the Eiffel STD_FILE_READ.sfr_open
     */
    public static Object sfr_open (Object bytes) {
	String name = bytesToString(bytes);
	File file = new File(name);

	try {
	    return new FileInputStream (file);
	} catch (FileNotFoundException e) {
	    return null;
	}
    }

    /**
     * To implement the Eiffel STD_FILE_WRITE.sfw_open
     */
    public static Object sfw_open (Object bytes) {
	String name = bytesToString(bytes);
	File file = new File(name);

	try {
	    return new FileOutputStream (file);
	} catch (IOException e) {
	    return null;
	}
    }

    /**
     * To implement the Eiffel STRING.se_string2double
     */
    public static double se_string2double (Object number_view) {
	String number = bytesToString(number_view);
	
	return Double.valueOf(number).doubleValue();
    }

    /**
     * Convert <code>bytes</code> as a  <code>String </code>.
     * Assume <code>bytes</code> is a C like string (ie. with a
     * null character is the end).
     */
    public static String bytesToString (Object bytes) {
	int i = 0;
	byte b [] = ((byte[])bytes);
	while ( b[i] != 0 ) {
	    i++;
	}
	return (new String(b,0,i));
    }

    public static int internal_exception_number = 3;

    public static void runtime_error(int line,
				     int column,
				     String path,
				     String type,
				     String message) {
        System.err.println("Run-time Eiffel error.");
	if (message != null) {
	    System.err.println(message);
	}
	if (type != null) {
	    System.err.print("Eiffel type: \"");
	    System.err.print(type);
	    System.err.println("\".");
	}
	if (line != 0) {
	    System.err.print("Error occurs at line ");
	    System.err.print(line);
	    System.err.print(" column ");
	    System.err.print(column);
	    System.err.print(" in \"");
	    System.err.print(path);
	    System.err.println("\".");
	}
	print_run_time_stack();
	System.exit(1);
    }

    public static void runtime_error_bad_target(Object target,
						int line,
						int column,
						String path,
						String type,
						String message) {
	
	if (target == null) {
	    System.err.println("Void (null) target for a call.");
	}
	else {
	    System.err.println("Bad target for a call.");
	    System.err.print("Target is \"");
	    System.err.print(target.toString());
	    System.err.println("\"");
	}
	runtime_error(line,column,path,type,message);
    }

    public static int runtime_error_inspect(int inspect_value,
					    int line,
					    int column,
					    String path) {
	System.err.print("Bad inspect value = ");
	System.err.println(inspect_value);
	runtime_error(line,column,path,null,
		      "Invalid inspect (nothing selected).");
	return inspect_value;
    }

    public static int runtime_check_loop_variant(int loop_counter,
						 int prev_variant,
						 int next_variant,
						 int line,
						 int column,
						 String path) {
	if (next_variant < 0) {
	    bad_loop_variant(loop_counter,
			     prev_variant,
			     next_variant,
			     line,column,path);
	    return 0;
	}
	else if (loop_counter == 0) {
	    return next_variant;
	}
	else if (next_variant < prev_variant) {
	    return next_variant;
	}
	else {
	    bad_loop_variant(loop_counter,
			     prev_variant,
			     next_variant,
			     line,column,path);
	    return 0;
	}
    }

    private static void bad_loop_variant(int loop_counter,
					int prev_variant,
					int next_variant,
					int line,
					int column,
					String path) {
	System.err.print("Loop body counter = ");
	System.err.print(loop_counter);
	System.err.println(" (done)");
	if (loop_counter > 0) {
	    System.err.print("Previous variant = ");
	    System.err.println(prev_variant);
	}
	System.err.print("Current variant = ");
	System.err.print(next_variant);
	if (next_variant < 0) {
	    System.err.println(" (Bad Negative value)");
	}
	else {
	    System.err.println(" (must be less than previous)");
	}
	runtime_error(line,column,path,null,"Loop variant violation.");
    }
    
    /**
     * For -trace flag (this is a new undocumented stuff).
     */
    public static void se_trace(Object target,
				int line,
				int column,
				String path) {
	se_trace_show(line,column,path);
    }

    public static void se_trace(boolean target,
				int line,
				int column,
				String path) {
	if (target) {
	    System.out.print("Current = true ");
	}
	else {
	    System.out.print("Current = false ");
	}
	se_trace_show(line,column,path);
    }

    public static void se_trace(byte target,
				int line,
				int column,
				String path) {
	System.out.print("Current = ");
	System.out.print(target);
	System.out.print(" ");
	se_trace_show(line,column,path);
    }

    public static void se_trace(int target,
				int line,
				int column,
				String path) {
	System.out.print("Current = ");
	System.out.print(target);
	System.out.print(" ");
	se_trace_show(line,column,path);
    }

    public static void se_trace_show(int line,
				     int column,
				     String path) {
	System.out.print(path);
	System.out.print(" l=");
	System.out.print(line);
	System.out.print(" c=");
	System.out.print(column);
	System.out.println();
	System.out.flush();
    }

}

