/*
-- ANSI C code generated by :
-- SmallEiffel The GNU Eiffel Compiler -- Release (- 0.78)      --
-- Copyright (C), 1994-98 - LORIA - UHP - CRIN - INRIA - FRANCE --
-- Dominique COLNET and Suzanne COLLIN -    colnet@loria.fr     --
--                  http://SmallEiffel.loria.fr/                --
*/

/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/
/*
  This file (base.h) is automatically included in the header for all modes 
  of compilation : -boost, -no_check, -require_check, ...
  This file is also included in the header of any cecil file.
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
# define JMP_BUF    sigjmp_buf
# define SETJMP(x)  sigsetjmp( (x), 1)
# define LONGJMP    siglongjmp
#else
# define JMP_BUF    jmp_buf
# define SETJMP(x)  setjmp( (x) )
# define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Eiffel type INTEGER is #2 :
*/
typedef int T2;
#define M2 (0)
#define T2BITS (CHAR_BIT*sizeof(int))
#define T2MIN INT_MIN
#define T2MAX INT_MAX

/*
  Eiffel type CHARACTER is #3 :
*/
typedef char T3;
#define M3 (0)
#define T3BITS CHAR_BIT
#define T3MIN (0)
#define T3MAX (255)

/*
  Eiffel type REAL is #4 :
*/
typedef float T4;
#define M4 (0.0)
#define T4BITS (CHAR_BIT*sizeof(float))
#define T4MIN (-(FLT_MAX))
#define T4MAX FLT_MAX

/*
  Eiffel type DOUBLE is #5 :
*/
typedef double T5;
#define M5 (0.0)
#define T5BITS (CHAR_BIT*sizeof(double))
#define T5MIN (-(DBL_MAX))
#define T5MAX DBL_MAX

/*
  Eiffel type BOOLEAN is #6 :
*/
typedef int T6;
#define M6 (0)
#define T6BITS (CHAR_BIT*sizeof(int))

/* 
   Eiffel type POINTER is #8 :
*/
typedef void* T8;
#define M8 (NULL)
#define T8BITS (CHAR_BIT*sizeof(void*))


/* --- Mangling Table Start ---
A*1  T38   R SMALL_EIFFEL 38
A*1  T35   R STD_OUTPUT 35
A 1  T6    E BOOLEAN 6
A 1  T2    E INTEGER 2
A 1  T3    E CHARACTER 3
A*1  T37   R FIXED_ARRAY[STRING] 37
A 1  T8    E POINTER 8
A*1  T33   R STD_ERROR 33
A*1  T32   R ECHO 32
A*1  T25   R STD_FILE_READ 25
A*1  T40   R RUN_CONTROL 40
A*1  T21   R SYSTEM_TOOLS 21
A*1  T10   R CLEAN 10
A*1  T7    R STRING 7
A 1  T31   E NATIVE_ARRAY[STRING] 31
A*1  T28   R ARRAY[STRING] 28
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T39   E FILE_TOOLS 39
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef void*T38;
typedef void*T35;
typedef struct S37 T37;
typedef void*T33;
typedef struct S32 T32;
typedef struct S25 T25;
typedef struct S40 T40;
typedef struct S21 T21;
typedef void*T10;
typedef struct S7 T7;
typedef struct S28 T28;
typedef int T39;

/*C Header Pass 2 :*/
typedef T0**T31;
typedef T3*T9;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
extern T38 M38;
extern T35 M35;
struct S37{T31 _storage;T2 _capacity;T2 _upper;};
extern T37 M37;
extern T33 M33;
struct S32{T6 _verbose;};
extern T32 M32;
struct S25{T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T25 M25;
struct S40{T0* _root_class;};
extern T40 M40;
struct S21{T0* _system_name;T0* _sys_directory;T0* _bin_directory;T0* _c_compiler;};
extern T21 M21;
extern T10 M10;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S28{T31 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T28 M28;
extern T39 M39;
/*
-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
*/

/*
  This file (boost.h) is automatically included when `run_control.boost' is
  true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void sigrsp(int sig);
T6 r6_ix_not(T6 C);
T3 r2digit(T2 C);
void r2append_in(T2 C,T0* a1);
T3 r3to_lower(T3 C);
T6 r3is_letter(T3 C);
T6 r3_px_6061(T3 C,T3 a1);
T6 r3_px_6261(T3 C,T3 a1);
T6 r3is_separator(T3 C);
T6 r3is_digit(T3 C);
T3 r3to_upper(T3 C);
T6 r31equal_like(T0* a1,T0* a2);
void r31set_all_with(T31 C,T0* a1,T2 a2);
T2 r31index_of(T31 C,T0* a1,T2 a2);
T9 r9realloc(T9 C,T2 a1,T2 a2);
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
void r9copy_from(T9 C,T9 a1,T2 a2);
T6 r9fast_has(T9 C,T3 a1,T2 a2);
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
void r7to_lower(T7* C);
T6 r7is_equal(T7* C,T0* a1);
void r7remove_first(T7* C,T2 a1);
T3 r7last(T7* C);
void r7remove_between(T7* C,T2 a1,T2 a2);
void r7make(T7* C,T2 a1);
T8 r7to_external(T7* C);
void r7swap(T7* C,T2 a1,T2 a2);
void r7copy(T7* C,T0* a1);
void r7remove_last(T7* C,T2 a1);
T0* r7twin(T7* C);
void r7append(T7* C,T0* a1);
void r7extend(T7* C,T3 a1);
T6 r7has_suffix(T7* C,T0* a1);
T6 r7has(T7* C,T3 a1);
void r7to_upper(T7* C);
void r7set_last(T7* C,T3 a1);
void r37make(T37* C,T2 a1);
T2 r28index_of(T28* C,T0* a1);
T0* r28item(T28* C,T2 a1);
void r35put_string(T35* C,T0* a1);
void r33put_string(T33* C,T0* a1);
extern T39 oBC1file_tools;
void r32put_string(T32* C,T0* a1);
void r32sfr_connect_or_exit(T32* C,T0* a1,T0* a2);
void r32sfr_connect(T32* C,T0* a1,T0* a2);
T0* r32read_word_in(T32* C,T0* a1);
void r32w_put_string(T0* a1);
T6 r32file_exists(T0* a1);
void r32file_removing(T32* C,T0* a1);
void r32w_put_character(T3 a1);
extern T0*oBC1std_error;
extern T0*oBC1std_output;
void r25disconnect(T25* C);
void r25read_line_in(T25* C,T0* a1);
T6 r25end_of_input(T25* C);
extern T0*oBC26last_string;
void r25read_character(T25* C);
void r25read_line(T25* C);
void r25read_word(T25* C);
void r25connect_to(T25* C,T0* a1);
void r25skip_separators(T25* C);
void r40compute_root_class(T40* C,T0* a1);
void r21show_compiler_list_then_exit(T21* C);
extern T0*oBC12tmp_file_read;
extern T0*oBC21compiler_list;
T6 r21backslash_separator(T21* C);
extern int fBC21object_suffix;
extern T0*oBC21object_suffix;
T0* r21object_suffix(T21* C);
T0* r21get_environment_variable(T21* C,T0* a1);
T0* r21remove_make_script(T21* C);
void r21make(T21* C);
extern T0*oBC12echo;
extern T0*oBC21system_list;
void r21bad_use_exit(T21* C,T0* a1);
T6 r21slash_separator(T21* C);
extern T0*oBC12run_control;
void r21set_c_compiler(T21* C,T0* a1);
extern int fBC21make_suffix;
extern T0*oBC21make_suffix;
T0* r21make_suffix(T21* C);
void r21add_directory(T21* C,T0* a1,T0* a2);
void r21parent_directory(T21* C,T0* a1);
T0* r21path_h(T21* C);
T0* r10command_name(void);
extern T0*oBC12small_eiffel;
extern int fBC1command_arguments;
extern T0*oBC1command_arguments;
T0* r10command_arguments(void);
void r10search_for_cc_flag(T2 a1);
void r10make(T10* C);
T0* r10argument(T2 a1);
void r10unknown_flag_exit(T10* C,T0* a1);
T6 r10file_exists(T0* a1);
extern int fBC12system_tools;
extern T0*oBC12system_tools;
T0* r10system_tools(void);
T6 r10is_flag_verbose(T0* a1);
T6 r10is_flag_version(T10* C,T0* a1);
void r10try_to_remove(T0* a1);
T6 r39is_readable(T0* a1);
extern T0*oBC39std_fr1;
void r39delete(int C,T0* a1);
extern T10*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 41
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms21_0;
extern T7*ms11_270;
extern T7*ms21_270;
extern T7*ms12_300;
extern T7*ms21_210;
extern T7*ms21_690;
extern T7*ms13_160;
extern T7*ms13_270;
extern T7*ms21_903;
extern T7*ms12_294;
extern T7*ms21_414;
extern T7*ms21_314;
extern T7*ms21_285;
extern T7*ms21_396;
extern T7*ms21_636;
extern T7*ms21_948;
extern T7*ms21_428;
extern T7*ms21_738;
extern T7*ms11_729;
extern T7*ms13_939;
extern T7*ms21_8280;
extern T7*ms21_2300;
extern T7*ms13_3720;
extern T7*ms32_8610;
extern T7*ms12_1592;
extern T7*ms21_6162;
extern T7*ms21_4542;
extern T7*ms21_1032;
extern T7*ms21_8092;
extern T7*ms13_1053;
extern T7*ms11_2424;
extern T7*ms21_1484;
extern T7*ms21_1444;
extern T7*ms21_1044;
extern T7*ms11_2575;
extern T7*ms21_1985;
extern T7*ms21_2395;
extern T7*ms21_1076;
extern T7*ms21_9226;
extern T7*ms21_1316;
extern T7*ms21_1296;
extern T7*ms21_1428;
extern T7*ms32_6929;
extern T7*ms11_24020;
extern T7*ms21_46640;
extern T7*ms21_41310;
extern T7*ms21_26180;
extern T7*ms21_38280;
extern T7*ms21_31980;
extern T7*ms21_19880;
extern T7*ms21_10010;
extern T7*ms21_43761;
extern T7*ms11_10272;
extern T7*ms21_29002;
extern T7*ms13_18623;
extern T7*ms13_13293;
extern T7*ms11_10984;
extern T7*ms21_22824;
extern T7*ms21_13776;
extern T7*ms21_12816;
extern T7*ms32_72306;
extern T7*ms21_18117;
extern T7*ms21_48887;
extern T7*ms32_26208;
extern T7*ms11_15759;
extern T7*ms21_31119;
extern T7*ms32_25179;
extern T7*ms12_581900;
extern T7*ms21_716872;
extern T7*ms38_802392;
extern T7*ms21_131716;
extern T7*ms21_848426;
extern T7*ms21_225848;
T7*se_ms(int c,char*e);
T7*se_string_from_external_copy(char*e);
void se_msi1(void);
void se_msi2(void);
void*se_ma28(int argc,...);

