
(define-class <service> (<object>)
  (mbox type: <mailbox>) ;; [0]
  (event init-value: 0 getter: #f setter: #f) ;;[1]
  (fd type: <fixnum>)) ;; [2]

(define (make-service fd)
  (let ((s (make <service>
		 mbox: (make-mailbox)
		 fd: fd)))
    (make-accept-event fd s)
    s))

(define (get-next-client (s <service>))
  (let ((n (receive-message! (mbox s))))
    (values (car n) (clone2 (cdr n) <inet-socket-addr>))))

;;;
;;;  `dir' 0 = read side, 1 = write site, 2 = both sides
;;;

(define-safe-glue (close-socket-side (fd <raw-int>) (dir <raw-int>))
{
  if (shutdown( fd, dir ) < 0)
    os_error( "shutdown", 2, raw_fd, raw_dir );
  RETURN0();
})

(define-safe-glue (make-accept-event (fd <raw-int>) (owner <service>))
{
  REG0 = RAW_PTR_TO_OBJ( make_accept_event( fd, owner ) );
  RETURN1();
})

