
(define-class <stat-buf> (<object>) :bvec)

(define-syscall-glue (stat (path <raw-string>))
 literals: ((& <stat-buf>))
{
  obj x;
  struct stat *sb;

  x = alloc( sizeof(struct stat), TLREF(0) );
  sb = (struct stat *)PTR_TO_DATAPTR(x);

  if (stat( path, sb ) < 0)
    REG0 = FALSE_OBJ;
  else
    REG0 = x;
  RETURN1();
})

(define-syntax access-mask
  (syntax-form () 0)
  ;;
  ;; these are useful until we get constant folding implemented...
  ;;
  (syntax-form ('read) 4)
  (syntax-form ('write) 2)
  (syntax-form ('execute) 1)
  (syntax-form ('exist) 0)
  ;;
  (syntax-form ('read . more) (bitwise-or 4 (access-mask . more)))
  (syntax-form ('write . more) (bitwise-or 2 (access-mask . more)))
  (syntax-form ('execute . more) (bitwise-or 1 (access-mask . more)))
  (syntax-form ('exist . more) (bitwise-or 0 (access-mask . more))))

(define-syscall-glue (file-access? (path <raw-string>) (mode <raw-int>))
{
  REG0 = rb_to_bo( access( path, mode ) == 0 );
  RETURN1();
})


(define-syscall-glue (lstat (path <raw-string>))
 literals: ((& <stat-buf>))
{
  obj x;
  struct stat *sb;

  x = alloc( sizeof(struct stat), TLREF(0) );
  sb = (struct stat *)PTR_TO_DATAPTR(x);

  if (lstat( path, sb ) < 0)
    REG0 = FALSE_OBJ;
  else
    REG0 = x;
  RETURN1();
})

(define-syscall-glue (stat-type (stat <stat-buf>))
 literals: ('directory 'regular 'fifo 'character-special 'block-special)
{
  if (S_ISDIR(stat->st_mode))
    REG0 = LITERAL(0);
  else if (S_ISREG(stat->st_mode))
    REG0 = LITERAL(1);
  else if (S_ISFIFO(stat->st_mode))
    REG0 = LITERAL(2);
  else if (S_ISCHR(stat->st_mode))
    REG0 = LITERAL(3);
  else if (S_ISBLK(stat->st_mode))
    REG0 = LITERAL(4);
  else
    REG0 = FALSE_OBJ;
  RETURN1();
})

(define-syscall-glue (stat-mode (stat <stat-buf>))
{
  REG0 = int2fx( stat->st_mode );
  RETURN1();
})

(define-syscall-glue (stat-owner (stat <stat-buf>))
{
  REG0 = int2fx( stat->st_uid );
  REG1 = int2fx( stat->st_gid );
  RETURN(2);
})


(define-syscall-glue (stat-eq? (a <stat-buf>) (b <stat-buf>))
{
  REG0 = rb_to_bo( (a->st_ino == b->st_ino)
		   && (a->st_dev == b->st_dev) );
  RETURN1();
})

(define-syscall-glue (stat-id->hash (stat <stat-buf>))
{
  UINT_32 loc[2];

  loc[0] = stat->st_ino;
  loc[1] = stat->st_dev;
  REG0 = raw_bytes_hash( loc, sizeof loc );
  RETURN1();
})

(define-syscall-glue (stat-id-vector (stat <stat-buf>))
{
  UINT_32 device, inode;

  inode = stat->st_ino;
  device = stat->st_dev;
  REG0 = make4( vector_class, 
	        int2fx( device >> 16 ),
	        int2fx( device & 0xFFFF ),
	        int2fx( inode >> 16 ),
	        int2fx( inode & 0xFFFF ) );
  RETURN1();
})

(define-syscall-glue (stat-mtime (stat <stat-buf>))
  literals: ((& <time>))
{
  REG0 = make_time_sec( stat->st_mtime, TLREF(0) );
  RETURN1();     
})

(define-syscall-glue (stat-times (stat <stat-buf>))
  literals: ((& <time>))
{
  REG0 = make_time_sec( stat->st_mtime, TLREF(0) );
  REG1 = make_time_sec( stat->st_atime, TLREF(0) );
  REG2 = make_time_sec( stat->st_ctime, TLREF(0) );
  RETURN(3);
})

(define-syscall-glue (stat-size (stat <stat-buf>))
{
  REG0 = int2fx( stat->st_size );
  RETURN1();
})

(define (stat-directory? stat)
 (eq? (stat-type stat) 'directory))

(define (stat-file? stat)
 (eq? (stat-type stat) 'regular))

(define (stat-access? stat entity mode)
    (not (eq? (bitwise-and
	       (stat-mode stat)
	       (shift-left
		(case mode
		  ((read) 4)
		  ((write) 2)
		  ((execute) 1)
		  (else (abort 'stat-access? 
			       "Bad stat mode: ~a" mode)))
		(case entity
		  ((owner) 6)
		  ((group) 3)
		  ((world) 0)
		  (else (abort 'stat-access? 
			       "Bad stat entity: ~a" entity)))))
	      0)))

