#|------------------------------------------------------------*-Scheme-*--|
 | File:    packages/syscalls/scanprof.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rosette.com>
 |          as part of the RScheme project, licensed for free use
 |
 | Version: 1.3
 | Date:    1997.01.23 09:08:16
 | Build:   v0.7.3.1-b39, 1999-12-25
 |
 | Purpose: Read (parse) an RScheme profile dump file
 `------------------------------------------------------------------------|#

(define (with-profile-trace path proc-tbl)
  (with-profile-trace* path proc-tbl #f))

(define (with-profile-trace* path proc-tbl debug?)
  (let ((proc-vec (list->vector
		   (map (lambda (k)
			  (let ((p (assq k proc-tbl)))
			    (if p
				(let ((proc (cdr p)))
				  (if debug?
				      (lambda args
					(format #t "~s => ~s\n" k args)
					(apply proc args))
				      proc))
				(error "missing proc for profile entry: ~s" 
				       k))))
			'(eof
			  invalid
			  calls
			  returns
			  bjumps
			  jumps
			  fails
			  intr
			  start
			  done
			  gc
			  saves
			  captured
			  restored
			  def
			  cal-start
			  cal-stop
			  alloc
			  free
			  frac))))
	(src (fopen path "r")))
    (fseek src 0 2)
    (let ((total-len (ftell src)))
      (fseek src 0 0)
      (let ((frac (inexact->exact (floor (/ total-len 50))))
	    (breaks (map (lambda (f)
			   (cons (* f 2) 
				 (inexact->exact 
				  (round (* total-len (/ f 50))))))
			 (cdr (range 51)))))
	(with-profile-trace**
	 proc-vec
	 src
	 breaks
	 (cdr (car breaks))
	 total-len)
	(fclose src)))))

(define (with-profile-trace** proc-vec src breaks next-break-posn total-len)
  (let loop ()
    (if (>= (ftell src) next-break-posn)
        (begin
          ((vector-ref proc-vec 19) (car (car breaks)))
          (set! breaks (cdr breaks))
          (if (pair? breaks)
              (set! next-break-posn (cdr (car breaks)))
              (set! next-break-posn (+ total-len 10)))))
    (if (%profile-parse-next src proc-vec <time>)
        (loop))))

(define-glue (%profile-parse-next src proc_vec t_class)
{
  FILE *f = OBJ_TO_RAW_PTR(src);
  unsigned proc_n;
  obj proc, tmp_o, v = proc_vec;
  struct timeval tmp_t;
  UINT_32 tmp_len;

  /* by default, the proc gets no arguments */
  arg_count_reg = 0;
  switch (getc(f))
    {
    case EOF:
      proc_n = 0;
      break;

    default:
      proc_n = 1;
      break;

    case RSPROF_MT_CALLS:
      proc_n = 2;
      fread( &tmp_o, 1, sizeof(obj), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      fread( &tmp_len, 1, sizeof(UINT_32), f );
      REG1 = int2fx(tmp_len);
      arg_count_reg = 2;
      break;

    case RSPROF_MT_RETURNS:
      proc_n = 3;
      break;

    case RSPROF_MT_BJUMPS:
      proc_n = 4;
      break;

    case RSPROF_MT_JUMPS:
      proc_n = 5;
      break;

    case RSPROF_MT_FAILS:
      proc_n = 6;
      break;

    case RSPROF_MT_INTR:
      proc_n = 7;
      break;

    case RSPROF_MT_START:
      proc_n = 8;
      fread( &tmp_o, 1, sizeof(obj), f );
      fread( &tmp_t, 1, sizeof(struct timeval), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      REG1 = os_time( &tmp_t, t_class );
      arg_count_reg = 2;
      break;

    case RSPROF_MT_DONE:
      proc_n = 9;
    withtime:
      fread( &tmp_t, 1, sizeof(struct timeval), f );
      REG0 = os_time( &tmp_t, t_class );
      arg_count_reg = 1;
      break;

    case RSPROF_GC_WORK:
      proc_n = 10;
      fread( &tmp_t, 1, sizeof(struct timeval), f );
      REG0 = os_time( &tmp_t, t_class );
      arg_count_reg = 1;
      break;

    case RSPROF_SAVES:
      proc_n = 11;
      break;

    case RSPROF_CAPTURED:
      proc_n = 12;
      fread( &tmp_o, 1, sizeof(obj), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      arg_count_reg = 1;
      break;

    case RSPROF_RESTORED:
      proc_n = 13;
      fread( &tmp_o, 1, sizeof(obj), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      arg_count_reg = 1;
      break;

    case RSPROF_DECL_NAME:
      {
	unsigned len;

	proc_n = 14;
	fread( &tmp_o, 1, sizeof(obj), f );
	len = getc(f);
	REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
	REG1 = bvec_alloc( len+1, string_class );
	fread( string_text(REG1), 1, len, f );
	arg_count_reg = 2;
	break;
      }
    case RSPROF_CAL_START:
      proc_n = 15;
      goto withtime;

    case RSPROF_CAL_STOP:
      proc_n = 16;
      goto withtime;

    case RSPROF_OBJ_ALLOCED:
      proc_n = 17;
      fread( &tmp_o, 1, sizeof(obj), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      fread( &tmp_o, 1, sizeof(obj), f );
      REG1 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      fread( &tmp_len, 1, sizeof(UINT_32), f );
      REG2 = int2fx(tmp_len);
      arg_count_reg = 3;
      break;

    case RSPROF_OBJ_DIED:
      proc_n = 18;
      fread( &tmp_o, 1, sizeof(obj), f );
      REG0 = OBJ(VAL(tmp_o) - POINTER_TAG + FIXNUM_TAG);
      arg_count_reg = 1;
      break;
    }
  APPLY(arg_count_reg,gvec_ref( v, SLOT(proc_n) ) );
})
