
(define-macro (pack-string . desc)
  (define (every-other lst)
    (if (null? lst)
	'()
	(cons (car lst) (if (null? (cdr lst))
			    '()
			    (every-other (cddr lst))))))
  (let* ((kwds (every-other desc))
	 (vals (every-other (cdr desc)))
	 (pl (make-packing-list kwds)))
    (set-structure-type! pl <string>)
    (set-instance-size! pl (+ (instance-size pl) 1))
    `(pack-using ',pl (vector ,@vals))))

(define-macro (pack . desc)
  (define (every-other lst)
    (if (null? lst)
	'()
	(cons (car lst) (if (null? (cdr lst))
			    '()
			    (every-other (cddr lst))))))
  (let ((kwds (every-other desc))
	(vals (every-other (cdr desc))))
    `(pack-using ',(make-packing-list kwds)
		 (vector ,@vals))))

(define-macro (with-unpack expr desc . body)
  (define (every-other lst)
    (if (null? lst)
	'()
	(cons (car lst) (if (null? (cdr lst))
			    '()
			    (every-other (cddr lst))))))
  (let ((kwds (every-other desc))
	(vals (every-other (cdr desc))))
    `(bind ((,@vals (unpack-using ',(make-packing-list kwds) ,expr)))
       ,@body)))

