
;; warning message

(define (warning-message (m <message>) argv . mp)
  (display-message m (current-error-port) argv 
		   (if (null? mp) *message-prefix* (car mp))))

(define-macro (wm . args)
  (bind ((msg args xtra (foo 'warning args))
	 (mn (gensym)))
    `(let ((,mn (alloc-message ,@msg)))
       (if (',enabled? ,mn)
	   (',warning-message ,mn (vector ,@args) ,@xtra)
	   (values)))))

(&module (export wm))
