(define-class <text-location> (<object>)
  owner
  (input-line type: <fixnum>)
  (input-offset type: <fixnum>)
  (input-col type: <fixnum>))

(define-method display-object ((self <text-location>) port)
  (let ((o (owner self)))
    (if o
        (format port "~a:~d:~d:" o (input-line self) (input-col self))
        (format port "~d:~d:" (input-line self) (input-col self)))))

(define-method write-object ((self <text-location>) port)
  (format port "#[<text-location> ~a]" self))

;;; doesn't work across newlines

(define (location+ (self <text-location>) (delta <fixnum>))
  (make <text-location>
        owner: (owner self)
        input-line: (input-line self)
        input-col: (+ (input-col self) delta)
        input-offset: (+ (input-offset self) delta)))

(define (location- (a <text-location>) (b <text-location>))
  (if (eq? (owner a) (owner b))
      (- (input-offset a) (input-offset b))
      (error "location-: incommensurate text locations: ~s ~s" a b)))
