
(define-interactive (set-gcontext-font-name (name <string>))
  (interactive (minibuffer <string> "Font name: "))
  (let* ((client (current-client))
	 (old-font (active-font client)))
    (set-active-font! client
		      (make <text-font>
			    font-name: name
			    font-style: (font-style old-font)
			    font-size: (font-size old-font)))))


(define-interactive (set-gcontext-font-style (style <string>))
  (interactive (minibuffer <string> "Font style: "))
  (let* ((client (current-client))
	 (old-font (active-font client)))
    (set-active-font! client
		      (make <text-font>
			    font-name: (font-name old-font)
			    font-style: style
			    font-size: (font-size old-font)))))


(define-interactive (set-gcontext-font-size (size <real>))
  (interactive (minibuffer <number> "Font size: "))
  (let* ((client (current-client))
	 (old-font (active-font client)))
    (set-active-font! client
		      (make <text-font>
			    font-name: (font-name old-font)
			    font-style: (font-style old-font)
			    font-size: size))))
