#ifndef lint
static char *RCSid = "$Id: extlib.c,v 1.1 1999/08/31 20:32:32 mark Exp $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#include "rexx.h"

#define EXT_HASH_MODULUS 133

static struct funcbox {
   struct funcbox *next, *prev ;
   streng *name ;
   int type ;
   int hash1 ;
} *extfuncs[EXT_HASH_MODULUS] = { NULL } ;

#if defined(HAVE_WINMULTITHREADING)
   extern globalext SG;
#endif

/*
 * Calulates a hashvalue for 'name', for use as index into the array of
 * functions that have been loaded from external function packages.
 */
static int hashvalue( streng *name )
{
   char *ptr=name->value, *end=Str_end(name) ;
   int result=0 ;

   for ( ; ptr<end; ptr++ )
      result = result + *ptr ;

   return result ;
}

static struct funcbox *findfunc( streng *name )
{
   struct funcbox *fptr=NULL ;
   int hashbox, hash1 ;
#include "multi.h"

   hash1 = hashvalue( name ) ;
   hashbox = hash1 % EXT_HASH_MODULUS ;
   for (fptr=extfuncs[hashbox]; fptr; fptr=fptr->prev)
      if (fptr->hash1 == hash1)
         if (!Str_cmp(name, fptr->name))
            return fptr ;

   return NULL ;
#include "unmulti.h"
}


int delfunc( streng *name )
{
   struct funcbox *old=NULL ;
   int hashbox ;
#include "multi.h"
  
   old = findfunc( name ) ;
   if (!old)
      return 1 ;

   hashbox = hashvalue( name ) % EXT_HASH_MODULUS ;
   Free_string( old->name ) ;
   if (old==extfuncs[hashbox])
      extfuncs[hashbox] = old->prev ;
   else 
      old->next->prev = old->prev ;

   if (old->prev)
      old->prev->next = old->next ;

   Free( old ) ;
   return 0 ;
#include "unmulti.h"
}


int addfunc( streng *name, int type ) 
{
   struct funcbox *new=NULL ;
   int hashbox, hash1 ;
#include "multi.h"

   if (findfunc( name ))
      return 1 ;

   new = Malloc( sizeof(struct funcbox )) ;
   if (!new)
      return 1 ;

   hash1 = hashvalue( name ) ;
   hashbox = hash1 % EXT_HASH_MODULUS ;
   new->name = name ;
   new->type = type ;
   new->next = NULL ;
   new->hash1 = hash1 ;
   new->prev = extfuncs[hashbox] ;
   if (extfuncs[hashbox])
      extfuncs[hashbox]->next = new ;
   extfuncs[hashbox] = new ;

   return 0 ;
#include "unmulti.h"
}



int external_func( streng *name )
{
   struct funcbox *ptr=NULL ;

   ptr = findfunc( name ) ;
   if (ptr)
      return 1 ;
   else
      return 0 ;
}

