/*
 * TSCSTR.C - test SCSTR.C routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

/***********************************************************************
* File        : tscstr.c - Test program for pact/score/scstr.c
* Externals   : fltfil, intfil, pact/score
* Machines    : sandpiper, phoenix.ocf
*
* Programmer  : Carolyn Sharp
* Created     : October 30, 1991
* Revised     : November 25, 1991
*               Reorganized to match tscctl.c (no change in function).
*             : November 26, 1991
*               Added strtol tests.
* Programmer  : Dennis Braddy
*             : April 6, 1995
*               Removed strtol and other system routine calls.
*               The point of providing PACT routines is to replace
*               sytem routines that don't work right!
*
* Description : Reads FILEs fltfil and intfil of assorted float/integer
*               numbers and checks values returned by score functions
*               _SC_atof, _SC_strtod, and _SC_strtol.
***********************************************************************/

#include "score.h" 
#define MAX 32

main ()
   {char xxx[MAX];                    /* input string */
    char *endptr;                    /* pointer to remainder or NULL */
    int base;                         /* 2-36 allowed, score always 10? */
    double expected;                  /* expected result (input, float) */
    int lexpected;                    /* expected result (input, int) */
    FILE *fp;                         /* file pointer */
    char *name;                       /* name of input file */
    int fail[3];                      /* number of failures per case */
    int failsum;                      /* total number of failures */
    int i;                            /* loop variable */
    long lval;
    static char *casename[]  = {"_SC_atof", "_SC_strtod", "_SC_strtol"};

/* process fltfil for atof/strtod functions */
    fp = fopen("fltfil", "r");

    PRINT(STDOUT, "\nString\t\tFunction\t  Measured       Expected\tStatus\n");

/* initialize failure counters */
    for (i = 0; i < 3; fail[i] = 0, i++);

    while (fscanf(fp, "%13s %lg %d", xxx, &expected, &lexpected) != EOF)
       {fail[0] += checkd(_SC_atof(xxx), "_SC_atof",
			  xxx, expected, lexpected); 
	fail[1] += checkd(_SC_strtod(xxx, &endptr), "_SC_strtod",
			  xxx, expected, lexpected);};

    fclose(fp);
  
    PRINT(STDOUT, "\nString\tFunction\t  Measured     Expected   Status\n");

/* process intfil for strtol functions */
    fp = fopen("intfil", "r");

    while (fscanf(fp, "%10s %d %ld %d", xxx, &base, &lval, &lexpected) != EOF)
       fail[2] += checkl(_SC_strtol(xxx, &endptr, base), "_SC_strtol", xxx,
			 lval, lexpected);

    fclose(fp);
  
/* report failures */
    failsum = 0;
    for (i = 0; i < 3; i++)
        {if (fail[i])
	    {PRINT(STDOUT, "%d failure%s in %s \n", fail[i],
		   ((fail[i] > 1) ? "s" : "") , casename[i]);
	     failsum += fail[i];};};

    if (failsum)
       printf("%d = total \n", failsum);

    PRINT(STDOUT, "\n");

    return(failsum ? 1 : 0);}

/***********************************************************************
* Function    : checkd(...)
* Programmer  : Carolyn Sharp
* Created     : November 18, 1991
* Revised     : November 25, 1991
*               Moved debug prints in. 
*
* Description : Checks return value of named double function of one 
*               argument against expected result.
*               Prints arguments and function if test fails.
*
* Returns     : 0|1 for PASS|FAIL
***********************************************************************/

checkd(dval, fcn_name, xxx, expected, pass)
   double dval;
   char *fcn_name;
   char xxx[MAX];
   double expected;
   int pass;
   {double d, tolerance;
    int fail;

    tolerance = 1.0e-13;
    d         = 0.5*ABS(dval - expected)/(ABS(dval) + ABS(expected));
    fail      = (d > tolerance);
    PRINT(STDOUT, "%s       \t%s     \t%11e  %11e\t %s \n",
	  xxx, fcn_name, dval, expected,
	  (fail ? "Fail" : " OK"));

    return(fail);}

/***********************************************************************
* Function    : checkl(...)
* Programmer  : Carolyn Sharp
* Created     : November 22, 1991
* Revised     : November 25, 1991
*               Moved debug prints in. 
*
* Description : Checks return value of named int function of two
*               arguments against expected result.
*               Prints arguments and function if test fails.
*
* Returns     : 0|1 for PASS|FAIL
***********************************************************************/

checkl(mval, fcn_name, xxx, lval, lexpected)
   long mval;
   char *fcn_name;
   char xxx[MAX];
   long lval;
   int lexpected;
   {int fail;

    fail = (mval != lval);
    PRINT(STDOUT, "%s\t%s     \t   %5ld\t %5d\t   %s\n",
	  xxx, fcn_name, mval, lexpected,
	  (fail ? "Fail" : " OK"));

    return(fail);}

/***********************************************************************/
