/*
 * GSGROT.C - grotrian plotting routines for PGS
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

static void
 SC_DECLARE(_PG_grotrian_plot, (PG_device *dev, PG_graph *g));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PG_GROTRIAN_PLOT - main grotrian plot control routine */

#ifdef PCC

void PG_grotrian_plot(dev, data, va_alist)
   PG_device *dev;
   PG_graph *data;
   va_dcl

#endif

#ifdef ANSI

void PG_grotrian_plot(PG_device *dev, PG_graph *data, ...)

#endif

   {REAL xmax, xmin, ymax, ymin, zmin, zmax;
    REAL dextr[4], rextr[2];
    REAL xmx, xmn, ymx, ymn;
    PG_dev_attributes *attr;
    PG_graph *g;
    PM_set *domain, *range;

    xmin = HUGE_REAL;
    ymin = HUGE_REAL;
    zmin = HUGE_REAL;
    xmax = -HUGE_REAL;
    ymax = -HUGE_REAL;
    zmax = -HUGE_REAL;

/* find the extrema for this frame */
    for (g = data; g != NULL; g = g->next)
        {domain = g->f->domain;
	 PM_array_real(domain->element_type, domain->extrema, 4, dextr);

         range = g->f->range;
	 PM_array_real(range->element_type, range->extrema, 2, rextr);

         xmin = min(xmin, dextr[0]);
         xmax = max(xmax, dextr[1]);
         ymin = min(ymin, dextr[2]);
         ymax = max(ymax, dextr[3]);
         zmin = min(zmin, rextr[0]);
         zmax = max(zmax, rextr[1]);};

    xmin -= 0.75;
    xmax += 0.75;

    if (xmin >= xmax)
       {xmin = 0.0;
        xmax = 1.0;};

    if (ymin >= ymax)
       {ymin = 0.0;
        ymax = 1.0;};

    PG_get_viewport_WC(dev, &xmn, &xmx, &ymn, &ymx);

    switch (PG_hl_clear_mode)
       {case CLEAR_SCREEN :
             PG_clear_window(dev);
	     break;
        case CLEAR_VIEWPORT :
             PG_clear_viewport(dev);
	     break;
        case CLEAR_FRAME :
             PG_clear_frame(dev);
	     break;};

/* set the plot limits and set the range and domain controls */
    if (dev->autorange == TRUE)
       {ymx = ymax;
        ymn = ymin;};

    if (dev->autodomain == TRUE)
       {xmx = xmax;
        xmn = xmin;};

    PG_set_window(dev, xmn, xmx, ymn, ymx);

    {PG_get_viewport(dev, &xmn, &xmx, &ymn, &ymx);
     PG_center_label(dev, 0.5*(1.0 + ymx), data->f->name);}

/* save user's values for various attributes */
    attr = PG_get_attributes(dev);

/* plot all of the current functions */
    for (g = data; g != NULL; g = g->next)
        _PG_grotrian_plot(dev, g);

    if (dev->finished)
       {PG_finish_plot(dev);}
    else
       {PG_update_vs(dev);};

/* reset user's values for various attributes */
    PG_set_attributes(dev, attr);
    SFREE(attr);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_GROTRIAN_PLOT - draw the grotrian plot */

static void _PG_grotrian_plot(dev, g)
   PG_device *dev;
   PG_graph *g;
   {int *maxes, *nt;
    int n_tr, n_s, i, u, l, npts;
    REAL **r, extr[4];
    REAL *lx, *ly, *lu, *lv, *dx;
    REAL x1, x2, y1;
    REAL *rx, *ry, *upper, *lower;
    double xmin, xmax, ymin, ymax;
    char format[20], **labels;
    PM_set *domain, *range;

    domain = g->f->domain;
    npts   = domain->n_elements;
    r      = (REAL **) domain->elements;

    rx = PM_array_real(domain->element_type, r[0], npts, NULL);
    ry = PM_array_real(domain->element_type, r[1], npts, NULL);

    PM_array_real(domain->element_type, domain->extrema, 4, extr);
    xmin = extr[0] - 0.75;
    xmax = extr[1] + 0.75;
    ymin = extr[2];
    ymax = extr[3];

    maxes = domain->max_index;
    n_s   = maxes[0];

    range = g->f->range;
    npts  = range->n_elements;
    r     = (REAL **) range->elements;

    upper = PM_array_real(range->element_type, r[1], npts, NULL);
    lower = PM_array_real(range->element_type, r[2], npts, NULL);

    PM_array_real(range->element_type, range->extrema, 2, extr);

    maxes = range->max_index;
    n_tr  = maxes[0];

    labels = (char **) domain->info;
    if (domain->info_type != NULL)
       if (strcmp(domain->info_type, "char **") != 0)
          return;

/* draw the vertical axis */
    strcpy(format, "%10.2g");
    PG_set_line_width(dev, 0.0);
    PG_draw_axis(dev, xmin, ymin, xmin, ymax,
                      0.0, 1.0, ymin, ymax, 1.0,
                      format,
                      LEFT_OF_AXIS, LEFT_OF_AXIS, FALSE,
                      MAJOR, MINOR, LABEL, 0);

/* draw the horizontal labels */
    ymin -= 0.05*(ymax - ymin);
    for (x1 = xmin + 0.7; x1 < xmax; x1 += 1.0)
        PG_write_WC(dev, x1, ymin, "%ld", (int) (x1 + 0.5));

/* draw the states */
    PG_set_line_width(dev, 1.0);
    for (i = 0; i < n_s; i++)
        {x1 = rx[i] - 0.25;    
         x2 = x1 + 0.5;    
         y1 = ry[i];
         PG_draw_line(dev, x1, y1, x2, y1);};

/* label the states */
    if (labels != NULL)

/* set the labelling PostScript font */
       {if (POSTSCRIPT_DEVICE(dev))
           io_printf(dev->file, "Flabel\n");

        for (i = 0; i < n_s; i++)
            {x1 = rx[i] + 0.27;
             y1 = ry[i];
             PG_write_WC(dev, x1, y1, "%s", labels[i]);};

/* restore the main PostScript font */
       if (POSTSCRIPT_DEVICE(dev))
          io_printf(dev->file, "Fplot\n");};

    lx = FMAKE_N(REAL, n_tr, "_PG_GROTRIAN_PLOT:lx");
    ly = FMAKE_N(REAL, n_tr, "_PG_GROTRIAN_PLOT:ly");
    lu = FMAKE_N(REAL, n_tr, "_PG_GROTRIAN_PLOT:lu");
    lv = FMAKE_N(REAL, n_tr, "_PG_GROTRIAN_PLOT:lv");

    nt = FMAKE_N(int, n_s, "_PG_GROTRIAN_PLOT:nt");
    dx = FMAKE_N(REAL, n_s, "_PG_GROTRIAN_PLOT:dx");
    for (i = 0; i < n_tr; i++)
        {u = upper[i];
         l = lower[i];
         nt[u]++;
         nt[l]++;};

    for (i = 0; i < n_s; i++)
        dx[i] = 0.5/((REAL) nt[i] + 1);

/* draw the transitions */
    for (i = 0; i < n_tr; i++)
        {u  = upper[i];
         l  = lower[i];
         lx[i] = rx[u] - dx[u]*nt[u] + 0.25;
         ly[i] = ry[u];
         lu[i] = rx[l] - dx[l]*nt[l] + 0.25 - lx[i];
         lv[i] = ry[l] - ly[i];
         nt[u]--;
         nt[l]--;};

    PG_set_vec_attr(dev, VEC_LINETHICK, 0.1,
                         VEC_SCALE, 1.0,
                         VEC_FIXHEAD, TRUE,
                         VEC_ANGLE, 15.0,
                         VEC_HEADSIZE, 0.01, 0);
    _PG_draw_vct(dev, lx, ly, lu, lv, n_tr);

/* we will want to draw the palette at some point */
/*    PG_draw_palette(dev, 0.808, 0.808, 0.175, 0.825, zmin, zmax, 0.1); */

    PG_update_vs(dev);

    SFREE(lx);
    SFREE(ly);
    SFREE(lu);
    SFREE(lv);
    SFREE(nt);
    SFREE(dx);

    SFREE(rx);
    SFREE(ry);
    SFREE(lower);
    SFREE(upper);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
