/*
 * GSFIB.C - FORTRAN interface routines for PGS
 *         - NOTE: let's keep these in alphabetical order
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGGINF - get the graph attribute list */

FIXNUM F77_ID(pgginf_, pgginf, PGGINF)(gid, pal)
   FIXNUM *gid, *pal;
   {PG_graph *g;
    pcons *alist;
    g = SC_GET_POINTER(PG_graph, *gid);

    PG_get_render_info(g, alist);
    *pal = (FIXNUM) SC_ADD_POINTER(alist);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGGGID - get the graph identifier */

FIXNUM F77_ID(pgggid_, pgggid, PGGGID)(gid, pc)
   FIXNUM *gid, *pc;
   {PG_graph *g;

    g = SC_GET_POINTER(PG_graph, *gid);
    PG_get_identifier(g, *pc);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGMG11 - make a 1D-1D graph */

FIXNUM F77_ID(pgmg11_, pgmg11, PGMG11)(pid, pnl, flabel, pcp, pn, x, y,
				       pnx, fxname, pny, fyname)
   FIXNUM *pid, *pnl;
   F77_string flabel;
   FIXNUM *pcp, *pn;
   REAL *x, *y;
   FIXNUM *pnx;
   F77_string fxname;
   FIXNUM *pny;
   F77_string fyname;
   {int id, cp, n;
    char label[MAXLINE], xname[MAXLINE], yname[MAXLINE];
    PG_graph *g;

    SC_FORTRAN_STR_C(label, flabel, *pnl);
    SC_FORTRAN_STR_C(xname, fxname, *pnx);
    SC_FORTRAN_STR_C(yname, fyname, *pny);

    id = *pid;
    cp = *pcp;
    n  = *pn;

    g = PG_make_graph_1d(id, label, cp, n, x, y, xname, yname);

    if (g == NULL)
       return(-1);

    else
       return((FIXNUM) SC_ADD_POINTER(g));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGMG21 - make a 2D-1D graph */

FIXNUM F77_ID(pgmg21_, pgmg21, PGMG21)(pid, pnl, flabel, pcp, pk, pl, pcen,
				       x, y, r,
				       pnd, fdname, pnr, frname)
   FIXNUM *pid, *pnl;
   F77_string flabel;
   FIXNUM *pcp, *pk, *pl, *pcen;
   REAL *x, *y, *r;
   FIXNUM *pnd;
   F77_string fdname;
   FIXNUM *pnr;
   F77_string frname;
   {int id, cp, kmax, lmax, centering;
    char label[MAXLINE], dname[MAXLINE], rname[MAXLINE];
    PG_graph *g;

    SC_FORTRAN_STR_C(label, flabel, *pnl);
    SC_FORTRAN_STR_C(dname, fdname, *pnd);
    SC_FORTRAN_STR_C(rname, frname, *pnr);

    id        = *pid;
    cp        = *pcp;
    kmax      = *pk;
    lmax      = *pl;
    centering = *pcen;

    g = PG_make_graph_r2_r1(id, label, cp, kmax, lmax, centering,
			    x, y, r, dname, rname);

    if (g == NULL)
       return(-1);

    else
       return((FIXNUM) SC_ADD_POINTER(g));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGMG22 - make a 2D-2D graph */

FIXNUM F77_ID(pgmg22_, pgmg22, PGMG22)(pid, pnl, flabel, pcp, pk, pl, pcen,
				       x, y, u, v,
				       pnd, fdname, pnr, frname)
   FIXNUM *pid, *pnl;
   F77_string flabel;
   FIXNUM *pcp, *pk, *pl, *pcen;
   REAL *x, *y, *u, *v;
   FIXNUM *pnd;
   F77_string fdname;
   FIXNUM *pnr;
   F77_string frname;
   {int id, cp, kmax, lmax, centering;
    char label[MAXLINE], dname[MAXLINE], rname[MAXLINE];
    PG_graph *g;
    PM_set *domain, *range;

    SC_FORTRAN_STR_C(label, flabel, *pnl);
    SC_FORTRAN_STR_C(dname, fdname, *pnd);
    SC_FORTRAN_STR_C(rname, frname, *pnr);

    id        = *pid;
    cp        = *pcp;
    kmax      = *pk;
    lmax      = *pl;
    centering = *pcen;

/* build the domain set */
    domain = PM_make_set(dname, SC_REAL_S, cp, 2, kmax, lmax, 2, x, y);

/* build the range set */
    range = PM_make_set(rname, SC_REAL_S, cp, 2, kmax, lmax, 2, u, v);

    g = PG_make_graph_from_sets(label, domain, range, centering,
                                SC_PCONS_P_S, NULL, id, NULL);

    if (g == NULL)
       return(-1);

    else
       return((FIXNUM) SC_ADD_POINTER(g));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGMGFS - make a graph from sets */

FIXNUM F77_ID(pgmgfs_, pgmgfs, PGMGFS)(pnl, fname, idom, iran,
				       pcen, pid, inxt)
   FIXNUM *pnl;
   F77_string fname;
   FIXNUM *idom, *iran, *pcen, *pid, *inxt;
   {int id, centering;
    char name[MAXLINE];
    PG_graph *g, *next;
    PM_set *domain, *range;
    PM_mapping *f;

    domain = SC_GET_POINTER(PM_set, *idom);
    range  = SC_GET_POINTER(PM_set, *iran);
    next   = SC_GET_POINTER(PG_graph, *inxt);

    SC_FORTRAN_STR_C(name, fname, *pnl);

    id        = *pid;
    centering = *pcen;

/* build the mapping */
    if (domain->topology == NULL)
       f = PM_make_mapping(name, PM_LR_S, domain, range, centering, NULL);
    else
       f = PM_make_mapping(name, PM_AC_S, domain, range, centering, NULL);

    g = PG_make_graph_from_mapping(f, SC_PCONS_P_S, NULL, id, NULL);
    if (g == NULL)
       return(-1);

    else
       {g->next = next;
	return((FIXNUM) SC_ADD_POINTER(g));};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGQKBD - get some information about the keyboard */

FIXNUM F77_ID(pgqkbd_, pgqkbd, PGQKBD)(devid, px, py, pc, pmod)
   FIXNUM *devid, *px, *py, *pc, *pmod;
   {PG_device *dev;
    int ix, iy, mod;
    char bf[2];

    dev = SC_GET_POINTER(PG_device, *devid);
    PG_KEY_EVENT_INFO(dev, &PG_current_event, ix, iy, bf, 2, mod);

    *px   = ix;
    *py   = iy;
    *pc   = bf[0];
    *pmod = mod;

    return((FIXNUM) TRUE);}
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGQPTR - get some information about the pointer (mouse) */

FIXNUM F77_ID(pgqptr_, pgqptr, PGQPTR)(devid, px, py, pbtn, pmod)
   FIXNUM *devid, *px, *py, *pbtn, *pmod;
   {PG_device *dev;
    int ix, iy, btn, mod;

    dev = SC_GET_POINTER(PG_device, *devid);
    PG_query_pointer(dev, &ix, &iy, &btn, &mod);

    *px   = ix;
    *py   = iy;
    *pbtn = btn;
    *pmod = mod;

    return((FIXNUM) TRUE);}
    
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGPLOT - render a graph */

FIXNUM F77_ID(pgplot_, pgplot, PGPLOT)(devid, grid)
   FIXNUM *devid, *grid;
   {PG_device *dev;
    PG_graph *g;

    dev = SC_GET_POINTER(PG_device, *devid);
    g   = SC_GET_POINTER(PG_graph, *grid);

    PG_draw_graph(dev, g);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGRLGR - release a graph */

FIXNUM F77_ID(pgrlgr_, pgrlgr, PGRLGR)(grid, prd, prr)
   FIXNUM *grid, *prd, *prr;
   {int rld, rlr;
    PG_graph *g;

    g   = SC_GET_POINTER(PG_graph, *grid);
    rld = *prd;
    rlr = *prr;

    PG_rl_graph(g, rld, rlr);

    *grid = 0;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSDLM - set a graph's domain limits */

FIXNUM F77_ID(pgsdlm_, pgsdlm, PGSDLM)(grid, pn, v)
   FIXNUM *grid, *pn;
   REAL *v;
   {PG_graph *g;
    long n;
    REAL *pt;

    g = SC_GET_POINTER(PG_graph, *grid);
    n = *pn;

    pt = FMAKE_N(REAL, n, "PGSDLM:pt");
    memcpy(pt, v, n*sizeof(REAL));

    PM_set_limits(g->f->domain, pt);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEDF - set the default event handler */

FIXNUM F77_ID(pgsedf_, pgsedf, PGSEDF)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_default_event_handler(dev, fnc);
    dev->default_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEEX - set the expose event handler */

FIXNUM F77_ID(pgseex_, pgseex, PGSEEX)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_expose_event_handler(dev, fnc);
    dev->expose_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEKD - set the key down event handler */

FIXNUM F77_ID(pgsekd_, pgsekd, PGSEKD)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_key_down_event_handler(dev, fnc);
    dev->key_down_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEKU - set the key up event handler */

FIXNUM F77_ID(pgseku_, pgseku, PGSEKU)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_key_up_event_handler(dev, fnc);
    dev->key_up_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEMD - set the mouse down event handler */

FIXNUM F77_ID(pgsemd_, pgsemd, PGSEMD)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_mouse_down_event_handler(dev, fnc);
    dev->mouse_down_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEMO - set the motion event handler */

FIXNUM F77_ID(pgsemo_, pgsemo, PGSEMO)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_motion_event_handler(dev, fnc);
    dev->motion_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEMU - set the mouse up event handler */

FIXNUM F77_ID(pgsemu_, pgsemu, PGSEMU)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_mouse_up_event_handler(dev, fnc);
    dev->mouse_up_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSEUP - set the update event handler */

FIXNUM F77_ID(pgseup_, pgseup, PGSEUP)(devid, fnc)
   FIXNUM *devid;
   PFByte fnc;
   {PG_device *dev;

    dev = SC_GET_POINTER(PG_device, *devid);

    PG_set_update_event_handler(dev, fnc);
    dev->update_event_handler.lang = _FORTRAN_LANG;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSINF - set the graph attribute list */

FIXNUM F77_ID(pgsinf_, pgsinf, PGSINF)(gid, pal)
   FIXNUM *gid, *pal;
   {PG_graph *g;
    pcons *alist;

    g = SC_GET_POINTER(PG_graph, *gid);

    alist = SC_GET_POINTER(pcons, *pal);
    PG_set_render_info(g, alist);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSGID - set the graph identifier */

FIXNUM F77_ID(pgsgid_, pgsgid, PGSGID)(gid, pc)
   FIXNUM *gid, *pc;
   {PG_graph *g;

    g = SC_GET_POINTER(PG_graph, *gid);
    PG_set_identifier(g, *pc);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSRAT - set a graph's rendering attributes */

FIXNUM F77_ID(pgsrat_, pgsrat, PGSRAT)(grid, pn, name, pt, type, val)
   FIXNUM *grid, *pn;
   F77_string name;
   FIXNUM *pt;
   F77_string type, val;
   {PG_graph *g;
    long n;
    pcons *info;
    char lname[MAXLINE], ltype[MAXLINE], *pv;

    g = SC_GET_POINTER(PG_graph, *grid);

    SC_FORTRAN_STR_C(lname, name, *pn);
    SC_FORTRAN_STR_C(ltype, type, *pt);

    if (strcmp(ltype, "integer") == 0)
       {strcpy(ltype, "int *");
        n = sizeof(int);}
    else if (strcmp(ltype, "real") == 0)
       {strcpy(ltype, "REAL *");
        n = sizeof(REAL);}
    else if (strcmp(ltype, "string") == 0)
       {strcpy(ltype, "char **");
        n = sizeof(char *);}
    else
       return((FIXNUM) FALSE);

    pv = FMAKE_N(char, n, "PGSRAT:pv");
    memcpy(pv, SC_F77_C_STRING(val), n);

    info = (pcons *) g->info;

    info = SC_change_alist(info, lname, ltype, pv);

    g->info = (byte *) info;

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSRLM - set a graph's range limits */

FIXNUM F77_ID(pgsrlm_, pgsrlm, PGSRLM)(grid, pn, v)
   FIXNUM *grid, *pn;
   REAL *v;
   {PG_graph *g;
    long n;
    REAL *pt;

    g = SC_GET_POINTER(PG_graph, *grid);
    n = *pn;

    pt = FMAKE_N(REAL, n, "PGSRLM:pt");
    memcpy(pt, v, n*sizeof(REAL));

    PM_set_limits(g->f->range, pt);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PGSVLM - set a graph's viewport limits */

FIXNUM F77_ID(pgsvlm_, pgsvlm, PGSVLM)(grid, v)
   FIXNUM *grid;
   REAL *v;
   {PG_graph *g;
    REAL *pv;

    g = SC_GET_POINTER(PG_graph, *grid);

    pv = FMAKE_N(REAL, 4, "PGSVLM:pv");
    memcpy(pv, v, 4*sizeof(REAL));

    g->info = (byte *) SC_change_alist(g->info, "VIEW-PORT", SC_REAL_P_S, pv);

    return((FIXNUM) TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
