/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

#include "prvavtab.h"


#define PRVAVTAB_SIZE 23


static unsigned int 
prvavhash(hashtab_key_t key)
{
	prvav_key_t    *keyp;


	keyp = (prvav_key_t *) key;

	return (keyp->target_sid + (keyp->source_sid << 4) + (keyp->target_class << 8)) % PRVAVTAB_SIZE;
}


static int 
prvavcmp(hashtab_key_t key1, hashtab_key_t key2)
{
	prvav_key_t    *keyp1, *keyp2;


	keyp1 = (prvav_key_t *) key1;
	keyp2 = (prvav_key_t *) key2;

	return !((keyp1->source_sid == keyp2->source_sid) &&
		 (keyp1->target_class == keyp2->target_class) &&
		 (keyp1->target_sid == keyp2->target_sid));
}


int 
prvavtab_init(prvavtab_t * a)
{
	a->table = hashtab_create(prvavhash, prvavcmp, PRVAVTAB_SIZE);
	if (!a->table)
		return -1;
	a->nel = 0;
	return 0;
}


/* FLASK */
