/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

%{
#include "ext.tab.h"

extern char *progname;
static unsigned int lineno = 1;

unsigned int extension_errors = 0;
%}
%array
letter  [A-Za-z]
digit   [0-9]
%%
CLASS |
class                           { return(CLASS); }
PARENT |
parent 				{ return(PARENT); }
CHILD |
child				{ return(CHILD); }
ADD |
add 				{ return(ADD); }
REMOVE |
remove 				{ return(REMOVE); }
ALLOW |
allow			        { return(ALLOW); }
SID_TRANSITION |
sid_transition		        { return(SID_TRANSITION); }
{letter}({letter}|{digit}|_)*	{ return(IDENTIFIER); }
#[^\n]*                         { /* delete comments */ }
[ \t\f]+			{ /* delete whitespace */ }
\n				{ /* delete whitespace */ lineno++; }
"," |
":" |
";" |
"(" | 
")" |
"{" | 
"}" |
"[" |
"-" |
"]"				{ return(exttext[0]); }
%%
int exterror(char *msg)
{
    fprintf(stderr, "\nerror in the statement ending on line %d (token '%s'): %s\n\n", lineno, exttext, msg);
    extension_errors++;
    return -1;
}

int extwrap()
{
    return 1;
}

/* FLASK */
