
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: polynom.h,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#ifndef __CAPOLYNOMIAL_HEADER__
#define __CAPOLYNOMIAL_HEADER__

#include "cobject.h"

@interface Polynomial : CAObject
{
  id scalarZero;
  id termZero;
  id monomialZero;
  id carrier;
  id _symbols;
  id _variables;
  id _zero;
  id _one;
  id _leadingTerm;
  id _leadingMonomial;
}
- check;

+ new;
- _setUpCarrier:aCarrier;
+ over:aCarrier;
+ scalar:aScalar;
- copy;
- deepCopy;
- invalidate;
- clone;
- carrier;
- over:c;
- empty;
- differentCarrier:c;
- emptyScalarZero:aZero;
- emptyVariableDense:symbols;
- emptyVariableSparse;
- emptyExpanded;
- emptyRecursive;
- emptyDegreeSparse;
- emptyDegreeDense;

+ wilkinsonDegree:(int)n;
+ randomDegree:(int)n;
+ bernouilliDegree:(int)n;
+ binomialDegree:(int)n;
+ chebyshevTDegree:(int)n;
+ chebyshevUDegree:(int)n;
+ cyclotomicDegree:(int)n;
+ eulerDegree:(int)n;
+ hermiteDegree:(int)n;
+ laguerreDegree:(int)n;
+ legendreDegree:(int)n;

- scalarZero;
- termZero;
- monomialZero;
+ classTerms;
+ classMonomials;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isRecursive;
- (BOOL) isExpanded;
- (BOOL) isVariableSparse;
- (BOOL) isVariableDense;
- (BOOL) isDegreeDense;
- (BOOL) isDegreeSparse;
- (BOOL) isUnivariate;
- (BOOL) inUnivariateDomain;
- (BOOL) isMultivariate;

- (int) intValue;
- intValue:(int)aValue;
- (float) floatValue;
- floatValue:(float)aValue;
- asScalar;
- scalar:aScalar;
- asSymbol;
- symbol:aSymbol;
- asTerm;
- asMonomial;
- asMember;
- asCoefficient;
- asNumerical;
- asModp:(unsigned short)p;
- commonDenominator;
- onCommonDenominator;

- (int) compareSymbols:aTerm;
- addSymbolsTo:aCltn;
- symbols;
- variables;

- (int) degree;
- (int) order;

- (int) numTerms;
- (int) numMonomials;
- (unsigned) size;

- removeTerm;
- insertTerm:aTerm;
- removeMonomial;
- insertMonomial:aMonomial;
- removeLast;
- insertMember:aMember;

- eachTerm;
- eachMonomial;
- eachSequence;
- memberZero;
- eachElement;
- eachScalar;
- eachCoefficient;

- changeRepresentationTo:aPrototype;
- makeDegreeDense;
- makeDegreeSparse;
- makeRecursive;
- makeExpanded;
- makeVariableSparse;
- makeVariableDense;
- collect:symbols;

- leadingTerm;
- leadingCoefficient;
- (int) leadingSign;
- leadingMonomial;
- leadingScalar;

- (BOOL) isMonic;
- (BOOL) notMonic;
- makeMonic;
- makeSelfMonic;

- zero;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- addScalar:s;
- subtractScalar:s;

- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- multiply:b;
- multiplySelf:b;
- square;
- inverse;
- power:(int)n;
- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- multiplyCoefficient:aCoefficient;
- multiplySelfCoefficient:s;
- divideCoefficient:aCoefficient;
- divideSelfCoefficient:s;
- _add:(int)v:B multiplyCoefficient:b:(int)w;
- _addSelf:(int)v:B multiplyCoefficient:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyCoefficient:b:(int)w;
- multiplyTerm:aTerm;
- multiplySelfTerm:s;
- divideTerm:aTerm;
- divideSelfTerm:s;
- _add:(int)v:B multiplyTerm:b:(int)w;
- _addSelf:(int)v:B multiplyTerm:b:(int)w;
- _multiplyCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;
- _multiplySelfCoefficient:a:(int)v add:B multiplyTerm:b:(int)w;
- multiplyMonomial:s;
- multiplySelfMonomial:s;
- divideMonomial:s;
- divideSelfMonomial:s;
- _add:(int)v:B multiplyMonomial:b:(int)w;
- _addSelf:(int)v:B multiplyMonomial:b:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyMonomial:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyMonomial:b:(int)w;

- remainder:b quotient:(id *)q;
- divide:b;
- divideSelf:b;
- remainderReductum:r term:t quotient:(id *)q;
- remainderReductum:r monicTerm:t quotient:(id *)q;
- remainderReductum:r term:t inverse:s quotient:(id *)q;
- remainderReductum:r term:t coefficient:s quotient:(id *)q;
- remainderReductum:r monomial:t quotient:(id *)q;
- remainderReductum:r monicMonomial:t quotient:(id *)q;
- remainderReductum:r monomial:t inverse:s quotient:(id *)q;
- remainderReductum:r monomial:t scalar:s quotient:(id *)q;

- pseudoRemainder:b quotient:(id *)q;
- pseudoRemainder:b;
- pseudoRemainderSelf:b;
- pseudoRemainderReductum:r term:t quotient:(id *)q;
- pseudoRemainderReductum:r term:t coefficient:s quotient:(id *)q sparsityCount:(int *)cref;

- content;
- divideContent;
- divideSelfContent;
- coefficientContent;
- divideCoefficientContent;
- divideSelfCoefficientContent;
- termContent;
- monomialContent;

- doImprovedSubresultant:(id *)pref:(id *)qref;
- fieldGcd:b;
- idomGcd:b;
- gcd:b;
- resultant:b;
- resultant:b wrt:(STR)aSymbol;
- discriminant;

- signedPseudoRemainder:B;
- signedPseudoRemainderSelf:b;
- (int) signedPseudoRemainderList:g plus:(int*)plus minus:(int*)minus;
- (int) vRealRoots:g;
- (int) numRealRoots;
- (int) varRealRoots:g;

- factor;
- (BOOL) isSquareFree;
- factorSymbol:aSymbol exponent:(int)anExponent;
- factorSquareFreeDerivative:dself gcd:gcd;
- factorSquareFreeDerivative:dself gcd:gcd characteristic:(unsigned)p;
- factorSquareFree;

- truncateAtDegree:(int)d;
- truncateSelfAtDegree:(int)d;

- frobenius;
- frobeniusInverse;

- evaluate:aScalar;
- evaluate:(STR)aSymbol at:aScalar;
- evaluateAll:cltnOfScalars;
- (float) floatEvaluate:(float)floatValue;
- (float) floatEvaluateAll:(float *)floatValues;
- substitute:aPolynomial;
- substitute:(STR)aSymbol by:aPolynomial;
- substituteAll:cltnOfPolynomials;

- derive;
- deriveWrt:(STR)aSymbol;
- integrate;
- integrateWrt:(STR)aSymbol;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
@end

#endif /* __CAPOLYNOMIAL_HEADER__ */
 
