/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */


#include <stdio.h>
#include <string.h>
#include "Buffer.h"


Buffer::Buffer() :
	fName(0),
	fData(0),
	fLength(0)
{
}


Buffer::~Buffer()
{
	delete [] fName;
	delete [] fData;
}


void Buffer::Create(const char *name, FILE *fp)
{
	int length;
	
	// figure out length
	fseek(fp, 0, SEEK_END);
	length = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	// allcoate memory (allow for trailing NL)
	fData = new char[length + 1];
	fLength = fread(fData, 1, length, fp);

	FinishCreate(name);	
}


void Buffer::Create(const char *name, const char *data, int length)
{	
	// allcoate memory (allow for trailing NL)
	fData = new char[length + 1];
	fLength = length;
	memcpy(fData, data, length);

	FinishCreate(name);	
}


void Buffer::FinishCreate(const char *name)
{
	fName = new char[strlen(name) + 1];
	strcpy(fName, name);
	
	fData[fLength++] = '\n';	
	ConvertLineEndings();
}


const char *Buffer::GetLine(int line) const
{
	if (line < 1) return 0;
	
	const char *ptr = fData;
	const char *end = fData + fLength;

	--line;
	while(line)
	{
		if (ptr == end) return 0;
		if (*ptr++ == '\n')
			--line;
	}	

	return ptr;
}


#define CR	0x0d
#define LF	0x0a

void Buffer::ConvertLineEndings()
{
	const char *src, *end;
	char *dst;
	
	src = fData;
	end = src + fLength;
	dst = fData;
	
	while(src < end)
	{
		char c = *src++;
		
		switch(c)
		{
			case CR:
				*dst++ = '\n';
				// skip second part of CR-LF pair
				if (src < end && *src==LF)
					src++;
				break;			
			case LF:
				*dst++ = '\n';
				break;
			default:
				*dst++ = c;
				break;
		}		
	}
	
	fLength = dst - fData;
}


