/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.View;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;

class HRuleView
extends View {
    private Border bevel;
    private float margin_left;
    private float margin_right;
    private int alignment = 0;
    private String noshade;
    private int size;
    private int hrwidth;

    public HRuleView(Element element) {
        super(element);
        AttributeSet attributeSet = element.getAttributes();
        if (attributeSet != null) {
            String string;
            this.margin_left = StyleConstants.getLeftIndent(attributeSet);
            this.margin_right = StyleConstants.getRightIndent(attributeSet);
            if (this.margin_left <= 0.0f) {
                this.margin_left = 15.0f;
            }
            if (this.margin_right <= 0.0f) {
                this.margin_right = 15.0f;
            }
            this.alignment = StyleConstants.getAlignment(attributeSet);
            this.noshade = (String)attributeSet.getAttribute("noshade");
            String string2 = (String)attributeSet.getAttribute("size");
            if (string2 != null) {
                this.size = Integer.valueOf(string2);
            }
            if ((string = (String)attributeSet.getAttribute("width")) != null) {
                this.hrwidth = Integer.valueOf(string);
            }
        }
        this.bevel = BorderFactory.createLoweredBevelBorder();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        int n = 0;
        int n2 = rectangle.y;
        int n3 = rectangle.width - (int)(this.margin_left + this.margin_right);
        if (this.hrwidth > 0) {
            n3 = this.hrwidth;
        }
        int n4 = rectangle.height;
        if (this.size > 0) {
            n4 = this.size;
        }
        switch (this.alignment) {
            case 1: {
                n = rectangle.x + rectangle.width / 2 - n3 / 2;
                break;
            }
            case 2: {
                n = rectangle.x + rectangle.width - this.hrwidth - (int)this.margin_right;
                break;
            }
            default: {
                n = rectangle.x + (int)this.margin_left;
            }
        }
        if (this.noshade == "#DEFAULT") {
            graphics.fillRect(n, n2, n3, n4);
            return;
        }
        this.bevel.paintBorder(this.getContainer(), graphics, n, n2, n3, n4);
    }

    public float getPreferredSpan(int n) {
        Insets insets = this.bevel.getBorderInsets(this.getContainer());
        switch (n) {
            case 0: {
                return insets.left + insets.right;
            }
            case 1: {
                if (this.size > 0) {
                    return this.size;
                }
                if (this.noshade == "#DEFAULT") {
                    return 1.0f;
                }
                return insets.top + insets.bottom;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public int getResizeWeight(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        return 0;
    }

    public Shape modelToView(int n, Shape shape) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n < n3) {
            Rectangle rectangle = new Rectangle(shape.getBounds());
            rectangle.width = 0;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape) {
        shape.getBounds();
        return this.getStartOffset();
    }
}

