/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JToolBar;
import com.sun.java.swing.border.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class StateButtons
extends JToolBar
implements ActionListener,
ItemListener {
    ClogDisplay parent;
    private Vector hists;
    private int numCols;
    private JCheckBox arrowsChkBox;

    public StateButtons(ClogDisplay clogDisplay, int n) {
        this.parent = clogDisplay;
        this.numCols = n;
        this.hists = new Vector();
        this.setupPanels();
    }

    private void setupPanels() {
        JScrollPane jScrollPane;
        CLOG_STATE cLOG_STATE;
        Border border = BorderFactory.createLoweredBevelBorder();
        JPanel jPanel = new JPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        JPanel jPanel2 = new JPanel((LayoutManager)new GridBagLayout());
        Border border2 = BorderFactory.createEmptyBorder((int)4, (int)4, (int)2, (int)4);
        jPanel2.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
        JPanel jPanel3 = new JPanel((LayoutManager)new GridBagLayout());
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.parent.stateDefs.elements();
        while (enumeration.hasMoreElements()) {
            cLOG_STATE = (CLOG_STATE)enumeration.nextElement();
            if (cLOG_STATE.stateVector.size() <= 0) continue;
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n++;
            MyButton myButton = new MyButton(cLOG_STATE.description.desc, "Press for " + cLOG_STATE.description.desc + " histogram", this);
            jPanel3.add((Component)((Object)myButton), gridBagConstraints);
            myButton.setIcon(new ColoredRect(cLOG_STATE.color));
            myButton.setHorizontalAlignment(2);
            gridBagConstraints.gridx = n2 + 1;
            cLOG_STATE.checkbox = new JCheckBox("", true);
            jPanel3.add((Component)cLOG_STATE.checkbox, gridBagConstraints);
            cLOG_STATE.checkbox.addItemListener((ItemListener)this);
            cLOG_STATE.checkbox.setToolTipText("Enable or disable " + cLOG_STATE.description.desc);
            if (n2 / 2 == this.numCols) {
                n2 = 0;
                continue;
            }
            n2 += 2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        cLOG_STATE = new JPanel((LayoutManager)new GridLayout(2, 1));
        ((Container)((Object)cLOG_STATE)).add((Component)((Object)new MyButton("All States On", "Enable all states", this)));
        ((Container)((Object)cLOG_STATE)).add((Component)((Object)new MyButton("All States Off", "Disable all states", this)));
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)((Object)cLOG_STATE), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.parent.arrowDef.stateVector.size() > 0) {
            jScrollPane = new JPanel((LayoutManager)new GridBagLayout());
            border2 = BorderFactory.createEmptyBorder((int)2, (int)4, (int)4, (int)4);
            jScrollPane.setBorder((Border)BorderFactory.createCompoundBorder((Border)border2, (Border)border));
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            jScrollPane.add((Component)((Object)new MyButton("Messages", "Press for Messages histogram", this)));
            gridBagConstraints.gridx = 1;
            this.arrowsChkBox = new JCheckBox("", this.parent.canvas.arrowDispStatus);
            jScrollPane.add((Component)this.arrowsChkBox, gridBagConstraints);
            this.arrowsChkBox.addItemListener((ItemListener)this);
            this.arrowsChkBox.setToolTipText("Enable or disable Messages");
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)jScrollPane, gridBagConstraints);
        }
        jScrollPane = new JScrollPane((Component)jPanel);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        ((Container)((Object)this)).add((Component)jScrollPane);
    }

    private void switchAll(boolean bl) {
        Enumeration enumeration = this.parent.stateDefs.elements();
        while (enumeration.hasMoreElements()) {
            CLOG_STATE cLOG_STATE = (CLOG_STATE)enumeration.nextElement();
            if (cLOG_STATE.stateVector.size() <= 0) continue;
            cLOG_STATE.checkbox.setSelected(bl);
        }
    }

    private void getStateHistogram(String string) {
        this.waitCursor();
        this.parent.waitCursor();
        this.parent.canvas.waitCursor();
        this.parent.parent.waitCursor();
        CLOG_STATE cLOG_STATE = this.getState(string);
        if (cLOG_STATE != null) {
            this.hists.addElement(new Histwin(cLOG_STATE, this.parent));
        }
        this.parent.parent.normalCursor();
        this.parent.canvas.normalCursor();
        this.parent.normalCursor();
        this.normalCursor();
    }

    private CLOG_STATE getState(String string) {
        CLOG_STATE cLOG_STATE;
        Enumeration enumeration = this.parent.stateDefs.elements();
        while (enumeration.hasMoreElements()) {
            cLOG_STATE = (CLOG_STATE)enumeration.nextElement();
            if (cLOG_STATE.description.desc.compareTo(string) != 0) continue;
            return cLOG_STATE;
        }
        cLOG_STATE = this.parent.arrowDef;
        if (cLOG_STATE.description.desc.compareTo("Messages") == 0) {
            this.parent.canvas.calcArrowLens();
            return cLOG_STATE;
        }
        new ErrorDiag((Component)((Object)this), "State " + string + " does not exist");
        return null;
    }

    int print(Graphics graphics, int n, int n2, int n3, int n4) {
        Font font = graphics.getFont();
        FontMetrics fontMetrics = ((Component)((Object)this)).getToolkit().getFontMetrics(font);
        int n5 = fontMetrics.stringWidth(" ");
        int n6 = fontMetrics.getHeight();
        int n7 = n5;
        int n8 = 2 * n5;
        int n9 = fontMetrics.getAscent();
        int n10 = 30;
        int n11 = n6;
        int n12 = n;
        int n13 = n2;
        Enumeration enumeration = this.parent.stateDefs.elements();
        while (enumeration.hasMoreElements()) {
            CLOG_STATE cLOG_STATE = (CLOG_STATE)enumeration.nextElement();
            if (cLOG_STATE.stateVector.size() <= 0) continue;
            int n14 = fontMetrics.stringWidth(cLOG_STATE.description.desc);
            if (n12 + n10 + n7 + n14 > n3 + n) {
                n12 = n;
                n13 += n6 + n9;
            }
            graphics.setColor(cLOG_STATE.color);
            graphics.fillRect(n12, n13, n10, n11);
            graphics.setColor(Color.black);
            graphics.drawRect(n12, n13, n10 - 1, n11 - 1);
            graphics.drawString(cLOG_STATE.description.desc, n12 + n10 + n7, n13 + n11 - fontMetrics.getDescent() - 1);
            n12 += n10 + n7 + n14 + n8;
        }
        return n13 - n2 + 2 * n6;
    }

    void waitCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(3));
    }

    void normalCursor() {
        ((Component)((Object)this)).setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("All States On")) {
            this.switchAll(true);
            this.parent.canvas.Refresh();
            return;
        }
        if (string.equals("All States Off")) {
            this.switchAll(false);
            this.parent.canvas.Refresh();
            return;
        }
        this.getStateHistogram(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object == this.arrowsChkBox) {
            this.parent.canvas.arrowDispStatus = this.arrowsChkBox.isSelected();
        }
        this.parent.canvas.Refresh();
    }

    private void killHists() {
        if (this.hists.size() > 0) {
            Enumeration enumeration = this.hists.elements();
            while (enumeration.hasMoreElements()) {
                Histwin histwin = (Histwin)enumeration.nextElement();
                if (histwin == null) continue;
                histwin.kill();
                histwin = null;
            }
            this.hists.removeAllElements();
        }
    }

    void kill() {
        this.killHists();
        ((Container)((Object)this)).removeAll();
    }
}

