/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ClogReader
extends JDialog {
    private double firsttime;
    private boolean swap;
    private int numEvt1;
    private int numEvt2;
    private int numrawevt;
    private int rawevtno;
    RecordHandler mainTool;
    private String logFileName;
    private boolean aplt;
    private boolean cancel = false;
    private MyButton interruptButton;
    private JLabel statusField;
    private JProgressBar progressBar = new JProgressBar();
    private ActionListener interruptListener = new 3();

    public ClogReader(JFrame jFrame, String string, boolean bl) {
        super((Frame)jFrame, "Reading logfile");
        this.logFileName = string;
        this.aplt = bl;
        this.getContentPane().setLayout(new BorderLayout());
        MyJPanel myJPanel = new MyJPanel(new GridBagLayout(), null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((Container)((Object)myJPanel)).add((Component)new JLabel("Reading " + this.logFileName), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.progressBar = new JProgressBar();
        ((Container)((Object)myJPanel)).add((Component)this.progressBar, gridBagConstraints);
        this.progressBar.setMaximum(100);
        gridBagConstraints.gridy = 2;
        char[] cArray = new char[40];
        int n = 0;
        while (n < 40) {
            cArray[n] = 32;
            ++n;
        }
        this.statusField = new JLabel(new String(cArray));
        ((Container)((Object)myJPanel)).add((Component)this.statusField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        this.interruptButton = new MyButton("Cancel", this.interruptListener);
        ((Container)((Object)myJPanel)).add((Component)((Object)this.interruptButton), gridBagConstraints);
        this.getContentPane().add((Component)((Object)myJPanel), "Center");
        ((Window)((Object)this)).pack();
        ROUTINES.makeCursor((Component)((Object)this), new Cursor(3));
        ((Component)((Object)this)).setVisible(true);
        ((Dialog)((Object)this)).setResizable(false);
        this.ReadClogFile();
        ((Window)((Object)this)).dispose();
    }

    private void ReadClogFile() {
        String string = this.logFileName;
        this.mainTool = new RecordHandler();
        this.statusField.setText("Checking endian");
        boolean bl = this.checkEndian(string, this.mainTool);
        if (!bl) {
            this.mainTool = null;
            return;
        }
        this.statusField.setText("Making first pass over file");
        bl = this.getStateDefs(string, this.mainTool);
        if (!bl) {
            this.mainTool = null;
            return;
        }
        this.mainTool.setDataSize(this.numrawevt);
        bl = this.getRawEvents(string, this.mainTool);
        if (!bl) {
            this.mainTool = null;
            return;
        }
    }

    private boolean checkEndian(String string, RecordHandler recordHandler) {
        InputStream inputStream;
        int n = CLOG_HEADER.getSize();
        byte[] byArray = new byte[n];
        if (!this.aplt ? (inputStream = this.getFileIn(string)) == null : (inputStream = this.getUrlIn(string)) == null) {
            return false;
        }
        try {
            new DataInputStream(new BufferedInputStream(inputStream, n)).readFully(byArray);
        }
        catch (EOFException eOFException) {
            new ErrorDiag(null, eOFException.getMessage());
            this.close(inputStream, string);
            return false;
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "IOException while reading logfile");
            this.close(inputStream, string);
            return false;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        CLOG_HEADER cLOG_HEADER = new CLOG_HEADER();
        cLOG_HEADER.readBigEnd(dataInputStream);
        int n2 = cLOG_HEADER.rectype;
        switch (n2) {
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.swap = false;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, (Object)("Unrecognized record type:" + n2 + ". Maybe the file is little endian"), (String)"Unrecognized record type", (int)1);
                this.swap = true;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "logfile:" + string + " cannot be closed.");
            return false;
        }
        if (Thread.interrupted() || this.cancel) {
            return false;
        }
        Thread.yield();
        return true;
    }

    private boolean getStateDefs(String string, RecordHandler recordHandler) {
        InputStream inputStream;
        int n = 1024;
        if (!this.aplt ? (inputStream = this.getFileIn(string)) == null : (inputStream = this.getUrlIn(string)) == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        this.numEvt1 = 0;
        this.numrawevt = 0;
        int n2 = this.readStates(bufferedInputStream, recordHandler);
        while (n2 == n) {
            this.updateStatus(this.numEvt1 % 100);
            if (Thread.interrupted() || this.cancel) {
                this.close(bufferedInputStream, string);
                return false;
            }
            Thread.yield();
            n2 = this.readStates(bufferedInputStream, recordHandler);
        }
        try {
            ((FilterInputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "logfile:" + string + " cannot be closed");
            return false;
        }
        if (n2 != 0) {
            return false;
        }
        if (recordHandler.stateDefs.size() < 1) {
            new ErrorDiag(null, "No states specified in logfile. Exiting read");
            return false;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readStates(BufferedInputStream bufferedInputStream, RecordHandler recordHandler) {
        int n;
        int n2 = n = 1024;
        byte[] byArray = new byte[n];
        try {
            new DataInputStream(bufferedInputStream).readFully(byArray);
        }
        catch (EOFException eOFException) {
            return 0;
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "IOException occurred while reading logfile.");
            return -1;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        CLOG_HEADER cLOG_HEADER = new CLOG_HEADER();
        new CLOG_RAW();
        int n3 = 0;
        if (true) {
            return n2;
        }
        do {
            block22: {
                if (this.swap) {
                    cLOG_HEADER.readLitEnd(dataInputStream);
                } else {
                    cLOG_HEADER.readBigEnd(dataInputStream);
                }
                n3 = cLOG_HEADER.rectype;
                ++this.numEvt1;
                try {
                    switch (n3) {
                        case 6: {
                            CLOG_STATE cLOG_STATE = new CLOG_STATE();
                            if (this.swap) {
                                cLOG_STATE.readLitEnd(dataInputStream);
                            } else {
                                cLOG_STATE.readBigEnd(dataInputStream);
                            }
                            recordHandler.HandleStateDef(cLOG_STATE);
                            break block22;
                        }
                        case 1: {
                            ++this.numrawevt;
                            dataInputStream.skipBytes(CLOG_RAW.getSize());
                            break block22;
                        }
                        case 7: {
                            dataInputStream.skipBytes(CLOG_SRC.getSize());
                            break block22;
                        }
                        case 4: {
                            dataInputStream.skipBytes(CLOG_COMM.getSize());
                            break block22;
                        }
                        case 2: {
                            dataInputStream.skipBytes(CLOG_MSG.getSize());
                            break block22;
                        }
                        case 3: {
                            dataInputStream.skipBytes(CLOG_COLL.getSize());
                            break block22;
                        }
                        case 5: {
                            dataInputStream.skipBytes(CLOG_EVENT.getSize());
                            break block22;
                        }
                        default: {
                            new ErrorDiag(null, "Unrecognized record type:" + n3);
                            return -1;
                        }
                        case -2: 
                        case -1: {
                            if (n3 == -1) return n2;
                            break;
                        }
                    }
                    continue;
                }
                catch (IOException iOException) {
                    new ErrorDiag(null, "IOException occured while reading logfile");
                    return -1;
                }
            }
            if (n3 == -1) return n2;
        } while (n3 != -2);
        return n2;
    }

    private boolean getRawEvents(String string, RecordHandler recordHandler) {
        InputStream inputStream;
        int n = 1024;
        if (!this.aplt ? (inputStream = this.getFileIn(string)) == null : (inputStream = this.getUrlIn(string)) == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        this.firsttime = 0.0;
        this.numEvt2 = 0;
        this.rawevtno = 0;
        int n2 = this.readRaw(bufferedInputStream, recordHandler);
        while (n2 == n) {
            int n3 = this.numEvt2 * 100 / this.numEvt1;
            this.updateStatus(n3);
            this.updateStatField(n3);
            if (Thread.interrupted() || this.cancel) {
                this.close(bufferedInputStream, string);
                return false;
            }
            Thread.yield();
            n2 = this.readRaw(bufferedInputStream, recordHandler);
        }
        try {
            ((FilterInputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "logfile:" + string + " cannot be closed." + " Proceeding anyway.");
        }
        return n2 == 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readRaw(BufferedInputStream bufferedInputStream, RecordHandler recordHandler) {
        int n;
        int n2 = n = 1024;
        byte[] byArray = new byte[n];
        try {
            new DataInputStream(bufferedInputStream).readFully(byArray);
        }
        catch (EOFException eOFException) {
            return 0;
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "IOException occured while reading logfile.");
            return -1;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        CLOG_HEADER cLOG_HEADER = new CLOG_HEADER();
        CLOG_RAW cLOG_RAW = new CLOG_RAW();
        int n3 = 0;
        if (true) {
            return n2;
        }
        do {
            block23: {
                if (this.swap) {
                    cLOG_HEADER.readLitEnd(dataInputStream);
                } else {
                    cLOG_HEADER.readBigEnd(dataInputStream);
                }
                n3 = cLOG_HEADER.rectype;
                ++this.numEvt2;
                try {
                    switch (n3) {
                        case 1: {
                            if (this.rawevtno++ == 0) {
                                this.firsttime = cLOG_HEADER.timestamp;
                            }
                            if (this.swap) {
                                cLOG_RAW.readLitEnd(dataInputStream);
                            } else {
                                cLOG_RAW.readBigEnd(dataInputStream);
                            }
                            cLOG_HEADER.timestamp -= this.firsttime;
                            recordHandler.HandleRaw(new RECORD(cLOG_HEADER, cLOG_RAW));
                            break block23;
                        }
                        case 6: {
                            dataInputStream.skipBytes(CLOG_STATE.getSize());
                            break block23;
                        }
                        case 7: {
                            dataInputStream.skipBytes(CLOG_SRC.getSize());
                            break block23;
                        }
                        case 4: {
                            dataInputStream.skipBytes(CLOG_COMM.getSize());
                            break block23;
                        }
                        case 2: {
                            dataInputStream.skipBytes(CLOG_MSG.getSize());
                            break block23;
                        }
                        case 3: {
                            dataInputStream.skipBytes(CLOG_COLL.getSize());
                            break block23;
                        }
                        case 5: {
                            dataInputStream.skipBytes(CLOG_EVENT.getSize());
                            break block23;
                        }
                        default: {
                            new ErrorDiag(null, "Unrecognized record type:" + n3);
                            return -1;
                        }
                        case -2: 
                        case -1: {
                            if (n3 == -1) return n2;
                            break;
                        }
                    }
                    continue;
                }
                catch (IOException iOException) {
                    new ErrorDiag(null, "IOException occured while reading logfile");
                    return -1;
                }
            }
            if (n3 == -1) return n2;
        } while (n3 != -2);
        return n2;
    }

    private boolean getData(String string, RecordHandler recordHandler) {
        InputStream inputStream;
        int n = 1024;
        if (!this.aplt ? (inputStream = this.getFileIn(string)) == null : (inputStream = this.getUrlIn(string)) == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n);
        this.firsttime = 0.0;
        this.rawevtno = 0;
        this.numEvt1 = 0;
        int n2 = this.readBlock(bufferedInputStream, recordHandler);
        while (n2 == n) {
            this.updateStatus(this.numEvt1 % 100);
            if (Thread.interrupted() || this.cancel) {
                this.close(bufferedInputStream, string);
                return false;
            }
            Thread.yield();
            n2 = this.readBlock(bufferedInputStream, recordHandler);
        }
        try {
            ((FilterInputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "logfile:" + string + " cannot be closed." + " Proceeding anyway.");
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readBlock(BufferedInputStream bufferedInputStream, RecordHandler recordHandler) {
        int n = 1024;
        int n2 = 0;
        byte[] byArray = new byte[n];
        try {
            new DataInputStream(bufferedInputStream).readFully(byArray);
        }
        catch (EOFException eOFException) {
            return 0;
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "IOException occured while reading logfile.");
            return -1;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        CLOG_HEADER cLOG_HEADER = new CLOG_HEADER();
        CLOG_RAW cLOG_RAW = new CLOG_RAW();
        int n3 = 0;
        if (true) {
            return n2;
        }
        do {
            block25: {
                if (this.swap) {
                    cLOG_HEADER.readLitEnd(dataInputStream);
                } else {
                    cLOG_HEADER.readBigEnd(dataInputStream);
                }
                n3 = cLOG_HEADER.rectype;
                ++this.numEvt1;
                try {
                    switch (n3) {
                        case 1: {
                            if (this.rawevtno++ == 0) {
                                this.firsttime = cLOG_HEADER.timestamp;
                            }
                            if (this.swap) {
                                cLOG_RAW.readLitEnd(dataInputStream);
                            } else {
                                cLOG_RAW.readBigEnd(dataInputStream);
                            }
                            cLOG_HEADER.timestamp -= this.firsttime;
                            recordHandler.HandleRaw(new RECORD(cLOG_HEADER, cLOG_RAW));
                            break block25;
                        }
                        case 6: {
                            CLOG_STATE cLOG_STATE = new CLOG_STATE();
                            if (this.swap) {
                                cLOG_STATE.readLitEnd(dataInputStream);
                            } else {
                                cLOG_STATE.readBigEnd(dataInputStream);
                            }
                            recordHandler.HandleStateDef(cLOG_STATE);
                            break block25;
                        }
                        case 7: {
                            dataInputStream.skipBytes(CLOG_SRC.getSize());
                            break block25;
                        }
                        case 4: {
                            dataInputStream.skipBytes(CLOG_COMM.getSize());
                            break block25;
                        }
                        case 2: {
                            dataInputStream.skipBytes(CLOG_MSG.getSize());
                            break block25;
                        }
                        case 3: {
                            dataInputStream.skipBytes(CLOG_COLL.getSize());
                            break block25;
                        }
                        case 5: {
                            dataInputStream.skipBytes(CLOG_EVENT.getSize());
                            break block25;
                        }
                        default: {
                            new ErrorDiag(null, "Unrecognized record type:" + n3);
                            return -1;
                        }
                        case -2: 
                        case -1: {
                            if (n3 == -1) return n2;
                            break;
                        }
                    }
                    continue;
                }
                catch (IOException iOException) {
                    new ErrorDiag(null, "IOException occured while reading logfile.");
                    return -1;
                }
            }
            if (n3 == -1) return n2;
        } while (n3 != -2);
        return n2;
    }

    private InputStream getFileIn(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            new ErrorDiag(null, "file: " + string + " not found.");
            return null;
        }
        return fileInputStream;
    }

    private InputStream getUrlIn(String string) {
        URL uRL = null;
        InputStream inputStream = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            new ErrorDiag(null, "Bad URL:" + uRL);
            return null;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "IO Error:" + iOException.getMessage());
            return null;
        }
        return inputStream;
    }

    private void updateStatus(int n) {
        1 var2_2 = new 1(n, this);
        SwingUtilities.invokeLater((Runnable)var2_2);
    }

    private void updateStatField(int n) {
        2 var2_2 = new 2(n, this);
        SwingUtilities.invokeLater((Runnable)var2_2);
    }

    private void close(InputStream inputStream, String string) {
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            new ErrorDiag(null, "logfile:" + string + " cannot be closed");
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    static /* synthetic */ boolean access$0(ClogReader clogReader) {
        return clogReader.cancel;
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ int val$i;
        private final /* synthetic */ ClogReader this$0;

        public void run() {
            this.this$0.progressBar.setValue(this.val$i);
        }

        /* synthetic */ 1(int n, ClogReader clogReader) {
            this.val$i = n;
            this.this$0 = clogReader;
        }
    }

    private static final class 2
    implements Runnable {
        private final /* synthetic */ int val$i;
        private final /* synthetic */ ClogReader this$0;

        public void run() {
            this.this$0.statusField.setText("Making second pass over file: " + this.val$i + "% done");
        }

        /* synthetic */ 2(int n, ClogReader clogReader) {
            this.val$i = n;
            this.this$0 = clogReader;
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ClogReader.this.cancel = true;
        }

        /* synthetic */ 3() {
        }
    }
}

