package com.jclark.xsl.util;

import java.util.Locale;
import java.text.NumberFormat;
import java.text.ParseException;

public class NumberComparator implements Comparator {
  private NumberFormat format;
  
  public NumberComparator(Locale locale) {
    if (locale == null)
      format = NumberFormat.getNumberInstance();
    else
      format = NumberFormat.getNumberInstance(locale);
  }

  public int compare(Object obj1, Object obj2) {
    double res = getValue(obj1) - getValue(obj2);
    if (res < 0.0)
      return -1;
    if (res > 0.0)
      return 1;
    return 0;
  }
  
  public double getValue(Object obj) {
    try {
      return format.parse(((String)obj).trim()).doubleValue();
    }
    catch (ParseException e) {
      return 0.0;
    }
  }

}

