package com.jclark.xsl.sax;

import org.xml.sax.*;
import java.io.*;

public class XMLFileWriter {
  static public void write(ResultTreeFragment frag, String file)
    throws SAXException {
    try {
      OutputStream out = new FileOutputStream(file);
      frag.emit(new XMLOutputHandler(out,
				     XMLOutputHandler.MINIMIZE_EMPTY_ELEMENTS),
		false);
    }
    catch (IOException e) {
      throw new SAXException(e);
    }
  }

  static public void indentWrite(ResultTreeFragment frag, String file)
    throws SAXException {
    try {
      OutputStream out = new FileOutputStream(file);
      frag.emit(new Indenter(new XMLOutputHandler(out,
						  XMLOutputHandler.MINIMIZE_EMPTY_ELEMENTS)),
		false);
    }
    catch (IOException e) {
      throw new SAXException(e);
    }
  }
}
