.TH ZLATZM l "08 October 1994" "LAPACK version 2.0" "LAPACK routine (version 2.0)"
.TH ZLATZM l "08 October 1994" "BLAS routine" "BLAS routine"
.SH NAME
ZLATZM - applie a Householder matrix generated by ZTZRQF to a matrix
.SH SYNOPSIS
.TP 19
SUBROUTINE ZLATZM(
SIDE, M, N, V, INCV, TAU, C1, C2, LDC, WORK )
.TP 19
.ti +4
CHARACTER
SIDE
.TP 19
.ti +4
INTEGER
INCV, LDC, M, N
.TP 19
.ti +4
COMPLEX*16
TAU
.TP 19
.ti +4
COMPLEX*16
C1( LDC, * ), C2( LDC, * ), V( * ), WORK( * )
.SH PURPOSE
ZLATZM applies a Householder matrix generated by ZTZRQF to a matrix.

Let P = I - tau*u*u',   u = ( 1 ),
.br
                            ( v )
.br
where v is an (m-1) vector if SIDE = 'L', or a (n-1) vector if
SIDE = 'R'.
.br

If SIDE equals 'L', let
.br
       C = [ C1 ] 1
.br
           [ C2 ] m-1
.br
             n
.br
Then C is overwritten by P*C.
.br

If SIDE equals 'R', let
.br
       C = [ C1, C2 ] m
.br
              1  n-1
.br
Then C is overwritten by C*P.
.br

.SH ARGUMENTS
.TP 8
SIDE    (input) CHARACTER*1
= 'L': form P * C
.br
= 'R': form C * P
.TP 8
M       (input) INTEGER
The number of rows of the matrix C.
.TP 8
N       (input) INTEGER
The number of columns of the matrix C.
.TP 8
V       (input) COMPLEX*16 array, dimension
(1 + (M-1)*abs(INCV)) if SIDE = 'L'
(1 + (N-1)*abs(INCV)) if SIDE = 'R'
The vector v in the representation of P. V is not used
if TAU = 0.
.TP 8
INCV    (input) INTEGER
The increment between elements of v. INCV <> 0
.TP 8
TAU     (input) COMPLEX*16
The value tau in the representation of P.
.TP 8
C1      (input/output) COMPLEX*16 array, dimension
(LDC,N) if SIDE = 'L'
(M,1)   if SIDE = 'R'
On entry, the n-vector C1 if SIDE = 'L', or the m-vector C1
if SIDE = 'R'.

On exit, the first row of P*C if SIDE = 'L', or the first
column of C*P if SIDE = 'R'.
.TP 8
C2      (input/output) COMPLEX*16 array, dimension
(LDC, N)   if SIDE = 'L'
(LDC, N-1) if SIDE = 'R'
On entry, the (m - 1) x n matrix C2 if SIDE = 'L', or the
m x (n - 1) matrix C2 if SIDE = 'R'.

On exit, rows 2:m of P*C if SIDE = 'L', or columns 2:m of C*P
if SIDE = 'R'.
.TP 8
LDC     (input) INTEGER
The leading dimension of the arrays C1 and C2.
LDC >= max(1,M).
.TP 8
WORK    (workspace) COMPLEX*16 array, dimension
(N) if SIDE = 'L'
(M) if SIDE = 'R'
