/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: rtrstore.c,v $
 *	Revision 6.2  1999/05/26 21:50:03  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:26:20  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:05:44  gdburns
 * Ohio Release
 * 
 *	Function:	- stores trace data with traced
 *			- generates 1 to N store requests, each less
 *			  than MAXNMSGLEN
 *
 *	Accepts:	- target node ID (should be LOCAL)
 *			- list number
 *			- process ID
 *			- ptr to trace data buffer
 *			- buffer length
 *
 *	Returns:	- return value of nsend()
 */

#include <events.h>
#include <net.h>
#include <portable.h>
#include <trreq.h>
#include <typical.h>

int
lam_rtrstore(nodeid, lnum, pid, buffer, length)

int4			nodeid;
int4			lnum;
int4			pid;
CONST char		*buffer;
int4			length;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;

	request->trq_req = TRQSTORE;
	request->trq_pid = pid;
	request->trq_lnum = lnum;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = (char *) buffer;

	while (length > 0) {
		nhead.nh_length = (length > MAXNMSGLEN) ? MAXNMSGLEN : length;
		request->trq_length = nhead.nh_length;

		if (nsend(&nhead)) return(LAMERROR);

		length -= nhead.nh_length;
		buffer += nhead.nh_length;
	}

	return(0);
}
