/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/NJN
 *
 *	$Id: rfatexit.c,v 6.3 1999/06/09 23:10:07 jsquyres Exp $
 *
 *	Function:	- close file descriptors
 *			- don't bother with standard I/O
 */

#include <freq.h>
#include <kio.h>

/*
 * external variables
 */
extern struct fclient	_ufd[];			/* client file descs */
extern struct kio_t	_kio;			/* kernel IO block */

/*
 * external functions
 */
extern int		rfclose();

void
rfatexit()
{
    int			i;
    int			tfd;

    for (i = 0 ; i < FUMAX ; i++) {
	
	tfd = _ufd[i].fu_tfd;

	if (tfd > 2) {
/*
 * IO daemon now closes LAM stdio for remote processes (where necessary) but
 * it must still be done here for local processes.  Non-stdio descriptors must
 * be closed regardless.  
 */
	    if (_ufd[i].fu_tflags && !(_kio.ki_rtf & RTF_PFDIO)
		    && tfd != _kio.ki_stdout && tfd != _kio.ki_stderr) {

		lam_rfclose(i);
	    }
	}
    }
}
