/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: kdetach.c,v 6.5 1999/07/28 00:31:47 jsquyres Exp $
 * 
 *	Function:	- detaches calling process from the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

#include <unistd.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */

/*
 * external functions
 */
extern int		_cio_kreqfront();	/* make kernel request */

int
kdetach(pid)

int			pid;

{
	struct kreq	req;			/* kernel request */

	if (_kio.ki_pid != getpid()) {
		errno = ENOTATTACHED;	
		return(ERROR);
	}

	LAM_ZERO_ME(req);
	req.kq_req = KQDETACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = (pid == 0) ? getpid() : pid;

	if (_cio_kreqfront(&req) < 0) {
		return(ERROR);
	}

	if ((pid == 0) || (pid == getpid())) {
		_kio.ki_rtf &= ~RTF_KERNEL;	
		_kio.ki_pid = -1;	
		_kio.ki_index = -1;
	}

	return(0);
}
