#include <iostream>
#include <gtk--.h>

// Gtk-- version of the table packing example from the gtk+ tutorial

class MyWin : public Gtk_Window
{
public:
  MyWin();
  
  Gtk_Table m_table;
  Gtk_Button m_b1, m_b2, m_bQuit;

  void callback(char* data);

  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }

};

MyWin::MyWin() :
  m_table(2, 2, true),
  m_b1("button 1"),
  m_b2("button 2"),
  m_bQuit("Quit")
{
  set_title("Table");
  set_border_width(20);
  
  add(&m_table);

  m_table.attach_defaults(m_b1, 0, 1, 0, 1);
  m_table.attach_defaults(m_b2, 0, 2, 0, 1);
  m_table.attach_defaults(m_bQuit, 0, 2, 1, 2);
  
  connect_to_method(m_b1.clicked, this, &callback, "button 1");
  connect_to_method(m_b2.clicked, this, &callback, "button 2");
  connect_to_signal(m_bQuit.clicked, delete_event,
		    static_cast<GdkEventAny*>(0));
  // the cast is needed to "help" template instantiation

  show_all();
}

void
MyWin::callback(char* data)
{
  cout << "Hello again - " << data << " was pressed" << endl;
}


int main(int argc, char *argv[])
{
  Gtk_Main myapp(&argc, &argv);
  MyWin mywin;

  myapp.run();
  return 0;
}
