/* example-start rulers rulers.cc */

#include <gtk--.h>

#define XSIZE 600
#define YSIZE 400

class Wnd: public Gtk_Window
{
    Gtk_Table table;
    Gtk_DrawingArea area;
    Gtk_HRuler hrule;
    Gtk_VRuler vrule;
public:
    Wnd();
private:
    gint delete_event_impl(GdkEventAny*) { 
        Gtk_Main::instance()->quit(); return 0; 
    }
};

Wnd::Wnd():
    Gtk_Window(GTK_WINDOW_TOPLEVEL),
    table(3, 2, false)
{
    area.set_usize(XSIZE, YSIZE);
    area.set_events(GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);

    /* The horizontal ruler goes on top. As the mouse moves across the drawing area,
     * a motion_notify_event is passed to the appropriate event
     * handler for the ruler. */
    hrule.set_metric(GTK_PIXELS);
    hrule.set_range(7, 13, 0, 20);
    connect_to_signal(area.motion_notify_event,
		      hrule.motion_notify_event);
    
    /* The vertical ruler goes on the left. As the mouse moves across
     * the drawing area, a motion_notify_event is passed to the
     * appropriate event handler for the ruler. */
    vrule.set_metric(GTK_PIXELS);
    vrule.set_range(0, XSIZE, 10, YSIZE);
    connect_to_signal(area.motion_notify_event,
		      vrule.motion_notify_event);
    
    table.attach(area, 1, 2, 1, 2,
		 GTK_EXPAND|GTK_FILL, GTK_FILL, 0, 0);
    table.attach(vrule, 0, 1, 1, 2,
		 GTK_FILL, GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0);
    table.attach(hrule, 1, 2, 0, 1,
		 GTK_EXPAND|GTK_SHRINK|GTK_FILL, GTK_FILL, 0, 0);
    add(table);
    table.show_all();
}

int main(int argc, char *argv[])
{
    Gtk_Main m(&argc, &argv);
    Wnd window;

    window.show();
    m.run();
    
    return(0);
}
/* example-end */
