#include "ToolbarTest.h"


ToolBarTestWidget::ToolBarTestWidget () :
  Gtk_Toolbar ( GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH )
{

  pixHorizontal = new Gtk_Pixmap ( *this, "test.xpm" );
  pixVertical = new Gtk_Pixmap ( *this, "test.xpm" );
  pixIcons = new Gtk_Pixmap ( *this, "test.xpm" );
  pixText = new Gtk_Pixmap ( *this, "test.xpm" );
  pixBoth = new Gtk_Pixmap ( *this, "test.xpm" );
  pixSmall = new Gtk_Pixmap ( *this, "test.xpm" );
  pixBig = new Gtk_Pixmap ( *this, "test.xpm" );
  pixEnable = new Gtk_Pixmap ( *this, "test.xpm" );
  pixDisable = new Gtk_Pixmap ( *this, "test.xpm" );
  pixBorders = new Gtk_Pixmap ( *this, "test.xpm" );
  pixBorderless = new Gtk_Pixmap ( *this, "test.xpm" );
#if GTK_VERSION_GT(1,0)
  set_button_relief ( GTK_RELIEF_NONE );
#endif
  append_item ( "Horizontal", 
		"Horizontal toolbar layout", 
		"Toolbar/Horizontal",
		*pixHorizontal, this,
		&ToolBarTestWidget::horizontal, static_cast < void * > ( 0 ) );
  append_item ( "Vertical",                       // text
		"Vertical toolbar layout",        // tooltip_text
		"Toolbar/Vertical",               // tooltip_private_text
		*pixVertical,                     // icon
		this,                             // receiver
		&ToolBarTestWidget::vertical,     // receiver method,
		static_cast < void * > ( 0 ) );   // user data
  append_space ();
  append_item ( "Icons", "Only show toolbar icons", "Toolbar/IconsOnly",
		*pixIcons, this,
		&ToolBarTestWidget::icons, static_cast < void * > ( 0 ) );
  append_item ( "Text", "Only show toolbar text", "Toolbar/TextOnly",
		*pixText, this,
		&ToolBarTestWidget::text, static_cast < void * > ( 0 ) );
  append_item ( "Both", "Show toolbar icons and text", "Toolbar/Both",
		*pixBoth, this,
		&ToolBarTestWidget::both, static_cast < void * > ( 0 ) );
  append_space ();
  append_widget ( entry, "This is an unusable GtkEntry ;)",
		  "Hey don't click me!!!" );
  append_space ();
  append_item ( "Small", "Use small spaces", "Toolbar/Small",
		*pixSmall, this, &ToolBarTestWidget::smallSpace, static_cast < void * > ( 0 ) );
  append_item ( "Big", "Use big spaces", "Toolbar/Big",
		*pixBig, this, &ToolBarTestWidget::bigSpace, static_cast < void * > ( 0 ) );
  append_space ();
  append_item ( "Enable", "Enable tooltips", NULL,
		*pixEnable, this, &ToolBarTestWidget::enable, static_cast < void * > ( 0 ) );
  append_item ( "Disable", "Disable tooltips", NULL,
		*pixDisable, this, &ToolBarTestWidget::disable, static_cast < void * > ( 0 ) );
  append_space ();
  append_item ( "Borders", "Show Borders", NULL,
		*pixBorders, this, &ToolBarTestWidget::borders, static_cast < void * > ( 0 ) );
  append_item ( "Borderless", "Hide Borders", NULL,
		*pixBorderless, this, &ToolBarTestWidget::borderless, static_cast < void * > ( 0 ) );
}

ToolBarTestWidget::~ToolBarTestWidget ()
{
  delete pixHorizontal;
  delete pixVertical;
  delete pixIcons;
  delete pixText;
  delete pixBoth;
  delete pixSmall;
  delete pixBig;
  delete pixEnable;
  delete pixDisable;
  delete pixBorders;
  delete pixBorderless;
}

void
ToolBarTestWidget::horizontal ( gpointer   data )
{
  set_orientation ( GTK_ORIENTATION_HORIZONTAL );
}

void
ToolBarTestWidget::vertical ( gpointer   data )
{
  set_orientation ( GTK_ORIENTATION_VERTICAL );
}

void
ToolBarTestWidget::icons ( gpointer   data)
{
  set_style( GTK_TOOLBAR_ICONS);
}

void
ToolBarTestWidget::text ( gpointer   data )
{
  set_style ( GTK_TOOLBAR_TEXT );
}

void
ToolBarTestWidget::both ( gpointer   data )
{
  set_style ( GTK_TOOLBAR_BOTH );
}

void
ToolBarTestWidget::smallSpace ( gpointer   data )
{
  set_space_size ( 5 );
}

void
ToolBarTestWidget::bigSpace ( gpointer   data )
{
  set_space_size ( 10 );
}

void
ToolBarTestWidget::enable ( gpointer   data )
{
  set_tooltips ( true );
}

void
ToolBarTestWidget::disable ( gpointer   data )
{
  set_tooltips ( false );
}

void
ToolBarTestWidget::borders ( gpointer   data )
{
#if GTK_VERSION_GT(1,0)
  set_button_relief ( GTK_RELIEF_NORMAL );
#endif
}

void
ToolBarTestWidget::borderless ( gpointer   data )
{
#if GTK_VERSION_GT(1,0)
  set_button_relief ( GTK_RELIEF_NONE );
#endif
}


ToolBarTest * ToolBarTest::theTest = 0;

TestFixture * 
ToolBarTest::create () 
{
  if ( theTest == 0 ) 
    {
      theTest = new ToolBarTest ();
      return theTest;
    }
  return 0;
}

ToolBarTest::ToolBarTest () :
  TestFixture ()
{
  set_title ( "Toolbar test" );
  realize ();
  actionArea . pack_start ( toolbar );
  packControlArea ();
  show_all ();
}

ToolBarTest::~ToolBarTest () 
{
}


