------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                       G N A T . T R A C E B A C K                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $
--                                                                          --
--              Copyright (C) 1999 Ada Core Technologies, Inc.              --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT is maintained by Ada Core Technologies Inc (http://www.gnat.com).   --
--                                                                          --
------------------------------------------------------------------------------

--  Run-time non-symbolic traceback support

with System.Storage_Elements;

package body GNAT.Traceback is

   use System;
   use System.Storage_Elements;

   function Machine_State_Length return Storage_Offset;
   pragma Import (C, Machine_State_Length, "__gnat_machine_state_length");

   type Machine_State is new Storage_Array (1 .. Machine_State_Length);
   for Machine_State'Alignment use Standard'Maximum_Alignment;

   type Machine_State_Ptr is access all Machine_State;

   procedure Set_Machine_State (M : Machine_State_Ptr);
   pragma Import (C, Set_Machine_State, "__gnat_set_machine_state");

   procedure Pop_Frame (M    : Machine_State_Ptr);
   pragma Import (C, Pop_Frame, "__gnat_pop_frame");

   function Get_Code_Loc (M : Machine_State_Ptr) return Code_Loc;
   pragma Import (C, Get_Code_Loc, "__gnat_get_code_loc");

   ----------------
   -- Call_Chain --
   ----------------

   procedure Call_Chain
     (Traceback : out Tracebacks_Array;
      Len : out Integer)
   is
      M    : aliased Machine_State;
      Code : Code_Loc;
      J    : Natural := Traceback'First;

   begin
      Set_Machine_State (M'Unchecked_Access);
      Pop_Frame (M'Unchecked_Access);

      loop
         Code := Get_Code_Loc (M'Unchecked_Access);

         exit when Code = Null_Address or else J = Traceback'Last + 1;

         Traceback (J) := Code;
         J := J + 1;
         Pop_Frame (M'Unchecked_Access);
      end loop;

      Len := J - Traceback'First;
   end Call_Chain;

end GNAT.Traceback;
