------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                                A T R E E                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.143 $                            --
--                                                                          --
--          Copyright (C) 1992-1998, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with Alloc;
with Sinfo;  use Sinfo;
with Einfo;  use Einfo;
with Types;  use Types;
with Snames; use Snames;
with System; use System;
with Table;
with Uintp;  use Uintp;
with Urealp; use Urealp;
with Unchecked_Conversion;

package Atree is

--  This package defines the format of the tree used to represent the Ada
--  program internally. Syntactic and semantic information is combined in
--  this tree. There is no separate symbol table structure.

--  WARNING: There is a C version of this package. Any changes to this
--  source file must be properly reflected in the C header file tree.h

--  Package Atree defines the basic structure of the tree and its nodes and
--  provides the basic abstract interface for manipulating the tree. Two
--  other packages use this interface to define the representation of Ada
--  programs using this tree format. The package Sinfo defines the basic
--  representation of the syntactic structure of the program, as output
--  by the parser. The package Entity_Info defines the semantic information
--  which is added to the tree nodes that represent declared entities (i.e.
--  the information which might typically be described in a separate symbol
--  table structure.

--  The front end of the compiler first parses the program and generates a
--  tree that is simply a syntactic representation of the program in abstract
--  syntax tree format. Subsequent processing in the front end traverses the
--  tree, transforming it in various ways and adding semantic information.

   ----------------------------------------
   -- Definitions of Fields in Tree Node --
   ----------------------------------------

   --  The representation of the tree is completely hidden, using a functional
   --  interface for accessing and modifying the contents of nodes. Logically
   --  a node contains a number of fields, much as though the nodes were
   --  defined as a record type. The fields in a node are as follows:

   --   Nkind            Indicates the kind of the node. This field is present
   --                    in all nodes. The type is Node_Kind, which is declared
   --                    in the package Sinfo.

   --   Sloc             Location (Source_Ptr) of the corresponding token
   --                    in the Source buffer. The individual node definitions
   --                    show which token is referenced by this pointer.

   --   In_List          A flag used to indicate if the node is a member
   --                    of a node list.

   --   Rewrite_Sub      A flag set if the node has been rewritten using
   --                    the Rewrite procedure. The original value of the
   --                    node is retrievable with Original_Node.

   --   Rewrite_Ins      A flag set if a node is marked as a rewrite inserted
   --                    node as a result of a call to Mark_Rewrite_Insertion.

   --   Paren_Count      A 2-bit count used on expression nodes to indicate
   --                    the level of parentheses. Up to 3 levels can be
   --                    accomodated. Anything more than 3 levels is treated
   --                    as 3 levels (conformance tests that complain about
   --                    this are hereby deemed pathological!) Set to zero
   --                    for non-subexpression nodes.

   --   Comes_From_Source
   --                    This flag is present in all nodes. It is set if the
   --                    node is built by the scanner or parser, and clear if
   --                    the node is built by the analyzer or expander. It
   --                    indicates that the node corresponds to a construct
   --                    that appears in the original source program.

   --   Analyzed         This flag is present in all nodes. It is set when
   --                    a node is analyzed, and is used to avoid analyzing
   --                    the same node twice. Analysis includes expansion if
   --                    expansion is active, so in this case if the flag is
   --                    set it means the node has been analyzed and expanded.

   --   Error_Posted     This flag is present in all nodes. It is set when
   --                    an error message is posted which is associated with
   --                    the flagged node. This is used to avoid posting more
   --                    than one message on the same node.

   --   Field1
   --   Field2
   --   Field3
   --   Field4
   --   Field5           Five fields holding Union_Id values

   --   Char_CodeN       Synonym for FieldN typed as Char_Code
   --   ElistN           Synonym for FieldN typed as Elist_Id
   --   ListN            Synonym for FieldN typed as List_Id
   --   NameN            Synonym for FieldN typed as Name_Id
   --   NodeN            Synonym for FieldN typed as Node_Id
   --   StrN             Synonym for FieldN typed as String_Id
   --   UintN            Synonym for FieldN typed as Uint
   --   UrealN           Synonym for FieldN typed as Ureal

   --   Note: the actual usage of FieldN (i.e. whether it contains a Char_Code,
   --   Elist_Id, List_Id, Name_Id, Node_Id, String_Id, Uint or Ureal), depends
   --   on the value in Nkind. Generally the access to this field is always via
   --   the functional interface, so the field names Char_CodeN, ElistN, ListN,
   --   NameN, NodeN, StrN, UintN and UrealN are used only in the bodies of the
   --   access functions (i.e. in the bodies of Sinfo and Einfo). These access
   --   functions contain debugging code that checks that the use is consistent
   --   with Nkind and Ekind values.

   --   However, in specialized circumstances (examples are the circuit in
   --   generic instantiation to copy trees, and in the tree dump routine),
   --   it is useful to be able to do untyped traversals, and an internal
   --   package in Atree allows for direct untyped accesses in such cases.

   --   Flag4            Fifteen Boolean flags (use depends on Nkind and
   --   Flag5            Ekind, as described for Fieldn). Again the access
   --   Flag6            is usually via subprograms in Sinfo and Einfo which
   --   Flag7            provide high-level synonyms for these flags, and
   --   Flag8            contain debugging code that checks that the values
   --   Flag9            in Nkind and Ekind are appropriate for the access.
   --   Flag10
   --   Flag11           Note that Flag1-3 are missing from this list. The
   --   Flag12           first three flag positions are reserved for the
   --   Flag13           standard flags (Comes_From_Source, Error_Posted,
   --   Flag14           and Analyzed)
   --   Flag15
   --   Flag16
   --   Flag17
   --   Flag18

   --   Link             For a node, points to the Parent. For a list, points
   --                    to the list header. Note that in the latter case, a
   --                    client cannot modify the link field. This field is
   --                    private to the Atree package (but is also modified
   --                    by the Nlists package).

   --  The following additional fields are present in extended nodes used
   --  for entities (Nkind in N_Entity).

   --   Ekind            Entity type. This field indicates the type of the
   --                    entity, it is of type Entity_Kind which is defined
   --                    in package Einfo.

   --   Flag19           133 additional flags
   --   ...
   --   Flag151

   --   Convention       Entity convention (Convention_Id value)

   --   Field6           Additional Union_Id value stored in tree

   --   Node6            Synonym for Field6 typed as Node_Id
   --   Elist6           Synonym for Field6 typed as Elist_Id
   --   Uint6            Synonym for Field6 typed as Uint

   --   Similar definitions for Field7 to Field23 (and Node7-Node23,
   --   Elist7-Elist23, Uint7-Uint23, Ureal7-Ureal23). Note that not all
   --   these functions are defined, only the ones that are actually used.

   type Paren_Count_Type is mod 4;
   for Paren_Count_Type'Size use 2;
   --  Type used for Paren_Count field

   function Last_Node_Id return Node_Id;
   pragma Inline (Last_Node_Id);
   --  Returns Id of last allocated node Id

   function Nodes_Address return System.Address;
   --  Return address of Nodes table (used in Back_End for Gigi call)

   function Num_Nodes return Nat;
   --  Total number of nodes allocated, where an entity counts as a single
   --  node. This count is incremented every time a node or entity is
   --  allocated, and decremented every time a node or entity is deleted.
   --  This value is used by Xref and by Treepr to allocate hash tables of
   --  suitable size for hashing Node_Id values.

   -----------------------
   -- Use of Empty Node --
   -----------------------

   --  The special Node_Id Empty is used to mark missing fields. Whenever the
   --  syntax has an optional component, then the corresponding field will be
   --  set to Empty if the component is missing.

   --  Note: Empty is not used to describe an empty list. Instead in this
   --  case the node field contains a list which is empty, and these cases
   --  should be distinguished (essentially from a type point of view, Empty
   --  is a Node, and is thus not a list).

   --  Note: Empty does in fact correspond to an allocated node. Only the
   --  Nkind field of this node may be referenced. It contains N_Empty, which
   --  uniquely identifies the empty case. This allows the Nkind field to be
   --  dereferenced before the check for Empty which is sometimes useful.

   -----------------------
   -- Use of Error Node --
   -----------------------

   --  The Error node is used during syntactic and semantic analysis to
   --  indicate that the corresponding piece of syntactic structure or
   --  semantic meaning cannot properly be represented in the tree because
   --  of an illegality in the program.

   --  If an Error node is encountered, then you know that a previous
   --  illegality has been detected. The proper reaction should be to
   --  avoid posting related cascaded error messages, and to propagate
   --  the error node if necessary.

   -----------------------
   -- Current_Error_Node --
   -----------------------

   --  The current error node is a global location indicating the current
   --  node that is being processed for the purposes of placing a compiler
   --  abort message. This is not necessarily perfectly accurate, it is
   --  just a reasonably accurate best guess. It is used to output the
   --  source location in the abort message by Comperr, and also to
   --  implement the d3 debugging flag. This is also used by Rtsfind
   --  to generate error messages for No_Run_Time mode.

   Current_Error_Node : Node_Id;
   --  Node to place error messages

   -------------------------------
   -- Default Setting of Fields --
   -------------------------------

   --  Nkind is set to N_Unused_At_Start

   --  Ekind is set to E_Void

   --  Sloc is always set, there is no default value

   --  Field1-5 fields are set to Empty

   --  Field6-22 fields in extended nodes are set to Empty

   --  Parent is set to Empty

   --  All Boolean flag fields are set to False

   --  Note: the value Empty is used in Field1-Field17 to indicate a null node.
   --  The usage varies. The common uses are to indicate absence of an
   --  optional clause or a completely unused Field1-17 field.

   -------------------------------------
   -- Use of Synonyms for Node Fields --
   -------------------------------------

   --  A subpackage Atree.Unchecked_Access provides routines for reading and
   --  writing the fields defined above (Field1-17, Node1-17, Flag1-88 etc).
   --  These unchecked access routines can be used for untyped traversals. In
   --  In addition they are used in the implementations of the Sinfo and
   --  Einfo packages. These packages both provide logical synonyms for
   --  the generic fields, together with an appropriate set of access routines.
   --  Normally access to information within tree nodes uses these synonyms,
   --  providing a high level typed interface to the tree information.

   --------------------------------------------------
   -- Node Allocation and Modification Subprograms --
   --------------------------------------------------

   --  Generally the parser builds the tree and then it is further decorated
   --  (e.g. by setting the entity fields), but not fundamentally modified.
   --  However, there are cases in which the tree must be restructured by
   --  adding and rearranging nodes, as a result of disambiguating cases
   --  which the parser could not parse correctly, and adding additional
   --  semantic information (e.g. making constraint checks explicit). The
   --  following subprograms are used for constructing the tree in the first
   --  place, and then for subsequent modifications as required

   procedure Initialize;
   --  Called at the start of compilation to initialize the allocation of
   --  the node and list tables and make the standard entries for Empty,
   --  Error and Error_List. Note that Initialize must not be called if
   --  Tree_Read is used.

   procedure Lock;
   --  Called before the backend is invoked to lock the nodes table

   procedure Tree_Read;
   --  Initializes internal tables from current tree file using Tree_Read.
   --  Note that Initialize should not be called if Tree_Read is used.
   --  Tree_Read includes all necessary initialization.

   procedure Tree_Write;
   --  Writes out internal tables to current tree file using Tree_Write

   function New_Node
     (New_Node_Kind : Node_Kind;
      New_Sloc      : Source_Ptr)
      return          Node_Id;
   --  Allocates a completely new node with the given node type and source
   --  location values. All other fields are set to their standard defaults:
   --
   --    Empty for all Fieldn fields
   --    False for all Flagn fields
   --
   --  The usual approach is to build a new node using this function and
   --  then, using the value returned, use the Set_xxx functions to set
   --  fields of the node as required. New_Node can only be used for
   --  non-entity nodes, i.e. it never generates an extended node.

   function New_Entity
     (New_Node_Kind : Node_Kind;
      New_Sloc      : Source_Ptr)
      return          Entity_Id;
   --  Similar to New_Node, except that it is used only for entity nodes
   --  and returns an extended node.

   procedure Set_Comes_From_Source_Default (Default : Boolean);
   --  Sets value of Comes_From_Source flag to be used in all subsequent
   --  New_Node and New_Entity calls until another call to this procedure
   --  changes the default.

   procedure Preserve_Comes_From_Source (NewN, OldN : Node_Id);
   pragma Inline (Preserve_Comes_From_Source);
   --  When a node is rewritten, it is sometimes appropriate to preserve the
   --  original comes from source indication. This is true when the rewrite
   --  essentially corresponds to a transformation corresponding exactly to
   --  semantics in the reference manual. This procedure copies the setting
   --  of Comes_From_Source from OldN to NewN.

   function Has_Extension (N : Node_Id) return Boolean;
   pragma Inline (Has_Extension);
   --  Returns True if the given node has an extension (i.e. was created by
   --  a call to New_Entity rather than New_Node, and Nkind is in N_Entity)

   procedure Change_Node (N : Node_Id; New_Node_Kind : Node_Kind);
   --  This procedure replaces the given node by setting its Nkind field to
   --  the indicated value and resetting all other fields to their default
   --  values except for Sloc, which is unchanged, and the Parent pointer
   --  and list links, which are also unchanged. All other information in
   --  the original node is lost. The new node has an extension if the
   --  original node had an extension.

   procedure Copy_Node (Source : Node_Id; Destination : Node_Id);
   --  Copy the entire contents of the source node to the destination node.
   --  The contents of the source node is not affected. If the source node
   --  has an extension, then the destination must have an extension also.
   --  The parent pointer of the destination and its list link, if any, are
   --  not affected by the copy. Note that parent pointers of descendents
   --  are not adjusted, so the descendents of the destination node after
   --  the Copy_Node is completed have dubious parent pointers.

   function New_Copy (Source : Node_Id) return Node_Id;
   --  This function allocates a completely new node, and then initializes
   --  it by copying the contents of the source node into it. The contents
   --  of the source node is not affected. The target node is always marked
   --  as not being in a list (even if the source is a list member). The
   --  new node will have an extension if the source has an extension.
   --  New_Copy (Empty) returns Empty and New_Copy (Error) returns Error.
   --  Note that, unlike New_Copy_Tree, New_Copy does not recursively copy any
   --  descendents, so in general parent pointers are not set correctly for
   --  the descendents of the copied node. Both normal and extended nodes
   --  (entities) may be copied using New_Copy.

   function Relocate_Node (Source : Node_Id) return Node_Id;
   --  Source is a non-entity node that is to be relocated. A new node is
   --  allocated and the contents of Source are copied to this node using
   --  Copy_Node. The parent pointers of descendents of the node are then
   --  adjusted to point to the relocated copy. The original node is not
   --  modified, but the parent pointers of its descendents are no longer
   --  valid. This routine is used in conjunction with the tree rewrite
   --  routines (see descriptions of Replace/Rewrite).
   --
   --  Note that the resulting node has the same parent as the source
   --  node, and is thus still attached to the tree. It is valid for
   --  Source to be Empty, in which case Relocate_Node simply returns
   --  Empty as the result.

   function New_Copy_Tree
     (Source    : Node_Id;
      Map       : Elist_Id := No_Elist;
      New_Sloc  : Source_Ptr := No_Location;
      New_Scope : Entity_Id := Empty)
      return      Node_Id;
   --  Given a node that is the root of a subtree, Copy_Tree copies the entire
   --  syntactic subtree, including recursively any descendents whose parent
   --  field references a copied node (descendents not linked to a copied node
   --  by the parent field are not copied, instead the copied tree references
   --  the same descendent as the original in this case, which is appropriate
   --  for non-syntactic fields such as Etype). The parent pointers in the
   --  copy are properly set. Copy_Tree (Empty/Error) returns Empty/Error.
   --  The one exception to the rule of not copying semantic fields is that
   --  any implicit types attached to the subtree are duplicated, so that
   --  the copy contains a distinct set of implicit type entities. The Map
   --  argument, if set to a non-empty Elist, specifies a set of mappings
   --  to be applied to entities in the tree. The map has the form:
   --
   --     old entity 1
   --     new entity to replace references to entity 1
   --     old entity 2
   --     new entity to replace references to entity 2
   --     ...
   --
   --  The call destroys the contents of Map in this case
   --
   --  The parameter New_Sloc, if set to a value other than No_Location, is
   --  used as the Sloc value for all nodes in the new copy. If New_Sloc is
   --  set to its default value No_Location, then the Sloc values of the
   --  nodes in the copy are simply copied from the corresponding original.
   --
   --  The Comes_From_Source indication is unchanged if New_Sloc is set to
   --  the default No_Location value, but is reset if New_Sloc is given, since
   --  in this case the result clearly is neither a source node or an exact
   --  copy of a source node.
   --
   --  The parameter New_Scope, if set to a value other than Empty, is the
   --  value to use as the Scope for any Itypes that are copied. The most
   --  typical value for this parameter, if given, is Current_Scope.

   function Copy_Separate_Tree (Source : Node_Id) return Node_Id;
   --  Given a node that is the root of a subtree, Copy_Separate_Tree copies
   --  the entire syntactic subtree, including recursively any descendants
   --  whose parent field references a copied node (descendants not linked to
   --  a copied node by the parent field are also copied.) The parent pointers
   --  in the copy are properly set. Copy_Separate_Tree (Empty/Error) returns
   --  Empty/Error. The semantic fields are not copied and the new subtree
   --  does not share any entity with source subtree.
   --  But the code *does* copy semantic fields, and the description above
   --  is in any case unclear on this point ??? (RBKD)

   procedure Exchange_Entities (E1 : Entity_Id; E2 : Entity_Id);
   --  Exchange the contents of two entities. The parent pointers are switched
   --  as well as the Defining_Identifier fields in the parents, so that the
   --  entities point correctly to their original parents. The effect is thus
   --  to leave the tree completely unchanged in structure, except that the
   --  entity ID values of the two entities are interchanged. Neither of the
   --  two entities may be list members.

   procedure Delete_Node (Node : Node_Id);
   --  The node, which must not be a list member, is deleted from the tree and
   --  its type is set to N_Unused_At_End. It is an error (not necessarily
   --  detected) to reference this node after it has been deleted. The
   --  implementation of the body of Atree is free to reuse the node to
   --  satisfy future node allocation requests, but is not required to do so.

   procedure Delete_Tree (Node : Node_Id);
   --  The entire syntactic subtree referenced by Node (i.e. the given node
   --  and all its syntactic descendents) are deleted as described above for
   --  Delete_Node.

   function Extend_Node (Node : Node_Id) return Entity_Id;
   --  This function returns a copy of its input node with an extension
   --  added. The fields of the extension are set to Empty. Due to the way
   --  extensions are handled (as two consecutive array elements), it may
   --  be necessary to reallocate the node, so that the returned value is
   --  not the same as the input value, but where possible the returned
   --  value will be the same as the input value (i.e. the extension will
   --  occur in place). It is the caller's responsibility to ensure that
   --  any pointers to the original node are appropriately updated. This
   --  function is used only by Sinfo.CN to change nodes into their
   --  corresponding entities.

   type Traverse_Result is (OK, Skip, Abandon);
   --  This is the type of the result returned by the Process function passed
   --  to Traverse_Func and Traverse_Proc and also the type of the result of
   --  Traverse_Func itself. See descriptions below for details.

   generic
     with function Process (N : Node_Id) return Traverse_Result is <>;
   function Traverse_Func (Node : Node_Id) return Traverse_Result;
   --  This is a generic function that, given the parent node for a subtree,
   --  traverses all syntactic nodes of this tree, calling the given function
   --  Process on each one. The traversal is controlled as follows by the
   --  result returned by Process:

   --    OK       The traversal continues normally with the children of
   --             the node just processed.

   --    Skip     The children of the node just processed are skipped and
   --             excluded from the traversal, but otherwise processing
   --             continues elsewhere in the tree.

   --    Abandon  The entire traversal is immediately abandoned, and the
   --             original call to Traverse returns Abandon.

   --  The result returned by Traverse is Abandon if processing was terminated
   --  by a call to Process returning Abandon, otherwise it is OK (meaning that
   --  all calls to process returned either OK or Skip).

   generic
     with function Process (N : Node_Id) return Traverse_Result is <>;
   procedure Traverse_Proc (Node : Node_Id);
   pragma Inline (Traverse_Proc);
   --  This is similar to Traverse_Func except that no result is returned,
   --  i.e. Traverse_Func is called and the result is simply discarded.

   ---------------------------
   -- Node Access Functions --
   ---------------------------

   --  The following functions return the contents of the indicated field of
   --  the node referenced by the argument, which is a Node_Id.

   function Nkind             (N : Node_Id) return Node_Kind;
   pragma Inline (Nkind);

   function Analyzed          (N : Node_Id) return Boolean;
   pragma Inline (Analyzed);

   function Comes_From_Source (N : Node_Id) return Boolean;
   pragma Inline (Comes_From_Source);

   function Error_Posted      (N : Node_Id) return Boolean;
   pragma Inline (Error_Posted);

   function Sloc              (N : Node_Id) return Source_Ptr;
   pragma Inline (Sloc);

   function Paren_Count       (N : Node_Id) return Paren_Count_Type;
   pragma Inline (Paren_Count);

   function Parent            (N : Node_Id) return Node_Id;
   pragma Inline (Parent);
   --  Returns the parent of a node if the node is not a list member, or
   --  else the parent of the list containing the node if the node is a
   --  list member.

   function No                (N : Node_Id) return Boolean;
   pragma Inline (No);
   --  Tests given Id for equality with the Empty node. This allows notations
   --  like "if No (Variant_Part)" as opposed to "if Variant_Part = Empty".

   function Present           (N : Node_Id) return Boolean;
   pragma Inline (Present);
   --  Tests given Id for inequality with the Empty node. This allows notations
   --  like "if Present (Statement)" as opposed to "if Statement /= Empty".

   -----------------------------
   -- Entity Access Functions --
   -----------------------------

   --  The following functions apply only to Entity_Id values, i.e.
   --  to extended nodes.

   function Ekind (E : Entity_Id) return Entity_Kind;
   pragma Inline (Ekind);

   function Convention (E : Entity_Id) return Convention_Id;
   pragma Inline (Convention);

   ----------------------------
   -- Node Update Procedures --
   ----------------------------

   --  The following functions set a specified field in the node whose Id is
   --  passed as the first argument. The second parameter is the new value
   --  to be set in the specified field. Note that Set_Nkind is in the next
   --  section, since its use is restricted.

   procedure Set_Sloc         (N : Node_Id; Val : Source_Ptr);
   pragma Inline (Set_Sloc);

   procedure Set_Paren_Count  (N : Node_Id; Val : Paren_Count_Type);
   pragma Inline (Set_Paren_Count);

   procedure Set_Parent       (N : Node_Id; Val : Node_Id);
   pragma Inline (Set_Parent);

   procedure Set_Analyzed     (N : Node_Id; Val : Boolean := True);
   pragma Inline (Set_Analyzed);

   procedure Set_Error_Posted (N : Node_Id; Val : Boolean := True);
   pragma Inline (Set_Error_Posted);

   procedure Set_Comes_From_Source (N : Node_Id; Val : Boolean);
   pragma Inline (Set_Comes_From_Source);
   --  Note that this routine is very rarely used, since usually the
   --  default mechanism provided sets the right value, but in some
   --  unusual cases, the value needs to be reset (e.g. when a source
   --  node is copied, and the copy must not have Comes_From_Source set.

   ------------------------------
   -- Entity Update Procedures --
   ------------------------------

   --  The following procedures apply only to Entity_Id values, i.e.
   --  to extended nodes.

   procedure Set_Ekind (E : Entity_Id; Val : Entity_Kind);
   pragma Inline (Set_Ekind);

   procedure Set_Convention (E : Entity_Id; Val : Convention_Id);
   pragma Inline (Set_Convention);

   ---------------------------
   -- Tree Rewrite Routines --
   ---------------------------

   --  During the compilation process it is necessary in a number of situations
   --  to rewrite the tree. In some cases, such rewrites do not affect the
   --  structure of the tree, for example, when an indexed component node is
   --  replaced by the corresponding call node (the parser cannot distinguish
   --  between these two cases).

   --  In other situations, the rewrite does affect the structure of the
   --  tree. Examples are the replacement of a generic instantiation by the
   --  instantiated spec and body, and the static evaluation of expressions.

   --  If such structural modifications are done by the expander, there are
   --  no difficulties, since the form of the tree after the expander has no
   --  special significance, except as input to the backend of the compiler.
   --  However, if these modifications are done by the semantic phase, then
   --  it is important that they be done in a manner which allows the original
   --  tree to be preserved. This is because tools like pretty printers need
   --  to have this original tree structure available.

   --  The subprograms in this section allow rewriting of the tree by either
   --  insertion of new nodes in an existing list, or complete replacement of
   --  a subtree. The resulting tree for most purposes looks as though it has
   --  been really changed, and there is no trace of the original. However,
   --  special subprograms, also defined in this section, allow the original
   --  tree to be reconstructed if necessary.

   --  For tree modifications done in the expander, it is permissible to
   --  destroy the original tree, although it is also allowable to use the
   --  tree rewrite routines where it is convenient to do so.

   procedure Mark_Rewrite_Insertion (New_Node : Node_Id);
   pragma Inline (Mark_Rewrite_Insertion);
   --  This procedure marks the given node as an insertion made during a tree
   --  rewriting operation. Only the root needs to be marked. The call does
   --  not do the actual insertion, which must be done using one of the normal
   --  list insertion routines. The node is treated normally in all respects
   --  except for its response to Is_Rewrite_Insertion. The function of these
   --  calls is to be able to get an accurate original tree. This helps the
   --  accuracy of Sprint.Sprint_Node, and in particular, when stubs are being
   --  generated, it is essential that the original tree be accurate.

   function Is_Rewrite_Insertion (Node : Node_Id) return Boolean;
   pragma Inline (Is_Rewrite_Insertion);
   --  Tests whether the given node was marked using Set_Rewrite_Insert. This
   --  is used in reconstructing the original tree (where such nodes are to
   --  be eliminated from the reconstructed tree).

   procedure Rewrite (Old_Node, New_Node : Node_Id);
   --  This is used when a complete subtree is to be replaced. Old_Node is the
   --  root of the old subtree to be replaced, and New_Node is the root of the
   --  newly constructed replacement subtree. The actual mechanism is to swap
   --  the contents of these two nodes fixing up the parent pointers of the
   --  replaced node (we do not attempt to preserve parent pointers for the
   --  original node). Neither Old_Node nor New_Node can be extended nodes.
   --
   --  Note: New_Node may not contain references to Old_Node, for example as
   --  descendents, since the rewrite would make such references invalid. If
   --  New_Node does need to reference Old_Node, then these references should
   --  be to a relocated copy of Old_Node (see Relocate_Node procedure).
   --
   --  Note: The Original_Node function applied to Old_Node (which has now
   --  been replaced by the contents of New_Node), can be used to obtain the
   --  original node, i.e. the old contents of Old_Node.

   procedure Replace (Old_Node, New_Node : Node_Id);
   --  This is similar to Rewrite, except that the old value of Old_Node is
   --  not saved, and the New_Node is deleted after the replace, since it
   --  is assumed that it can no longer be legitimately needed. The flag
   --  Is_Rewrite_Susbtitute will be False for the resulting node, unless
   --  it was already true on entry, and Original_Node will not return the
   --  original contents of the Old_Node, but rather the New_Node value (unless
   --  Old_Node had already been rewritten using Rewrite). Replace also
   --  preserves the setting of Comes_From_Source.
   --
   --  Note, New_Node may not contain references to Old_Node, for example as
   --  descendents, since the rewrite would make such references invalid. If
   --  New_Node does need to reference Old_Node, then these references should
   --  be to a relocated copy of Old_Node (see Relocate_Node procedure).
   --
   --  Replace is used in certain circumstances where it is desirable to
   --  suppress any history of the rewriting operation. Notably, it is used
   --  when the parser has mis-classified a node (e.g. a task entry call
   --  that the parser has parsed as a procedure call).

   function Is_Rewrite_Substitution (Node : Node_Id) return Boolean;
   pragma Inline (Is_Rewrite_Substitution);
   --  Return True iff Node has been rewritten (i.e. if Node is the root
   --  of a subtree which was installed using Rewrite).

   function Original_Node (Node : Node_Id) return Node_Id;
   pragma Inline (Original_Node);
   --  If Node has not been rewritten, then returns its input argument
   --  unchanged, else returns the Node for the original subtree.
   --
   --  Note: Parents are not preserved in original tree nodes that are
   --  retrieved in this way (i.e. their children may have children whose
   --  pointers which reference some other node).

   --  Note: there is no direct mechanism for deleting an original node (in
   --  a manner that can be reversed later). One possible approach is to use
   --  Rewrite to substitute a null statement for the node to be deleted.

   -----------------------------------
   -- Generic Field Access Routines --
   -----------------------------------

   --  This subpackage provides the functions for accessing and procedures
   --  for setting fields that are normally referenced by their logical
   --  synonyms defined in packages Sinfo and Einfo. As previously
   --  described the implementations of these packages use the package
   --  Atree.Unchecked_Access.

   package Unchecked_Access is

      --  Functions to allow interpretation of Union_Id values as Uint
      --  and Ureal values

      function To_Union is new Unchecked_Conversion (Uint,  Union_Id);
      function To_Union is new Unchecked_Conversion (Ureal, Union_Id);

      function From_Union is new Unchecked_Conversion (Union_Id, Uint);
      function From_Union is new Unchecked_Conversion (Union_Id, Ureal);

      --  Functions to fetch contents of indicated field. It is an error
      --  to attempt to read the value of a field which is not present.

      function Field1 (N : Node_Id) return Union_Id;
      pragma Inline (Field1);

      function Field2 (N : Node_Id) return Union_Id;
      pragma Inline (Field2);

      function Field3 (N : Node_Id) return Union_Id;
      pragma Inline (Field3);

      function Field4 (N : Node_Id) return Union_Id;
      pragma Inline (Field4);

      function Field5 (N : Node_Id) return Union_Id;
      pragma Inline (Field5);

      function Field6 (N : Node_Id) return Union_Id;
      pragma Inline (Field6);

      function Field7 (N : Node_Id) return Union_Id;
      pragma Inline (Field7);

      function Field8 (N : Node_Id) return Union_Id;
      pragma Inline (Field8);

      function Field9 (N : Node_Id) return Union_Id;
      pragma Inline (Field9);

      function Field10 (N : Node_Id) return Union_Id;
      pragma Inline (Field10);

      function Field11 (N : Node_Id) return Union_Id;
      pragma Inline (Field11);

      function Field12 (N : Node_Id) return Union_Id;
      pragma Inline (Field12);

      function Field13 (N : Node_Id) return Union_Id;
      pragma Inline (Field13);

      function Field14 (N : Node_Id) return Union_Id;
      pragma Inline (Field14);

      function Field15 (N : Node_Id) return Union_Id;
      pragma Inline (Field15);

      function Field16 (N : Node_Id) return Union_Id;
      pragma Inline (Field16);

      function Field17 (N : Node_Id) return Union_Id;
      pragma Inline (Field17);

      function Field18 (N : Node_Id) return Union_Id;
      pragma Inline (Field18);

      function Field19 (N : Node_Id) return Union_Id;
      pragma Inline (Field19);

      function Field20 (N : Node_Id) return Union_Id;
      pragma Inline (Field20);

      function Field21 (N : Node_Id) return Union_Id;
      pragma Inline (Field21);

      function Field22 (N : Node_Id) return Union_Id;
      pragma Inline (Field22);

      function Field23 (N : Node_Id) return Union_Id;
      pragma Inline (Field23);

      function Node1 (N : Node_Id) return Node_Id;
      pragma Inline (Node1);

      function Node2 (N : Node_Id) return Node_Id;
      pragma Inline (Node2);

      function Node3 (N : Node_Id) return Node_Id;
      pragma Inline (Node3);

      function Node4 (N : Node_Id) return Node_Id;
      pragma Inline (Node4);

      function Node5 (N : Node_Id) return Node_Id;
      pragma Inline (Node5);

      function Node6 (N : Node_Id) return Node_Id;
      pragma Inline (Node6);

      function Node7 (N : Node_Id) return Node_Id;
      pragma Inline (Node7);

      function Node8 (N : Node_Id) return Node_Id;
      pragma Inline (Node8);

      function Node9 (N : Node_Id) return Node_Id;
      pragma Inline (Node9);

      function Node10 (N : Node_Id) return Node_Id;
      pragma Inline (Node10);

      function Node11 (N : Node_Id) return Node_Id;
      pragma Inline (Node11);

      function Node12 (N : Node_Id) return Node_Id;
      pragma Inline (Node12);

      function Node13 (N : Node_Id) return Node_Id;
      pragma Inline (Node13);

      function Node14 (N : Node_Id) return Node_Id;
      pragma Inline (Node14);

      function Node15 (N : Node_Id) return Node_Id;
      pragma Inline (Node15);

      function Node16 (N : Node_Id) return Node_Id;
      pragma Inline (Node16);

      function Node17 (N : Node_Id) return Node_Id;
      pragma Inline (Node17);

      function Node18 (N : Node_Id) return Node_Id;
      pragma Inline (Node18);

      function Node19 (N : Node_Id) return Node_Id;
      pragma Inline (Node19);

      function Node20 (N : Node_Id) return Node_Id;
      pragma Inline (Node20);

      function Node21 (N : Node_Id) return Node_Id;
      pragma Inline (Node21);

      function Node22 (N : Node_Id) return Node_Id;
      pragma Inline (Node22);

      function Node23 (N : Node_Id) return Node_Id;
      pragma Inline (Node23);

      function List1 (N : Node_Id) return List_Id;
      pragma Inline (List1);

      function List2 (N : Node_Id) return List_Id;
      pragma Inline (List2);

      function List3 (N : Node_Id) return List_Id;
      pragma Inline (List3);

      function List4 (N : Node_Id) return List_Id;
      pragma Inline (List4);

      function List5 (N : Node_Id) return List_Id;
      pragma Inline (List5);

      function List10 (N : Node_Id) return List_Id;
      pragma Inline (List10);

      function List23 (N : Node_Id) return List_Id;
      pragma Inline (List23);

      function Elist2 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist2);

      function Elist3 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist3);

      function Elist4 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist4);

      function Elist8 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist8);

      function Elist13 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist13);

      function Elist14 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist14);

      function Elist18 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist18);

      function Elist21 (N : Node_Id) return Elist_Id;
      pragma Inline (Elist21);

      function Name1 (N : Node_Id) return Name_Id;
      pragma Inline (Name1);

      function Name2 (N : Node_Id) return Name_Id;
      pragma Inline (Name2);

      function Char_Code2 (N : Node_Id) return Char_Code;
      pragma Inline (Char_Code2);

      function Str3 (N : Node_Id) return String_Id;
      pragma Inline (Str3);

      function Uint3 (N : Node_Id) return Uint;
      pragma Inline (Uint3);

      function Uint4 (N : Node_Id) return Uint;
      pragma Inline (Uint4);

      function Uint8 (N : Node_Id) return Uint;
      pragma Inline (Uint8);

      function Uint9 (N : Node_Id) return Uint;
      pragma Inline (Uint9);

      function Uint11 (N : Node_Id) return Uint;
      pragma Inline (Uint11);

      function Uint12 (N : Node_Id) return Uint;
      pragma Inline (Uint12);

      function Uint13 (N : Node_Id) return Uint;
      pragma Inline (Uint13);

      function Uint15 (N : Node_Id) return Uint;
      pragma Inline (Uint15);

      function Uint16 (N : Node_Id) return Uint;
      pragma Inline (Uint16);

      function Uint17 (N : Node_Id) return Uint;
      pragma Inline (Uint17);

      function Uint22 (N : Node_Id) return Uint;
      pragma Inline (Uint22);

      function Ureal3 (N : Node_Id) return Ureal;
      pragma Inline (Ureal3);

      function Ureal18 (N : Node_Id) return Ureal;
      pragma Inline (Ureal18);

      function Ureal21 (N : Node_Id) return Ureal;
      pragma Inline (Ureal21);

      function Flag4 (N : Node_Id) return Boolean;
      pragma Inline (Flag4);

      function Flag5 (N : Node_Id) return Boolean;
      pragma Inline (Flag5);

      function Flag6 (N : Node_Id) return Boolean;
      pragma Inline (Flag6);

      function Flag7 (N : Node_Id) return Boolean;
      pragma Inline (Flag7);

      function Flag8 (N : Node_Id) return Boolean;
      pragma Inline (Flag8);

      function Flag9 (N : Node_Id) return Boolean;
      pragma Inline (Flag9);

      function Flag10 (N : Node_Id) return Boolean;
      pragma Inline (Flag10);

      function Flag11 (N : Node_Id) return Boolean;
      pragma Inline (Flag11);

      function Flag12 (N : Node_Id) return Boolean;
      pragma Inline (Flag12);

      function Flag13 (N : Node_Id) return Boolean;
      pragma Inline (Flag13);

      function Flag14 (N : Node_Id) return Boolean;
      pragma Inline (Flag14);

      function Flag15 (N : Node_Id) return Boolean;
      pragma Inline (Flag15);

      function Flag16 (N : Node_Id) return Boolean;
      pragma Inline (Flag16);

      function Flag17 (N : Node_Id) return Boolean;
      pragma Inline (Flag17);

      function Flag18 (N : Node_Id) return Boolean;
      pragma Inline (Flag18);

      function Flag19 (N : Node_Id) return Boolean;
      pragma Inline (Flag19);

      function Flag20 (N : Node_Id) return Boolean;
      pragma Inline (Flag20);

      function Flag21 (N : Node_Id) return Boolean;
      pragma Inline (Flag21);

      function Flag22 (N : Node_Id) return Boolean;
      pragma Inline (Flag22);

      function Flag23 (N : Node_Id) return Boolean;
      pragma Inline (Flag23);

      function Flag24 (N : Node_Id) return Boolean;
      pragma Inline (Flag24);

      function Flag25 (N : Node_Id) return Boolean;
      pragma Inline (Flag25);

      function Flag26 (N : Node_Id) return Boolean;
      pragma Inline (Flag26);

      function Flag27 (N : Node_Id) return Boolean;
      pragma Inline (Flag27);

      function Flag28 (N : Node_Id) return Boolean;
      pragma Inline (Flag28);

      function Flag29 (N : Node_Id) return Boolean;
      pragma Inline (Flag29);

      function Flag30 (N : Node_Id) return Boolean;
      pragma Inline (Flag30);

      function Flag31 (N : Node_Id) return Boolean;
      pragma Inline (Flag31);

      function Flag32 (N : Node_Id) return Boolean;
      pragma Inline (Flag32);

      function Flag33 (N : Node_Id) return Boolean;
      pragma Inline (Flag33);

      function Flag34 (N : Node_Id) return Boolean;
      pragma Inline (Flag34);

      function Flag35 (N : Node_Id) return Boolean;
      pragma Inline (Flag35);

      function Flag36 (N : Node_Id) return Boolean;
      pragma Inline (Flag36);

      function Flag37 (N : Node_Id) return Boolean;
      pragma Inline (Flag37);

      function Flag38 (N : Node_Id) return Boolean;
      pragma Inline (Flag38);

      function Flag39 (N : Node_Id) return Boolean;
      pragma Inline (Flag39);

      function Flag40 (N : Node_Id) return Boolean;
      pragma Inline (Flag40);

      function Flag41 (N : Node_Id) return Boolean;
      pragma Inline (Flag41);

      function Flag42 (N : Node_Id) return Boolean;
      pragma Inline (Flag42);

      function Flag43 (N : Node_Id) return Boolean;
      pragma Inline (Flag43);

      function Flag44 (N : Node_Id) return Boolean;
      pragma Inline (Flag44);

      function Flag45 (N : Node_Id) return Boolean;
      pragma Inline (Flag45);

      function Flag46 (N : Node_Id) return Boolean;
      pragma Inline (Flag46);

      function Flag47 (N : Node_Id) return Boolean;
      pragma Inline (Flag47);

      function Flag48 (N : Node_Id) return Boolean;
      pragma Inline (Flag48);

      function Flag49 (N : Node_Id) return Boolean;
      pragma Inline (Flag49);

      function Flag50 (N : Node_Id) return Boolean;
      pragma Inline (Flag50);

      function Flag51 (N : Node_Id) return Boolean;
      pragma Inline (Flag51);

      function Flag52 (N : Node_Id) return Boolean;
      pragma Inline (Flag52);

      function Flag53 (N : Node_Id) return Boolean;
      pragma Inline (Flag53);

      function Flag54 (N : Node_Id) return Boolean;
      pragma Inline (Flag54);

      function Flag55 (N : Node_Id) return Boolean;
      pragma Inline (Flag55);

      function Flag56 (N : Node_Id) return Boolean;
      pragma Inline (Flag56);

      function Flag57 (N : Node_Id) return Boolean;
      pragma Inline (Flag57);

      function Flag58 (N : Node_Id) return Boolean;
      pragma Inline (Flag58);

      function Flag59 (N : Node_Id) return Boolean;
      pragma Inline (Flag59);

      function Flag60 (N : Node_Id) return Boolean;
      pragma Inline (Flag60);

      function Flag61 (N : Node_Id) return Boolean;
      pragma Inline (Flag61);

      function Flag62 (N : Node_Id) return Boolean;
      pragma Inline (Flag62);

      function Flag63 (N : Node_Id) return Boolean;
      pragma Inline (Flag63);

      function Flag64 (N : Node_Id) return Boolean;
      pragma Inline (Flag64);

      function Flag65 (N : Node_Id) return Boolean;
      pragma Inline (Flag65);

      function Flag66 (N : Node_Id) return Boolean;
      pragma Inline (Flag66);

      function Flag67 (N : Node_Id) return Boolean;
      pragma Inline (Flag67);

      function Flag68 (N : Node_Id) return Boolean;
      pragma Inline (Flag68);

      function Flag69 (N : Node_Id) return Boolean;
      pragma Inline (Flag69);

      function Flag70 (N : Node_Id) return Boolean;
      pragma Inline (Flag70);

      function Flag71 (N : Node_Id) return Boolean;
      pragma Inline (Flag71);

      function Flag72 (N : Node_Id) return Boolean;
      pragma Inline (Flag72);

      function Flag73 (N : Node_Id) return Boolean;
      pragma Inline (Flag73);

      function Flag74 (N : Node_Id) return Boolean;
      pragma Inline (Flag74);

      function Flag75 (N : Node_Id) return Boolean;
      pragma Inline (Flag75);

      function Flag76 (N : Node_Id) return Boolean;
      pragma Inline (Flag76);

      function Flag77 (N : Node_Id) return Boolean;
      pragma Inline (Flag77);

      function Flag78 (N : Node_Id) return Boolean;
      pragma Inline (Flag78);

      function Flag79 (N : Node_Id) return Boolean;
      pragma Inline (Flag79);

      function Flag80 (N : Node_Id) return Boolean;
      pragma Inline (Flag80);

      function Flag81 (N : Node_Id) return Boolean;
      pragma Inline (Flag81);

      function Flag82 (N : Node_Id) return Boolean;
      pragma Inline (Flag82);

      function Flag83 (N : Node_Id) return Boolean;
      pragma Inline (Flag83);

      function Flag84 (N : Node_Id) return Boolean;
      pragma Inline (Flag84);

      function Flag85 (N : Node_Id) return Boolean;
      pragma Inline (Flag85);

      function Flag86 (N : Node_Id) return Boolean;
      pragma Inline (Flag86);

      function Flag87 (N : Node_Id) return Boolean;
      pragma Inline (Flag87);

      function Flag88 (N : Node_Id) return Boolean;
      pragma Inline (Flag88);

      function Flag89 (N : Node_Id) return Boolean;
      pragma Inline (Flag89);

      function Flag90 (N : Node_Id) return Boolean;
      pragma Inline (Flag90);

      function Flag91 (N : Node_Id) return Boolean;
      pragma Inline (Flag91);

      function Flag92 (N : Node_Id) return Boolean;
      pragma Inline (Flag92);

      function Flag93 (N : Node_Id) return Boolean;
      pragma Inline (Flag93);

      function Flag94 (N : Node_Id) return Boolean;
      pragma Inline (Flag94);

      function Flag95 (N : Node_Id) return Boolean;
      pragma Inline (Flag95);

      function Flag96 (N : Node_Id) return Boolean;
      pragma Inline (Flag96);

      function Flag97 (N : Node_Id) return Boolean;
      pragma Inline (Flag97);

      function Flag98 (N : Node_Id) return Boolean;
      pragma Inline (Flag98);

      function Flag99 (N : Node_Id) return Boolean;
      pragma Inline (Flag99);

      function Flag100 (N : Node_Id) return Boolean;
      pragma Inline (Flag100);

      function Flag101 (N : Node_Id) return Boolean;
      pragma Inline (Flag101);

      function Flag102 (N : Node_Id) return Boolean;
      pragma Inline (Flag102);

      function Flag103 (N : Node_Id) return Boolean;
      pragma Inline (Flag103);

      function Flag104 (N : Node_Id) return Boolean;
      pragma Inline (Flag104);

      function Flag105 (N : Node_Id) return Boolean;
      pragma Inline (Flag105);

      function Flag106 (N : Node_Id) return Boolean;
      pragma Inline (Flag106);

      function Flag107 (N : Node_Id) return Boolean;
      pragma Inline (Flag107);

      function Flag108 (N : Node_Id) return Boolean;
      pragma Inline (Flag108);

      function Flag109 (N : Node_Id) return Boolean;
      pragma Inline (Flag109);

      function Flag110 (N : Node_Id) return Boolean;
      pragma Inline (Flag110);

      function Flag111 (N : Node_Id) return Boolean;
      pragma Inline (Flag111);

      function Flag112 (N : Node_Id) return Boolean;
      pragma Inline (Flag112);

      function Flag113 (N : Node_Id) return Boolean;
      pragma Inline (Flag113);

      function Flag114 (N : Node_Id) return Boolean;
      pragma Inline (Flag114);

      function Flag115 (N : Node_Id) return Boolean;
      pragma Inline (Flag115);

      function Flag116 (N : Node_Id) return Boolean;
      pragma Inline (Flag116);

      function Flag117 (N : Node_Id) return Boolean;
      pragma Inline (Flag117);

      function Flag118 (N : Node_Id) return Boolean;
      pragma Inline (Flag118);

      function Flag119 (N : Node_Id) return Boolean;
      pragma Inline (Flag119);

      function Flag120 (N : Node_Id) return Boolean;
      pragma Inline (Flag120);

      function Flag121 (N : Node_Id) return Boolean;
      pragma Inline (Flag121);

      function Flag122 (N : Node_Id) return Boolean;
      pragma Inline (Flag122);

      function Flag123 (N : Node_Id) return Boolean;
      pragma Inline (Flag123);

      function Flag124 (N : Node_Id) return Boolean;
      pragma Inline (Flag124);

      function Flag125 (N : Node_Id) return Boolean;
      pragma Inline (Flag125);

      function Flag126 (N : Node_Id) return Boolean;
      pragma Inline (Flag126);

      function Flag127 (N : Node_Id) return Boolean;
      pragma Inline (Flag127);

      function Flag128 (N : Node_Id) return Boolean;
      pragma Inline (Flag128);

      function Flag129 (N : Node_Id) return Boolean;
      pragma Inline (Flag129);

      function Flag130 (N : Node_Id) return Boolean;
      pragma Inline (Flag130);

      function Flag131 (N : Node_Id) return Boolean;
      pragma Inline (Flag131);

      function Flag132 (N : Node_Id) return Boolean;
      pragma Inline (Flag132);

      function Flag133 (N : Node_Id) return Boolean;
      pragma Inline (Flag133);

      function Flag134 (N : Node_Id) return Boolean;
      pragma Inline (Flag134);

      function Flag135 (N : Node_Id) return Boolean;
      pragma Inline (Flag135);

      function Flag136 (N : Node_Id) return Boolean;
      pragma Inline (Flag136);

      function Flag137 (N : Node_Id) return Boolean;
      pragma Inline (Flag137);

      function Flag138 (N : Node_Id) return Boolean;
      pragma Inline (Flag138);

      function Flag139 (N : Node_Id) return Boolean;
      pragma Inline (Flag139);

      function Flag140 (N : Node_Id) return Boolean;
      pragma Inline (Flag140);

      function Flag141 (N : Node_Id) return Boolean;
      pragma Inline (Flag141);

      function Flag142 (N : Node_Id) return Boolean;
      pragma Inline (Flag142);

      function Flag143 (N : Node_Id) return Boolean;
      pragma Inline (Flag143);

      function Flag144 (N : Node_Id) return Boolean;
      pragma Inline (Flag144);

      function Flag145 (N : Node_Id) return Boolean;
      pragma Inline (Flag145);

      function Flag146 (N : Node_Id) return Boolean;
      pragma Inline (Flag146);

      function Flag147 (N : Node_Id) return Boolean;
      pragma Inline (Flag147);

      function Flag148 (N : Node_Id) return Boolean;
      pragma Inline (Flag148);

      function Flag149 (N : Node_Id) return Boolean;
      pragma Inline (Flag149);

      function Flag150 (N : Node_Id) return Boolean;
      pragma Inline (Flag150);

      function Flag151 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag152 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag153 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag154 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag155 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag156 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag157 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag158 (N : Node_Id) return Boolean;
      pragma Inline (Flag151);

      function Flag159 (N : Node_Id) return Boolean;
      pragma Inline (Flag159);

      --  Procedures to set value of indicated field

      procedure Set_Nkind (N : Node_Id; Val : Node_Kind);
      pragma Inline (Set_Nkind);

      procedure Set_Field1 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field1);

      procedure Set_Field2 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field2);

      procedure Set_Field3 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field3);

      procedure Set_Field4 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field4);

      procedure Set_Field5 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field5);

      procedure Set_Field6 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field6);

      procedure Set_Field7 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field7);

      procedure Set_Field8 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field8);

      procedure Set_Field9 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field9);

      procedure Set_Field10 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field10);

      procedure Set_Field11 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field11);

      procedure Set_Field12 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field12);

      procedure Set_Field13 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field13);

      procedure Set_Field14 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field14);

      procedure Set_Field15 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field15);

      procedure Set_Field16 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field16);

      procedure Set_Field17 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field17);

      procedure Set_Field18 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field18);

      procedure Set_Field19 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field19);

      procedure Set_Field20 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field20);

      procedure Set_Field21 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field21);

      procedure Set_Field22 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field22);

      procedure Set_Field23 (N : Node_Id; Val : Union_Id);
      pragma Inline (Set_Field23);

      procedure Set_Node1 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node1);

      procedure Set_Node2 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node2);

      procedure Set_Node3 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node3);

      procedure Set_Node4 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node4);

      procedure Set_Node5 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node5);

      procedure Set_Node6 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node6);

      procedure Set_Node7 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node7);

      procedure Set_Node8 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node8);

      procedure Set_Node9 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node9);

      procedure Set_Node10 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node10);

      procedure Set_Node11 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node11);

      procedure Set_Node12 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node12);

      procedure Set_Node13 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node13);

      procedure Set_Node14 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node14);

      procedure Set_Node15 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node15);

      procedure Set_Node16 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node16);

      procedure Set_Node17 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node17);

      procedure Set_Node18 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node18);

      procedure Set_Node19 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node19);

      procedure Set_Node20 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node20);

      procedure Set_Node21 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node21);

      procedure Set_Node22 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node22);

      procedure Set_Node23 (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node23);

      procedure Set_List1 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List1);

      procedure Set_List2 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List2);

      procedure Set_List3 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List3);

      procedure Set_List4 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List4);

      procedure Set_List5 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List5);

      procedure Set_List10 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List10);

      procedure Set_List23 (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List23);

      procedure Set_Elist2 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist2);

      procedure Set_Elist3 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist3);

      procedure Set_Elist4 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist4);

      procedure Set_Elist8 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist8);

      procedure Set_Elist13 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist13);

      procedure Set_Elist14 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist14);

      procedure Set_Elist18 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist18);

      procedure Set_Elist21 (N : Node_Id; Val : Elist_Id);
      pragma Inline (Set_Elist21);

      procedure Set_Name1 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name1);

      procedure Set_Name2 (N : Node_Id; Val : Name_Id);
      pragma Inline (Set_Name2);

      procedure Set_Char_Code2 (N : Node_Id; Val : Char_Code);
      pragma Inline (Set_Char_Code2);

      procedure Set_Str3 (N : Node_Id; Val : String_Id);
      pragma Inline (Set_Str3);

      procedure Set_Uint3 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint3);

      procedure Set_Uint4 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint4);

      procedure Set_Uint8 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint8);

      procedure Set_Uint9 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint9);

      procedure Set_Uint11 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint11);

      procedure Set_Uint12 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint12);

      procedure Set_Uint13 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint13);

      procedure Set_Uint15 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint15);

      procedure Set_Uint16 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint16);

      procedure Set_Uint17 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint17);

      procedure Set_Uint22 (N : Node_Id; Val : Uint);
      pragma Inline (Set_Uint22);

      procedure Set_Ureal3 (N : Node_Id; Val : Ureal);
      pragma Inline (Set_Ureal3);

      procedure Set_Ureal18 (N : Node_Id; Val : Ureal);
      pragma Inline (Set_Ureal18);

      procedure Set_Ureal21 (N : Node_Id; Val : Ureal);
      pragma Inline (Set_Ureal21);

      procedure Set_Flag4 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag4);

      procedure Set_Flag5 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag5);

      procedure Set_Flag6 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag6);

      procedure Set_Flag7 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag7);

      procedure Set_Flag8 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag8);

      procedure Set_Flag9 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag9);

      procedure Set_Flag10 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag10);

      procedure Set_Flag11 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag11);

      procedure Set_Flag12 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag12);

      procedure Set_Flag13 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag13);

      procedure Set_Flag14 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag14);

      procedure Set_Flag15 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag15);

      procedure Set_Flag16 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag16);

      procedure Set_Flag17 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag17);

      procedure Set_Flag18 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag18);

      procedure Set_Flag19 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag19);

      procedure Set_Flag20 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag20);

      procedure Set_Flag21 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag21);

      procedure Set_Flag22 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag22);

      procedure Set_Flag23 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag23);

      procedure Set_Flag24 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag24);

      procedure Set_Flag25 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag25);

      procedure Set_Flag26 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag26);

      procedure Set_Flag27 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag27);

      procedure Set_Flag28 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag28);

      procedure Set_Flag29 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag29);

      procedure Set_Flag30 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag30);

      procedure Set_Flag31 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag31);

      procedure Set_Flag32 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag32);

      procedure Set_Flag33 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag33);

      procedure Set_Flag34 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag34);

      procedure Set_Flag35 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag35);

      procedure Set_Flag36 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag36);

      procedure Set_Flag37 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag37);

      procedure Set_Flag38 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag38);

      procedure Set_Flag39 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag39);

      procedure Set_Flag40 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag40);

      procedure Set_Flag41 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag41);

      procedure Set_Flag42 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag42);

      procedure Set_Flag43 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag43);

      procedure Set_Flag44 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag44);

      procedure Set_Flag45 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag45);

      procedure Set_Flag46 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag46);

      procedure Set_Flag47 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag47);

      procedure Set_Flag48 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag48);

      procedure Set_Flag49 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag49);

      procedure Set_Flag50 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag50);

      procedure Set_Flag51 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag51);

      procedure Set_Flag52 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag52);

      procedure Set_Flag53 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag53);

      procedure Set_Flag54 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag54);

      procedure Set_Flag55 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag55);

      procedure Set_Flag56 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag56);

      procedure Set_Flag57 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag57);

      procedure Set_Flag58 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag58);

      procedure Set_Flag59 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag59);

      procedure Set_Flag60 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag60);

      procedure Set_Flag61 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag61);

      procedure Set_Flag62 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag62);

      procedure Set_Flag63 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag63);

      procedure Set_Flag64 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag64);

      procedure Set_Flag65 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag65);

      procedure Set_Flag66 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag66);

      procedure Set_Flag67 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag67);

      procedure Set_Flag68 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag68);

      procedure Set_Flag69 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag69);

      procedure Set_Flag70 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag70);

      procedure Set_Flag71 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag71);

      procedure Set_Flag72 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag72);

      procedure Set_Flag73 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag73);

      procedure Set_Flag74 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag74);

      procedure Set_Flag75 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag75);

      procedure Set_Flag76 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag76);

      procedure Set_Flag77 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag77);

      procedure Set_Flag78 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag78);

      procedure Set_Flag79 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag79);

      procedure Set_Flag80 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag80);

      procedure Set_Flag81 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag81);

      procedure Set_Flag82 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag82);

      procedure Set_Flag83 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag83);

      procedure Set_Flag84 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag84);

      procedure Set_Flag85 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag85);

      procedure Set_Flag86 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag86);

      procedure Set_Flag87 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag87);

      procedure Set_Flag88 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag88);

      procedure Set_Flag89 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag89);

      procedure Set_Flag90 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag90);

      procedure Set_Flag91 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag91);

      procedure Set_Flag92 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag92);

      procedure Set_Flag93 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag93);

      procedure Set_Flag94 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag94);

      procedure Set_Flag95 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag95);

      procedure Set_Flag96 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag96);

      procedure Set_Flag97 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag97);

      procedure Set_Flag98 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag98);

      procedure Set_Flag99 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag99);

      procedure Set_Flag100 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag100);

      procedure Set_Flag101 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag101);

      procedure Set_Flag102 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag102);

      procedure Set_Flag103 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag103);

      procedure Set_Flag104 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag104);

      procedure Set_Flag105 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag105);

      procedure Set_Flag106 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag106);

      procedure Set_Flag107 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag107);

      procedure Set_Flag108 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag108);

      procedure Set_Flag109 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag109);

      procedure Set_Flag110 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag110);

      procedure Set_Flag111 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag111);

      procedure Set_Flag112 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag112);

      procedure Set_Flag113 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag113);

      procedure Set_Flag114 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag114);

      procedure Set_Flag115 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag115);

      procedure Set_Flag116 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag116);

      procedure Set_Flag117 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag117);

      procedure Set_Flag118 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag118);

      procedure Set_Flag119 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag119);

      procedure Set_Flag120 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag120);

      procedure Set_Flag121 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag121);

      procedure Set_Flag122 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag122);

      procedure Set_Flag123 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag123);

      procedure Set_Flag124 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag124);

      procedure Set_Flag125 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag125);

      procedure Set_Flag126 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag126);

      procedure Set_Flag127 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag127);

      procedure Set_Flag128 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag128);

      procedure Set_Flag129 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag129);

      procedure Set_Flag130 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag130);

      procedure Set_Flag131 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag131);

      procedure Set_Flag132 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag132);

      procedure Set_Flag133 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag133);

      procedure Set_Flag134 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag134);

      procedure Set_Flag135 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag135);

      procedure Set_Flag136 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag136);

      procedure Set_Flag137 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag137);

      procedure Set_Flag138 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag138);

      procedure Set_Flag139 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag139);

      procedure Set_Flag140 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag140);

      procedure Set_Flag141 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag141);

      procedure Set_Flag142 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag142);

      procedure Set_Flag143 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag143);

      procedure Set_Flag144 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag144);

      procedure Set_Flag145 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag145);

      procedure Set_Flag146 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag146);

      procedure Set_Flag147 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag147);

      procedure Set_Flag148 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag148);

      procedure Set_Flag149 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag149);

      procedure Set_Flag150 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag150);

      procedure Set_Flag151 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag151);

      procedure Set_Flag152 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag152);

      procedure Set_Flag153 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag153);

      procedure Set_Flag154 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag154);

      procedure Set_Flag155 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag155);

      procedure Set_Flag156 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag156);

      procedure Set_Flag157 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag157);

      procedure Set_Flag158 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag158);

      procedure Set_Flag159 (N : Node_Id; Val : Boolean);
      pragma Inline (Set_Flag159);

      --  The following versions of Set_Noden also set the parent
      --  pointer of the referenced node if it is non_Empty

      procedure Set_Node1_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node1_With_Parent);

      procedure Set_Node2_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node2_With_Parent);

      procedure Set_Node3_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node3_With_Parent);

      procedure Set_Node4_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node4_With_Parent);

      procedure Set_Node5_With_Parent (N : Node_Id; Val : Node_Id);
      pragma Inline (Set_Node5_With_Parent);

      --  The following versions of Set_Listn also set the parent pointer of
      --  the referenced node if it is non_Empty. The procedures for List6
      --  to List12 can only be applied to nodes which have an extension.

      procedure Set_List1_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List1_With_Parent);

      procedure Set_List2_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List2_With_Parent);

      procedure Set_List3_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List3_With_Parent);

      procedure Set_List4_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List4_With_Parent);

      procedure Set_List5_With_Parent (N : Node_Id; Val : List_Id);
      pragma Inline (Set_List5_With_Parent);

   end Unchecked_Access;

   -----------------------------
   -- Private Part Subpackage --
   -----------------------------

   --  The following package contains the definition of the data structure
   --  used by the implementation of the Atree package. Logically it really
   --  corresponds to the private part, hence the name. The reason that it
   --  is defined as a sub-package is to allow special access from clients
   --  that need to see the internals of the data structures.

   package Atree_Private_Part is

      -------------------------
      -- Tree Representation --
      -------------------------

      --  The nodes of the tree are stored in a table (i.e. an array). In the
      --  case of extended nodes four consecutive components in the array are
      --  used. There are thus two formats for array components. One is used
      --  for non-extended nodes, and for the first component of extended
      --  nodes. The other is used for the extension parts (second, third and
      --  fourth components) of an extended node. A variant record structure
      --  is used to distinguish the two formats.

      type Node_Record (Is_Extension : Boolean := False) is record

         --  Logically, the only field in the common part is the above
         --  Is_Extension discriminant (a single bit). However, Gigi cannot
         --  yet handle such a structure, so we fill out the common part of
         --  the record with fields that are used in different ways for
         --  normal nodes and node extensions.

         Pflag1, Pflag2 : Boolean;
         --  The Paren_Count field is represented using two boolean flags,
         --  where Pflag1 is worth 1, and Pflag2 is worth 2. This is done
         --  because we need to be easily able to reuse this field for
         --  extra flags in the extended node case.

         In_List : Boolean;
         --  Flag used to indicate if node is a member of a list.
         --  This field is considered private to the Atree package.

         Unused_1 : Boolean;
         --  Currently unused flag

         Rewrite_Ins : Boolean;
         --  Flag set by Mark_Rewrite_Insertion procedure.
         --  This field is considered private to the Atree package.

         Analyzed : Boolean;
         --  Flag to indicate the node has been analyzed (and expanded)

         Comes_From_Source : Boolean;
         --  Flag to indicate that node comes from the source program (i.e.
         --  was built by the parser or scanner, not the analyzer or expander).

         Error_Posted : Boolean;
         --  Flag to indicate that an error message has been posted on the
         --  node (to avoid duplicate flags on the same node)

         Flag4  : Boolean;
         Flag5  : Boolean;
         Flag6  : Boolean;
         Flag7  : Boolean;
         Flag8  : Boolean;
         Flag9  : Boolean;
         Flag10 : Boolean;
         Flag11 : Boolean;
         Flag12 : Boolean;
         Flag13 : Boolean;
         Flag14 : Boolean;
         Flag15 : Boolean;
         Flag16 : Boolean;
         Flag17 : Boolean;
         Flag18 : Boolean;
         --  The eighteen flags for a normal node

         --  The above fields are used as follows in components 2-4 of
         --  an extended node entry.

         --    In_List            used as  Flag19, Flag40, Flag129
         --    Unused_1           used as  Flag20, Flag41, Flag130
         --    Rewrite_Ins        used as  Flag21, Flag42, Flag131
         --    Analyzed           used as  Flag22, Flag43, Flag132
         --    Comes_From_Source  used as  Flag23, Flag44, Flag133
         --    Error_Posted       used as  Flag24, Flag45, Flag134
         --    Flag4              used as  Flag25, Flag46, Flag135
         --    Flag5              used as  Flag26, Flag47, Flag136
         --    Flag6              used as  Flag27, Flag48, Flag137
         --    Flag7              used as  Flag28, Flag49, Flag138
         --    Flag8              used as  Flag29, Flag50, Flag139
         --    Flag9              used as  Flag30, Flag51, Flag140
         --    Flag10             used as  Flag31, Flag52, Flag141
         --    Flag11             used as  Flag32, Flag53, Flag142
         --    Flag12             used as  Flag33, Flag54, Flag143
         --    Flag13             used as  Flag34, Flag55, Flag144
         --    Flag14             used as  Flag35, Flag56, Flag145
         --    Flag15             used as  Flag36, Flag57, Flag146
         --    Flag16             used as  Flag37, Flag58, Flag147
         --    Flag17             used as  Flag38, Flag59, Flag148
         --    Flag18             used as  Flag39, Flag60, Flag149
         --    Pflag1             used as  Flag61, Flag62, Flag150
         --    Pflag2             used as  Flag63, Flag64, Flag151

         Nkind : Node_Kind;
         --  For a non-extended node, or the initial section of an extended
         --  node, this field holds the Node_Kind value. For an extended node,
         --  The Nkind field is used as follows:
         --
         --     Second entry: holds the Ekind field of the entity
         --     Third entry:  holds 8 additional flags (Flag65-Flag72)
         --     Fourth entry: not currently used

         --  Now finally (on an 32-bit boundary!) comes the variant part

         case Is_Extension is

            --  Non-extended node, or first component of extended node

            when False =>

               Sloc : Source_Ptr;
               --  Source location for this node

               Link : Union_Id;
               --  This field is used either as the Parent pointer (if In_List
               --  is False), or to point to the list header (if In_List is
               --  True). This field is considered private and can be modified
               --  only by Atree or by Nlists.

               Field1 : Union_Id;
               Field2 : Union_Id;
               Field3 : Union_Id;
               Field4 : Union_Id;
               Field5 : Union_Id;
               --  Five general use fields, which can contain Node_Id, List_Id,
               --  Elist_Id, String_Id, Name_Id, or Char_Code values depending
               --  on the values in Nkind and (for extended nodes), in Ekind.
               --  See packages Sinfo and Einfo for details of their use.

            --  Extension (second component) of extended node

            when True =>
               Field6  : Union_Id;
               Field7  : Union_Id;
               Field8  : Union_Id;
               Field9  : Union_Id;
               Field10 : Union_Id;
               Field11 : Union_Id;
               Field12 : Union_Id;
               --  Seven additional general fields available only for entities
               --  See package Einfo for details of their use (which depends
               --  on the value in the Ekind field).

            --  In the third component, the extension format as described
            --  above is used to hold additional general fields and flags
            --  as follows:

            --    Field6-11      Holds Field13-Field18
            --    Field12        Holds Flag73-Flag96 and Convention

            --  In the fourth component, the extension format as described
            --  above is used to hold additional general fields and flags
            --  as follows:

            --    Field6-10      Holds Field19-Field23
            --    Field11        Holds Flag152-Flag159 (24 bits unused)
            --    Field12        Holds Flag97-Flag128

         end case;
      end record;

      pragma Pack (Node_Record);
      for Node_Record'Size use 8*32;

      --  The following defines the extendible array used for the nodes table
      --  Nodes with extensions use two consecutive entries in the array

      package Nodes is new Table.Table (
        Table_Component_Type => Node_Record,
        Table_Index_Type     => Node_Id,
        Table_Low_Bound      => First_Node_Id,
        Table_Initial        => Alloc.Nodes_Initial,
        Table_Increment      => Alloc.Nodes_Increment,
        Table_Name           => "Nodes");

   end Atree_Private_Part;

end Atree;
