------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   A D A . I N T E R R U P T S . N A M E S                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.4 $                             --
--                                                                          --
--          Copyright (C) 1991-1998 Free Software Foundation, Inc.          --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a OpenVMS/Alpha version of this package.
--
--  The following event flags are reserved by the run time:
--
--  Event_Flag_{0..31}

--  This target-dependent package spec contains names of interrupts
--  supported by the local system.

with System.OS_Interface;
package Ada.Interrupts.Names is

   package OS renames System.OS_Interface;

   Event_Flag_0   : constant Interrupt_ID := OS.Event_Flag_0;
   Event_Flag_1   : constant Interrupt_ID := OS.Event_Flag_1;
   Event_Flag_2   : constant Interrupt_ID := OS.Event_Flag_2;
   Event_Flag_3   : constant Interrupt_ID := OS.Event_Flag_3;
   Event_Flag_4   : constant Interrupt_ID := OS.Event_Flag_4;
   Event_Flag_5   : constant Interrupt_ID := OS.Event_Flag_5;
   Event_Flag_6   : constant Interrupt_ID := OS.Event_Flag_6;
   Event_Flag_7   : constant Interrupt_ID := OS.Event_Flag_7;
   Event_Flag_8   : constant Interrupt_ID := OS.Event_Flag_8;
   Event_Flag_9   : constant Interrupt_ID := OS.Event_Flag_9;

   Event_Flag_10  : constant Interrupt_ID := OS.Event_Flag_10;
   Event_Flag_11  : constant Interrupt_ID := OS.Event_Flag_11;
   Event_Flag_12  : constant Interrupt_ID := OS.Event_Flag_12;
   Event_Flag_13  : constant Interrupt_ID := OS.Event_Flag_13;
   Event_Flag_14  : constant Interrupt_ID := OS.Event_Flag_14;
   Event_Flag_15  : constant Interrupt_ID := OS.Event_Flag_15;
   Event_Flag_16  : constant Interrupt_ID := OS.Event_Flag_16;
   Event_Flag_17  : constant Interrupt_ID := OS.Event_Flag_17;
   Event_Flag_18  : constant Interrupt_ID := OS.Event_Flag_18;
   Event_Flag_19  : constant Interrupt_ID := OS.Event_Flag_19;

   Event_Flag_20  : constant Interrupt_ID := OS.Event_Flag_20;
   Event_Flag_21  : constant Interrupt_ID := OS.Event_Flag_21;
   Event_Flag_22  : constant Interrupt_ID := OS.Event_Flag_22;
   Event_Flag_23  : constant Interrupt_ID := OS.Event_Flag_23;
   Event_Flag_24  : constant Interrupt_ID := OS.Event_Flag_24;
   Event_Flag_25  : constant Interrupt_ID := OS.Event_Flag_25;
   Event_Flag_26  : constant Interrupt_ID := OS.Event_Flag_26;
   Event_Flag_27  : constant Interrupt_ID := OS.Event_Flag_27;
   Event_Flag_28  : constant Interrupt_ID := OS.Event_Flag_28;
   Event_Flag_29  : constant Interrupt_ID := OS.Event_Flag_29;

   Event_Flag_30  : constant Interrupt_ID := OS.Event_Flag_30;
   Event_Flag_31  : constant Interrupt_ID := OS.Event_Flag_31;
   Event_Flag_32  : constant Interrupt_ID := OS.Event_Flag_32;
   Event_Flag_33  : constant Interrupt_ID := OS.Event_Flag_33;
   Event_Flag_34  : constant Interrupt_ID := OS.Event_Flag_34;
   Event_Flag_35  : constant Interrupt_ID := OS.Event_Flag_35;
   Event_Flag_36  : constant Interrupt_ID := OS.Event_Flag_36;
   Event_Flag_37  : constant Interrupt_ID := OS.Event_Flag_37;
   Event_Flag_38  : constant Interrupt_ID := OS.Event_Flag_38;
   Event_Flag_39  : constant Interrupt_ID := OS.Event_Flag_39;

   Event_Flag_40  : constant Interrupt_ID := OS.Event_Flag_40;
   Event_Flag_41  : constant Interrupt_ID := OS.Event_Flag_41;
   Event_Flag_42  : constant Interrupt_ID := OS.Event_Flag_42;
   Event_Flag_43  : constant Interrupt_ID := OS.Event_Flag_43;
   Event_Flag_44  : constant Interrupt_ID := OS.Event_Flag_44;
   Event_Flag_45  : constant Interrupt_ID := OS.Event_Flag_45;
   Event_Flag_46  : constant Interrupt_ID := OS.Event_Flag_46;
   Event_Flag_47  : constant Interrupt_ID := OS.Event_Flag_47;
   Event_Flag_48  : constant Interrupt_ID := OS.Event_Flag_48;
   Event_Flag_49  : constant Interrupt_ID := OS.Event_Flag_49;

   Event_Flag_50  : constant Interrupt_ID := OS.Event_Flag_50;
   Event_Flag_51  : constant Interrupt_ID := OS.Event_Flag_51;
   Event_Flag_52  : constant Interrupt_ID := OS.Event_Flag_52;
   Event_Flag_53  : constant Interrupt_ID := OS.Event_Flag_53;
   Event_Flag_54  : constant Interrupt_ID := OS.Event_Flag_54;
   Event_Flag_55  : constant Interrupt_ID := OS.Event_Flag_55;
   Event_Flag_56  : constant Interrupt_ID := OS.Event_Flag_56;
   Event_Flag_57  : constant Interrupt_ID := OS.Event_Flag_57;
   Event_Flag_58  : constant Interrupt_ID := OS.Event_Flag_58;
   Event_Flag_59  : constant Interrupt_ID := OS.Event_Flag_59;

   Event_Flag_60  : constant Interrupt_ID := OS.Event_Flag_60;
   Event_Flag_61  : constant Interrupt_ID := OS.Event_Flag_61;
   Event_Flag_62  : constant Interrupt_ID := OS.Event_Flag_62;
   Event_Flag_63  : constant Interrupt_ID := OS.Event_Flag_63;

   --  Common event flags are process-blocking in VMS 7.1
   --  Enable them when that's fixed.
--   Event_Flag_64  : constant Interrupt_ID := OS.Event_Flag_64;
--   Event_Flag_65  : constant Interrupt_ID := OS.Event_Flag_66;
--   Event_Flag_66  : constant Interrupt_ID := OS.Event_Flag_66;
--   Event_Flag_67  : constant Interrupt_ID := OS.Event_Flag_67;
--   Event_Flag_68  : constant Interrupt_ID := OS.Event_Flag_68;
--   Event_Flag_69  : constant Interrupt_ID := OS.Event_Flag_69;
--
--   Event_Flag_70  : constant Interrupt_ID := OS.Event_Flag_70;
--   Event_Flag_71  : constant Interrupt_ID := OS.Event_Flag_71;
--   Event_Flag_72  : constant Interrupt_ID := OS.Event_Flag_72;
--   Event_Flag_73  : constant Interrupt_ID := OS.Event_Flag_73;
--   Event_Flag_74  : constant Interrupt_ID := OS.Event_Flag_74;
--   Event_Flag_75  : constant Interrupt_ID := OS.Event_Flag_76;
--   Event_Flag_76  : constant Interrupt_ID := OS.Event_Flag_76;
--   Event_Flag_77  : constant Interrupt_ID := OS.Event_Flag_77;
--   Event_Flag_78  : constant Interrupt_ID := OS.Event_Flag_78;
--   Event_Flag_79  : constant Interrupt_ID := OS.Event_Flag_79;
--
--   Event_Flag_80  : constant Interrupt_ID := OS.Event_Flag_80;
--   Event_Flag_81  : constant Interrupt_ID := OS.Event_Flag_81;
--   Event_Flag_82  : constant Interrupt_ID := OS.Event_Flag_82;
--   Event_Flag_83  : constant Interrupt_ID := OS.Event_Flag_83;
--   Event_Flag_84  : constant Interrupt_ID := OS.Event_Flag_84;
--   Event_Flag_85  : constant Interrupt_ID := OS.Event_Flag_86;
--   Event_Flag_86  : constant Interrupt_ID := OS.Event_Flag_86;
--   Event_Flag_87  : constant Interrupt_ID := OS.Event_Flag_87;
--   Event_Flag_88  : constant Interrupt_ID := OS.Event_Flag_88;
--   Event_Flag_89  : constant Interrupt_ID := OS.Event_Flag_89;
--
--   Event_Flag_90  : constant Interrupt_ID := OS.Event_Flag_90;
--   Event_Flag_91  : constant Interrupt_ID := OS.Event_Flag_91;
--   Event_Flag_92  : constant Interrupt_ID := OS.Event_Flag_92;
--   Event_Flag_93  : constant Interrupt_ID := OS.Event_Flag_93;
--   Event_Flag_94  : constant Interrupt_ID := OS.Event_Flag_94;
--   Event_Flag_95  : constant Interrupt_ID := OS.Event_Flag_96;
--   Event_Flag_96  : constant Interrupt_ID := OS.Event_Flag_96;
--   Event_Flag_97  : constant Interrupt_ID := OS.Event_Flag_97;
--   Event_Flag_98  : constant Interrupt_ID := OS.Event_Flag_98;
--   Event_Flag_99  : constant Interrupt_ID := OS.Event_Flag_99;
--
--   Event_Flag_100 : constant Interrupt_ID := OS.Event_Flag_100;
--   Event_Flag_101 : constant Interrupt_ID := OS.Event_Flag_101;
--   Event_Flag_102 : constant Interrupt_ID := OS.Event_Flag_102;
--   Event_Flag_103 : constant Interrupt_ID := OS.Event_Flag_103;
--   Event_Flag_104 : constant Interrupt_ID := OS.Event_Flag_104;
--   Event_Flag_105 : constant Interrupt_ID := OS.Event_Flag_105;
--   Event_Flag_106 : constant Interrupt_ID := OS.Event_Flag_106;
--   Event_Flag_107 : constant Interrupt_ID := OS.Event_Flag_107;
--   Event_Flag_108 : constant Interrupt_ID := OS.Event_Flag_108;
--   Event_Flag_109 : constant Interrupt_ID := OS.Event_Flag_109;
--
--   Event_Flag_110 : constant Interrupt_ID := OS.Event_Flag_110;
--   Event_Flag_111 : constant Interrupt_ID := OS.Event_Flag_111;
--   Event_Flag_112 : constant Interrupt_ID := OS.Event_Flag_112;
--   Event_Flag_113 : constant Interrupt_ID := OS.Event_Flag_113;
--   Event_Flag_114 : constant Interrupt_ID := OS.Event_Flag_114;
--   Event_Flag_115 : constant Interrupt_ID := OS.Event_Flag_115;
--   Event_Flag_116 : constant Interrupt_ID := OS.Event_Flag_116;
--   Event_Flag_117 : constant Interrupt_ID := OS.Event_Flag_117;
--   Event_Flag_118 : constant Interrupt_ID := OS.Event_Flag_118;
--   Event_Flag_119 : constant Interrupt_ID := OS.Event_Flag_119;
--
--   Event_Flag_120 : constant Interrupt_ID := OS.Event_Flag_120;
--   Event_Flag_121 : constant Interrupt_ID := OS.Event_Flag_121;
--   Event_Flag_122 : constant Interrupt_ID := OS.Event_Flag_122;
--   Event_Flag_123 : constant Interrupt_ID := OS.Event_Flag_123;
--   Event_Flag_124 : constant Interrupt_ID := OS.Event_Flag_124;
--   Event_Flag_125 : constant Interrupt_ID := OS.Event_Flag_125;
--   Event_Flag_126 : constant Interrupt_ID := OS.Event_Flag_126;
--   Event_Flag_127 : constant Interrupt_ID := OS.Event_Flag_127;
--   Event_Flag_128 : constant Interrupt_ID := OS.Event_Flag_128;

end Ada.Interrupts.Names;
