/* $Header: /cvs/gnome/gIDE/src/gI_document.h,v 1.4 1999/12/05 07:17:51 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_DOCUMENT_H
#define GI_DOCUMENT_H

#include <config.h>
#include <gnome.h>
#include "gI_text.h"

/*
 * Prototypes for 'gI_document.c'
 */
gI_document *gI_document_new( gI_window *window );
void gI_document_set_unchanged( gI_document *document );
void gI_document_changed( GtkWidget *widget, gI_document *document );
void gI_document_keypressed( GtkWidget *widget, GdkEventKey *event, gI_document *document );
gI_document *gI_document_get_current( gI_window *window );
gI_document *gI_document_get_nth( gI_window *window, guint index );
void gI_document_clear_text( gI_document *document );
gint gI_document_get_no( gI_window *window );
void gI_document_track_movement( gI_document *document );
gint gI_document_show_popup_menu(GtkWidget *widget,GdkEvent *ev);
void gI_document_cmd_swaphc(GtkWidget *widget,gI_window* window);
void gI_document_cmd_open_file_at_line(GtkWidget *widget,gI_window *window);
glong gI_document_get_changed( gI_window *window );
glong get_column_from_point( glong point );
void gI_document_buttonpressed( GtkWidget *widget, GdkEventButton *event, gI_document *document );
void gI_document_buttonpressed_after( GtkWidget *widget, GdkEventButton *event, gI_document *document );
void special_remove_current_file( GtkWidget *widget, gpointer data );
void update_documents_style( gI_window* window );
void check_current_doc(void);
void special_insert_file( GtkWidget *widget, gpointer data );
glong gI_document_get_pageno( gI_document *document );
void gI_document_set_changed( gI_document *document );
void special_mail_doc( GtkWidget *widget, gpointer data );
void show_manpage( GtkWidget *widget, gpointer data );
void gI_document_insert_text( GtkEditable *editable,
                              const gchar *new_text,
                              gint new_text_length,
                              gint *position, gI_document *document );
void gI_document_delete_text( GtkEditable *editable,
                              gint start_pos,
                              gint end_pos, gI_document *document );
void gI_document_insert( gI_document *document, GdkFont *font, GdkColor *fore,
                         GdkColor *back, const char *chars, gint length );
void gI_document_delete_selection( gI_document *document );
void gI_document_delete( gI_document *document, gint from, gint to );

#endif

