/****************************************************************************
**
** param.c
**
** Michael S. Borella 
**
** Parameter structure manipulation routines.  Currently all are held
** in an array, but this code should be easy to modify if that changes.
** Ideally, this should be a C++ class...
**
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <malloc.h>
#include "genparse.h"
#include "error.h"

int current = -1;

extern clarg_t arg_array[];
extern char global_callback[];
extern char *includes[];
extern char *mandatory;

int include_ptr = 0;

/*---------------------------------------------------------------------------
 * 
 * new_param()
 *
 * Initialize a structure for a new command line parameter.
 *
 *-------------------------------------------------------------------------*/

void new_param(void)
{
  /*
   * Make sure that we start at zero and then increment
   */
 
  current ++;

  /*
   * Initialize everything as empty
   */

  arg_array[current].short_param = EOS;
  arg_array[current].long_param[0] = EOS;
  arg_array[current].internal_var[0] = EOS;
  arg_array[current].type = 0;
  arg_array[current].default_val[0] = EOS;
  arg_array[current].low_range[0] = EOS;
  arg_array[current].high_range[0] = EOS;
  arg_array[current].callback[0] = EOS;
  arg_array[current].desc[0] = EOS;
}


/*---------------------------------------------------------------------------
 * 
 * set_short_param()
 *
 *-------------------------------------------------------------------------*/

void set_short_param(char c)
{
  arg_array[current].short_param = c;
}


/*---------------------------------------------------------------------------
 * 
 * set_long_param()
 *
 *-------------------------------------------------------------------------*/

void set_long_param(char *s)
{
  strncpy(arg_array[current].long_param, s, 
	  sizeof(arg_array[current].long_param));
}


/*---------------------------------------------------------------------------
 * 
 * set_internal_var()
 *
 *-------------------------------------------------------------------------*/

void set_internal_var(char *s)
{
  strncpy(arg_array[current].internal_var, s, 
	  sizeof(arg_array[current].internal_var));
}


/*---------------------------------------------------------------------------
 * 
 * set_type()
 *
 *-------------------------------------------------------------------------*/

void set_type(int i)
{
  arg_array[current].type = i;
}


/*---------------------------------------------------------------------------
 * 
 * set_default_val()
 *
 *-------------------------------------------------------------------------*/

void set_default_val(char *s)
{
  strncpy(arg_array[current].default_val, s, 
	  sizeof(arg_array[current].default_val));
}


/*---------------------------------------------------------------------------
 * 
 * set_low_range()
 *
 *-------------------------------------------------------------------------*/

void set_low_range(char *s)
{
  strncpy(arg_array[current].low_range, s, 
	  sizeof(arg_array[current].low_range));
}


/*---------------------------------------------------------------------------
 * 
 * set_high_range()
 *
 *-------------------------------------------------------------------------*/

void set_high_range(char *s)
{
  strncpy(arg_array[current].high_range, s, 
	  sizeof(arg_array[current].high_range));
}


/*---------------------------------------------------------------------------
 * 
 * set_callback()
 *
 *-------------------------------------------------------------------------*/

void set_callback(char *s)
{
  strncpy(arg_array[current].callback, s, 
	  sizeof(arg_array[current].callback));
}


/*---------------------------------------------------------------------------
 * 
 * set_desc()
 *
 *-------------------------------------------------------------------------*/

void set_desc(char *s)
{
  strncpy(arg_array[current].desc, s, 
	  sizeof(arg_array[current].desc));
}


/*---------------------------------------------------------------------------
 *
 * set_global_callback()
 *
 *-------------------------------------------------------------------------*/

void set_global_callback(char *s)
{
  strncpy(global_callback, s, TOKEN_SIZE);
}

/*---------------------------------------------------------------------------
 *
 * set_mandatory
 *
 *-------------------------------------------------------------------------*/

void set_mandatory(char *s)
{
  mandatory = (char *) malloc (strlen(s)+1);
  strncpy(mandatory, s, strlen(s));
}

/*---------------------------------------------------------------------------
 *
 * new_include()
 *
 *-------------------------------------------------------------------------*/

void new_include(char *s)
{
  if (include_ptr == MAX_INCLUDES)
    ftlerr("too many include files");

  includes[include_ptr] = (char *) malloc (strlen(s)+1);
  strncpy(includes[include_ptr], s, strlen(s));
  include_ptr++;
}

/*---------------------------------------------------------------------------
 * 
 * get_current()
 *
 *-------------------------------------------------------------------------*/

int get_current_flag(void)
{
  return current;
}

