/****************************************************************************
**
** genparse.h
**
** Michael S. Borella 
**
****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef EOS
#define EOS '\0'
#endif

#define TOKEN_SIZE 64
#define LINE_SIZE 128
#define MAX_FLAGS 256
#define MAX_INCLUDES 64

#define DEBUG 0

#define INT_T 		1
#define FLOAT_T 	4
#define CHAR_T		6
#define STRING_T	7
#define FLAG_T		8

/*
 * Structure to contain the complete specification of a single arg
 */

typedef struct _clarg_t
{
  char short_param;
  char long_param[TOKEN_SIZE];
  char internal_var[TOKEN_SIZE];
  int  type;
  char default_val[TOKEN_SIZE];
  char low_range[TOKEN_SIZE];
  char high_range[TOKEN_SIZE];
  char callback[TOKEN_SIZE];
  char desc[LINE_SIZE];
} clarg_t;

