#include "available-stubs.h"

#include <sys/types.h>
#include <sys/mkdev.h>
#include "checker_api.h"

/* compiled from: . */
#ifdef HAVE_makedev
/* From `/usr/include/sys/mkdev.h:40'.  */
dev_t chkr_stub_makedev (major_t maj, minor_t min)
     __asm__ (CHKR_PREFIX ("makedev"));
dev_t
chkr_stub_makedev (major_t maj, minor_t min)
{
#if USE_BI_JUMP
  __builtin_jump (makedev);
#else
  return makedev (maj, min);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_makedev */

#ifdef HAVE_major
/* From `/usr/include/sys/mkdev.h:41'.  */
major_t chkr_stub_major (dev_t device) __asm__ (CHKR_PREFIX ("major"));
major_t
chkr_stub_major (dev_t device)
{
#if USE_BI_JUMP
  __builtin_jump (major);
#else
  return major (device);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_major */

#ifdef HAVE_minor
/* From `/usr/include/sys/mkdev.h:42'.  */
minor_t chkr_stub_minor (dev_t device) __asm__ (CHKR_PREFIX ("minor"));
minor_t
chkr_stub_minor (dev_t device)
{
#if USE_BI_JUMP
  __builtin_jump (minor);
#else
  return minor (device);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_minor */

#ifdef HAVE___makedev
/* From `/usr/include/sys/mkdev.h:43'.  */
dev_t chkr_stub___makedev (int ver, major_t maj, minor_t min)
     __asm__ (CHKR_PREFIX ("__makedev"));
dev_t
chkr_stub___makedev (int ver, major_t maj, minor_t min)
{
#if USE_BI_JUMP
  __builtin_jump (__makedev);
#else
  return __makedev (ver, maj, min);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___makedev */

#ifdef HAVE___major
/* From `/usr/include/sys/mkdev.h:44'.  */
major_t chkr_stub___major (int ver, dev_t device)
     __asm__ (CHKR_PREFIX ("__major"));
major_t
chkr_stub___major (int ver, dev_t device)
{
#if USE_BI_JUMP
  __builtin_jump (__major);
#else
  return __major (ver, device);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___major */

#ifdef HAVE___minor
/* From `/usr/include/sys/mkdev.h:45'.  */
minor_t chkr_stub___minor (int ver, dev_t device)
     __asm__ (CHKR_PREFIX ("__minor"));
minor_t
chkr_stub___minor (int ver, dev_t device)
{
#if USE_BI_JUMP
  __builtin_jump (__minor);
#else
  return __minor (ver, device);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE___minor */

