/* Checker stubs for functions defined in setjmp.h
   Copyright 1995, 1996 Tristan Gingold
		  Written December 1995 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

 The author may be reached by US/French mail:
		Tristan Gingold 
		8 rue Parmentier
		F-91120 PALAISEAU
		FRANCE
*/
#include "available-stubs.h"

#ifdef HAVE_SETJMP_H
#include <setjmp.h>
#include "checker_api.h"

#ifdef HAVE_longjmp
void chkr_stub_longjmp (const jmp_buf env, int val)
  __asm__ (CHKR_PREFIX ("longjmp"));
void
chkr_stub_longjmp (const jmp_buf env, int val)
{
/*  stubs_chkr_check_addr (env, sizeof (jmp_buf), CHKR_RO); */
#if USE_BI_JUMP
  __builtin_jump (longjmp);
#else
  longjmp (env, val);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_longjmp */

#ifdef HAVE___setjmp
int chkr_stub___setjmp (jmp_buf env) __asm__ (CHKR_PREFIX ("__setjmp"));
int
chkr_stub___setjmp (jmp_buf env)
{
  int res;
  stubs_chkr_check_addr (env, sizeof (env), CHKR_TW, "env");
  res = __setjmp (env);
  return res;
}
#endif /* HAVE___setjmp */

#ifdef HAVE_setjmp
int chkr_stub_setjmp (jmp_buf env) __asm__ (CHKR_PREFIX ("setjmp"));
int
chkr_stub_setjmp (jmp_buf env)
{
  int res;
  stubs_chkr_check_addr (env, sizeof (env), CHKR_TW, "env");
  res = setjmp (env);
  return res;
}
#endif /* HAVE_setjmp */

#ifdef HAVE___sigsetjmp
/* Terrible and awful hack.
   This only works on ix86-pc-linux-gnu (libc6).
   Why it is difficult ?

   At first, just a note:
   with glibc2 (aka libc6), you have:
#define setjmp(env)     __sigsetjmp ((env), 0)
   So, keep in mind that __sigsetjmp is nearly an alias of setjmp.

   The environnment argument (ie the state information) is valid only after
   the call of setjmp (of course), and only in the same function or functions
   called by the function containing the call of setjmp.
   To be clear, if foo() calls setjmp(env), you can call longjmp(env) only
   in foo() or functions called by foo().
 
   So, if a stub is made for setjmp, like this one:
int
chkr_stub___sigsetjmp (jmp_buf env, int val)
{
  stubs_chkr_check_addr (env, sizeof (jmp_buf), CHKR_TW, "env");
  return __sigsetjmp (env, val);
}
  This can't work as the user expected, because env is valid only in
  the stub and after the call to sigsetjmp, ie nowhere.

  Note: the use of __builtin_jump would make it possible, but this
  pseudo-function is not implemented.

  The only easy solution is to write an alias, ie
  a stub that directly jumps to the real function.  Not portable!

  Note: There is no problems for longjmp (well, not this one).
*/

/* My current solution.  Ugly.
   Not portable.  */
asm (".globl " CHKR_PREFIX ("__sigsetjmp") "\n"
     CHKR_PREFIX ("__sigsetjmp") ":\n"
     "	jmp __sigsetjmp\n");

#if 0
/* From `/usr/include/setjmp.h:49'.  */
/* An alias ?
   Doesn't work: it must be defined in the same file as the function aliased.
*/
int chkr_stub___sigsetjmp (jmp_buf env, int val)
     __asm__ (CHKR_PREFIX ("__sigsetjmp"))
     __attribute__ ((alias ("__sigsetjmp")));
#endif

#if 0
/* A stub ? */
int
chkr_stub___sigsetjmp (jmp_buf env, int val)
{
  stubs_chkr_check_addr (env, sizeof (jmp_buf), CHKR_TW, "env");
#if USE_BI_JUMP
  /* This could work.  */
  __builtin_jump (__sigsetjmp);
#else
  /* This can't work.  */
  return __sigsetjmp (env, val);
#endif /* !USE_BI_JUMP */
}
#endif
#endif /* HAVE___sigsetjmp */

#endif /* HAVE_SETJMP_H */
