{
BP compatible printer unit with extensions

Copyright (C) 1998-99 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation, version 2.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As a special exception, if you link this library with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU Library General
Public License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU Library
General Public License.
}

{$gnu-pascal}
{$if __GPC_RELEASE__ < 19990905}
{$error This unit requires GPC release 19990905 or newer}
{$endif}

unit Printer;

interface

{$ifdef __OS_DOS__}

{ Dos-like systems: writing to a printer device }

uses GPC;

var
  { The file name to write printer output into }
  PrinterDeviceName : ^String = @'lpt1';

{$else}

{ Unix-like systems: printing via a printer program }

uses GPC, Pipe;

const
  EPrinterRead = 610; { printer can only be opened for writing }

var
  { The file name of the printer program. If it contains a '/', it will be
    taken as a complete path, otherwise the file name will be searched for
    in the PATH with FSearchExecutable. }
  PrinterCommand : ^String = @'lpr';

  { Optional command line parameters for the printer program. Ignored when nil. }
  PrinterArguments : ^TPStrings = nil;

  { How to deal with the printer daemon after the printer pipe is closed, cf. the Pipe unit. }
  PrinterPipeSignal  : Integer = 0;
  PrinterPipeSeconds : Integer = 0;
  PrinterPipeWait    : Boolean = True;

{$endif}

{ Text file opened to default printer }
var
  Lst : Text;

{ Assign a file to the printer. Lst will be assigned to the default
  printer at program start, but other files can be assigned to the
  same or other printers (possibly after changing the variables
  above). SpoolerOutput, if not null, will be redirected from the
  printer spooler's standard output and error. If you use this, note
  that a deadlock might arise when trying to write data to the
  spooler while its output is not being read, though this seems
  quite unlikely, since most printer spoolers don't write so much
  output that it could fill a pipe. Under Dos, where no spooler is
  involved, SpoolerOutput, if not null, will be reset to an empty
  file for compatibility. }
procedure AssignPrinter (var f : AnyFile; var SpoolerOutput : AnyFile);

implementation

{$I-,B-}

{$ifdef __OS_DOS__}

procedure AssignPrinter (var f : AnyFile; var SpoolerOutput : AnyFile);
begin
  Assign (f, PrinterDeviceName^);
  if @SpoolerOutput <> nil then
    begin
      Unbind (SpoolerOutput);
      Rewrite (SpoolerOutput);
      Reset (SpoolerOutput)
    end
end;

{$else}

type
  TPrinterTFDDData = record
    f, SpoolerOutput : PAnyFile;
  end;

procedure OpenPrinter (var PrivateData; Mode : TOpenMode);
var Dummy : Pointer;
begin
  Dummy := @PrivateData;
  if not (Mode in [foRewrite, foAppend]) then IOError (EPrinterRead)
end;

{ Be very lazy: don't open the pipe until data are written to it -- not
  as soon as the file is opened because that happens already in the
  initialization of this unit (BP compatibility) }
function WritePrinter (var PrivateData; const Buffer; Size : SizeType) : SizeType;
var
  Data : TPrinterTFDDData absolute PrivateData;
  CharBuf : array [1 .. Size] of Char absolute Buffer;
  Process : PPipeProcess;
begin
  WritePrinter := 0;
  Pipe (Data.f^, Data.SpoolerOutput^, Data.SpoolerOutput^, PrinterCommand^, PrinterArguments^, GetCEnvironment, Process, (*@@fjf258b*)TProcedure( nil)); { this also makes sure this function won't be called again for this file }
  if InOutRes <> 0 then Exit;
  Process^.Signal  := PrinterPipeSignal;
  Process^.Seconds := PrinterPipeSeconds;
  Process^.Wait    := PrinterPipeWait;
  Write (Data.f^, CharBuf);
  if InOutRes = 0 then WritePrinter := Size
end;

procedure AssignPrinter (var f : AnyFile; var SpoolerOutput : AnyFile);
var p : ^TPrinterTFDDData;
begin
  if @SpoolerOutput <> nil then
    begin
      Unbind (SpoolerOutput);
      Rewrite (SpoolerOutput);
      Reset (SpoolerOutput)
    end;
  New (p);
  p^.f := @f;
  p^.SpoolerOutput := @SpoolerOutput;
  AssignTFDD (f, OpenPrinter, (*@@fjf258*)TSelectFunc(nil), TSelectProc(nil), TReadFunc(nil), WritePrinter, TFlushProc(nil),TCloseProc(nil),TDoneProc(nil), p)
end;

{$endif}

to begin do
begin
  AssignPrinter (Lst, null);
  if InOutRes = 0 then Rewrite (Lst)
end;

to end do
  Close (Lst);

end.
