{
GPC demo program for the GMP unit.
Computing Fibonacci numbers.

Copyright (C) 1999 Free Software Foundation, Inc.

Author: Frank Heckenbach <frank@pascal.gnu.de>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING. If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

As a special exception, if you incorporate even large parts of the
code of this demo program into another program with substantially
different functionality, this does not cause the other program to
be covered by the GNU General Public License. This exception does
not however invalidate any other reasons why it might be covered
by the GNU General Public License.
}

program Fibonacci;

uses GPC, GMP;

var
  n, i : Integer;
  a, b, t : mpz_t;
  s : CString;

begin
  case ParamCount of
    0 : begin
          Writeln ('Fibonacci number computation.');
          Write ('Enter a number: ');
          Readln (n)
        end;
    1 : ReadStr (ParamStr (1), n);
    else
      Writeln (StdErr, 'Fibonacci number computation.');
      Writeln (StdErr, 'Usage: ', ParamStr (0), ' [n]');
      Halt (1)
  end;
  if n < 3 then
    begin
      Writeln (1);
      Halt
    end;
  mpz_init_set_si (a, 1);
  mpz_init_set_si (b, 1);
  for i := 3 to n do
    begin
      mpz_init (t);
      mpz_add (t, a, b);
      mpz_clear (a);
      a := b;
      b := t
    end;
  s := mpz_get_str (nil, 10, b);
  {$X+} Writeln (s); {$X-}
  Writeln ('(', CStringLength (s), ' digits)');
  Dispose (s);
  mpz_clear (a);
  mpz_clear (b)
end.
