{
  $Id: clist.pp,v 1.2 1999/05/10 19:18:17 peter Exp $

  This file extracted from the GTK tutorial.
  clist.c

  Converted from C to Pascal by Frank Loemker
  <floemker@techfak.uni-bielefeld.de>
}
program clist;
uses
  glib,gdk,gtk;

{ User clicked the 'Add List' button. }
procedure button_add_clicked (button : pGtkWidget ; data: pGtkCList ); cdecl;
{ Something silly to add to the list. 4 rows of 2 columns each }
const drink : array[0..3,0..1] of pgchar =
  (('Milk', '3 Oz'),
   ('Water', '6 l'),
   ('Carrots', '2'),
   ('Snakes', '55'));
var indx : integer ;
begin
  { Here we do the actual adding of the text. It's done once for
    each row. }
  for indx:=0 to 3 do
    gtk_clist_append (data, @drink[indx]);
end;

{ User clicked the 'Clear List' button. }
procedure button_clear_clicked ( button : pGtkWidget; data : pGtkCList ); cdecl;
begin
  { Clear the list using gtk_clist_clear. This is much faster than
    calling gtk_clist_remove once for each row. }
  gtk_clist_clear (data);
end;

{ The user clicked the 'Hide/Show titles' button. }
procedure button_hide_show_clicked (button : pGtkWidget ; data : pGtkCList ); cdecl;
const flag:integer = 0;
begin
  { Just a flag to remember the status. 0 = currently visible }

  if flag = 0 then
  begin
    { Hide the titles and set the flag to 1 }
    gtk_clist_column_titles_hide (data);
    inc (flag);
  end else begin
    { Show the titles and reset flag to 0 }
    gtk_clist_column_titles_show (data);
    dec (flag);
  end;
end;

{ If we come here, then the user has selected a row in the list. }
procedure selection_made (thelist : pGTKCLIST ; row, column: gint;
                          event :  pGdkEventButton ; data : gpointer); cdecl;
var text : pgchar;
begin
  { Get the text that is stored in the selected row and column
    which was clicked in. We will receive it as a pointer in the
    argument text. }
  gtk_clist_get_text(thelist, row, column, @text);

  { Just prints some information about the selected row }
  writeln ('You selected row ',row,
           '. More specifically you clicked in column ',column,
           ', and the text in this cell is ',text,#10);
end;

const
  titles: array[0..1] of pgchar = ('Ingredients','Amount');
var
  window,vbox,hbox,thelist,
  button_add, button_clear,button_hide_show : pGtkWidget;
begin
  gtk_init (@argc, @argv);
  gtk_rc_init;

  window := gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(pGTKWIDGET(window), 300, 150);

  gtk_window_set_title(pGTKWINDOW(window), 'GtkCList Example');
  gtk_signal_connect(pGTKOBJECT(window),
                     'destroy',
                     tgtksignalfunc(@gtk_main_quit),
                     nil);

  vbox := gtk_vbox_new(gint(FALSE), 5);
  gtk_container_border_width(pGTKCONTAINER(vbox), 5);
  gtk_container_add(pGTKCONTAINER(window), vbox);
  gtk_widget_show(vbox);

  { Create the GtkCList. For this example we use 2 columns }
  thelist := gtk_clist_new_with_titles( 2, titles);

  { When a selection is made, we want to know about it. The callback
    used is selection_made, and it's code can be found further down }
  gtk_signal_connect(pGTKOBJECT(thelist), 'select_row',
                     tgtksignalfunc(@selection_made),
                     nil);

  { It isn't necessary to shadow the border, but it looks nice :) }
  gtk_clist_set_border(pGTKCLIST(thelist), GTK_SHADOW_OUT);

  { What however is important, is that we set the column widths as
    they will never be right otherwise. Note that the columns are
    numbered from 0 and up (to 1 in this case). }
  gtk_clist_set_column_width (pGTKCLIST(thelist), 0, 150);

  { Scollbars _only when needed_ }
  gtk_clist_set_policy(pGTKCLIST(thelist), GTK_POLICY_AUTOMATIC,
                       GTK_POLICY_AUTOMATIC);

  { Add the GtkCList widget to the vertical box and show it. }
  gtk_box_pack_start(pGTKBOX(vbox), thelist, gint(TRUE), gint(TRUE), 0);
  gtk_widget_show(thelist);

  { Create the buttons and add them to the window. See the button
    tutorial for more examples and comments on this. }
  hbox := gtk_hbox_new(gint(FALSE), 0);
  gtk_box_pack_start(pGTKBOX(vbox), hbox, gint(FALSE), gint(TRUE), 0);
  gtk_widget_show(hbox);

  button_add := gtk_button_new_with_label('Add List');
  button_clear := gtk_button_new_with_label('Clear List');
  button_hide_show := gtk_button_new_with_label('Hide/Show titles');

  gtk_box_pack_start (pGTKBOX(hbox), button_add, gint(TRUE), gint(TRUE), 0);
  gtk_box_pack_start (pGTKBOX(hbox), button_clear, gint(TRUE), gint(TRUE), 0);
  gtk_box_pack_start (pGTKBOX(hbox), button_hide_show, gint(TRUE), gint(TRUE), 0);

  { Connect our callbacks to the three buttons }
  gtk_signal_connect_object(pGTKOBJECT(button_add), 'clicked',
                            tgtksignalfunc(@button_add_clicked),
                            gpointer(thelist));
  gtk_signal_connect_object(pGTKOBJECT(button_clear), 'clicked',
                            tgtksignalfunc(@button_clear_clicked),
                            gpointer (thelist));
  gtk_signal_connect_object(pGTKOBJECT(button_hide_show), 'clicked',
                            tgtksignalfunc(@button_hide_show_clicked),
                            gpointer (thelist));

  gtk_widget_show (button_add);
  gtk_widget_show (button_clear);
  gtk_widget_show (button_hide_show);

  { The interface is completely set up so we show the window and
    enter the gtk_main loop }
  gtk_widget_show(window);
  gtk_main();
end.
{
  $Log: clist.pp,v $
  Revision 1.2  1999/05/10 19:18:17  peter
    * more fixes for the examples to work

  Revision 1.1  1999/05/10 09:02:36  peter
    * gtk 1.2 port working

  Revision 1.3  1999/02/02 16:13:34  michael
  + Applied second patch from Frank Loemker

  Revision 1.2  1998/10/22 11:37:27  peter
    * fixes for win32

  Revision 1.1  1998/10/21 22:27:01  peter
    + initial version

}
