{
  System dependent mouse implementation for go32v2

  $Id: mouse.inc,v 1.6 1999/03/03 16:42:27 pierre Exp $
}

uses
  go32;

var
  RealSeg : Word;                                    { Real mode segment }
  RealOfs : Word;                                    { Real mode offset }
  MouseCallback : Pointer;                           { Mouse call back ptr }
{$ifdef DEBUG}
  EntryEDI,EntryESI : longint;
  EntryDS,EntryES : word;
{$endif DEBUG}
  { Real mode registers in text segment below $ffff limit
    for Windows NT
    NOTE this might cause problem if someone want to
    protect text section against writing (would be possible
    with CWSDPMI under raw dos, not implemented yet !) }
  ActionRegs    : TRealRegs;external name '___v2prt0_rmcb_regs';
  v2prt0_ds_alias : word;external name '___v2prt0_ds_alias';

{$ASMMODE ATT}
procedure MouseInt;assembler;
asm
        movb    %bl,mousebuttons
        movw    %cx,mousewherex
        movw    %dx,mousewherey
        cmpb    MouseEventBufSize,PendingMouseEvents
        je      .Lmouse_exit
        movl    PendingMouseTail,%edi
        shrw    $3,%cx
        shrw    $3,%dx
        movw    %bx,(%edi)
        movw    %cx,2(%edi)
        movw    %dx,4(%edi)
        movw    $0,6(%edi)
        addl    $8,%edi
        leal    PendingMouseEvent,%eax
        addl    MouseEventBufSize*8,%eax
        cmpl    %eax,%edi
        jne     .Lmouse_nowrap
        leal    PendingMouseEvent,%edi
.Lmouse_nowrap:
        movl    %edi,PendingMouseTail
        incb    PendingMouseEvents
.Lmouse_exit:
end;



PROCEDURE Mouse_Trap; ASSEMBLER;
ASM
   PUSH %ES;                                          { Save ES register }
   PUSH %DS;                                          { Save DS register }
   PUSHL %EDI;                                        { Save register }
   PUSHL %ESI;                                        { Save register }
   ;{ caution : ds is not the selector for our data !! }
{$ifdef DEBUG}
   MOVL  %EDI,%ES:EntryEDI
   MOVL  %ESI,%ES:EntryESI
   MOVW  %DS,%AX
   MOVW  %AX,%ES:EntryDS
   MOVW  %ES,%AX
   MOVW  %AX,%ES:EntryES
{$endif DEBUG}
   PUSH %ES;                                          { Push data seg }
   POP %DS;                                           { Load data seg }
   MOVL MOUSECALLBACK, %EAX;                          { Fetch callback addr }
   CMPL $0, %EAX;                                     { Check for nil ptr }
   JZ .L_NoCallBack;                                  { Ignore if nil }
   MOVL %EDI,%EAX;                                    { %EAX = @actionregs }
   MOVL (%EAX), %EDI;                                 { EDI from actionregs }
   MOVL 4(%EAX), %ESI;                                { ESI from actionregs }
   MOVL 16(%EAX), %EBX;                               { EBX from actionregs }
   MOVL 20(%EAX), %EDX;                               { EDX from actionregs }
   MOVL 24(%EAX), %ECX;                               { ECX from actionregs }
   MOVL 28(%EAX), %EAX;                               { EAX from actionregs }
   CALL *MOUSECALLBACK;                               { Call callback proc }
.L_NoCallBack:
   POPL %ESI;                                         { Recover register }
   POPL %EDI;                                         { Recover register }
   POP %DS;                                           { Restore DS register }
   POP %ES;                                           { Restore ES register }
   movzwl %si,%eax
   MOVL (%Eax), %EAX;
   MOVL %EAX, %ES:42(%EDI);                           { Set as return addr }
   ADDW $4, %ES:46(%EDI);                             { adjust stack }
   IRET;                                              { Interrupt return }
END;


PROCEDURE Mouse_Action (Mask : Word; P : Pointer);
VAR
  Error : Word;
  Rg    : TRealRegs;
BEGIN
  Error := 0;                                         { Preset no error }
  If (P <> MouseCallBack) Then                        { Check func different }
   Begin
   { Remove old calback }
     If (RealSeg <> 0) Then
      Begin
        Rg.AX := 12;                                   { Function id }
        Rg.CX := 0;                                    { Zero mask register }
        Rg.ES := 0;                                    { Zero proc seg }
        Rg.DX := 0;                                    { Zero proc ofs }
        RealIntr($33, Rg);                             { Stop INT 33 callback }
        ASM
         MOVW $0x304, %AX;                            { Set function id }
         MOVW REALSEG, %CX;                           { Bridged real seg }
         MOVW REALOFS, %DX;                           { Bridged real ofs }
         INT $0x31;                                   { Release bridge }
       END;
     End;
    { test addresses for Windows NT }
    if (longint(@actionregs)>$ffff) {or
       (longint(@mouse_trap)>$ffff)} then
      begin
         error:=1;
      end
    else If (P <> Nil) Then
     Begin
       ASM
         LEAL ACTIONREGS, %EDI;                       { Addr of actionregs }
         LEAL MOUSE_TRAP, %ESI;                       { Procedure address }
         PUSH %DS;                                    { Save DS segment }
         PUSH %ES;                                    { Save ES segment }
         MOVW v2prt0_ds_alias,%ES;                    { ES now has dataseg  alias that is never invalid }
         PUSH %CS;
         POP  %DS;                                    { DS now has codeseg }
         MOVW $0x303, %AX;                            { Function id }
         INT  $0x31;                                  { Call DPMI bridge }
         JNC .L_call_ok;                              { Branch if ok }
         POP  %ES;                                    { Restore ES segment }
         POP  %DS;                                    { Restore DS segment }
         JMP  .L_exit
       .L_call_ok:
         POP  %ES;                                    { Restore ES segment }
         POP  %DS;                                    { Restore DS segment }
         MOVW %CX,REALSEG;                            { Transfer real seg }
         MOVW %DX,REALOFS;                            { Transfer real ofs }
         MOVW $0, %AX;                                { Force error to zero }
       .L_exit:
         MOVW %AX, ERROR;                             { Return error state }
       END;
     End
    Else
     Begin
       RealSeg:=0;                                   { Zero proc register }
       RealOfs:=0;
       Mask := 0;                                    { Zero mask register }
     End;
    If (Error = 0) Then
     Begin
       MouseCallback := P;                            { Set call back addr }
       Rg.AX := 12;                                   { Set function id }
       Rg.CX := Mask;                                 { Set mask register }
       Rg.ES := RealSeg;                              { Real mode segment }
       Rg.DX := RealOfs;                              { Real mode offset }
       RealIntr($33, Rg);                             { Set interrupt 33 }
     End;
   End;
  If (Error <> 0) Then
   Begin
     Writeln('GO32V2 mouse handler set failed !!');
     ReadLn;                                          { Wait for user to see }
     RealSeg := 0;                                    { Zero real mode seg }
     RealOfs := 0;                                    { Zero real mode ofs }
   End;
END;


{ We need to remove the mouse callback before exiting !! PM }

const StoredExit : Pointer = Nil;

procedure MouseSafeExit;
begin
  ExitProc:=StoredExit;
  if MouseCallBack<>Nil then
    Mouse_Action(0, Nil);
end;


procedure InitMouse;
begin
  If StoredExit=Nil then
    begin
      StoredExit:=ExitProc;
      ExitProc:=@MouseSafeExit;
    end;

  PendingMouseHead:=@PendingMouseEvent;
  PendingMouseTail:=@PendingMouseEvent;
  PendingMouseEvents:=0;
  FillChar(LastMouseEvent,sizeof(TMouseEvent),0);

  { don't do this twice !! PM }

  If MouseCallBack=Nil then
    begin
      Lock_Code(Pointer(@Mouse_Trap), 400);              { Lock trap code }
      Lock_Data(ActionRegs, SizeOf(TRealRegs));          { Lock registers }
      { lock Mouse Queue and related stuff ! }
      Lock_Data(PendingMouseEvent,256);
      MouseCallBack := Nil;                              { Clear call back }
      RealSeg := 0;                                      { Zero segment }
      RealOfs := 0;                                      { Zero offset }
      Mouse_Action($ffff, @MouseInt);                    { Set masks/interrupt }
    end;
  ShowMouse;
end;


procedure DoneMouse;
begin
  HideMouse;
  If (MouseCallBack <> Nil) Then
    Mouse_Action(0, Nil);                            { Clear mask/interrupt }
  Unlock_Code(Pointer(@Mouse_Trap), 400);            { Release trap code }
  Unlock_Data(ActionRegs, SizeOf(TRealRegs));        { Release registers }
  { unlock Mouse Queue and related stuff ! }
  UnLock_Data(PendingMouseEvent,256);
  MouseCallBack := Nil;                              { Clear call back ptr }
end;


function DetectMouse:byte;assembler;
asm
        movl    $0x200,%eax
        movl    $0x33,%ebx
        int     $0x31
        movw    %cx,%ax
        orw     %ax,%dx
        jz      .Lno_mouse
        xorl    %eax,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        orw     %ax,%ax
        jz      .Lno_mouse
        movl    %ebx,%eax
.Lno_mouse:
end;


procedure ShowMouse;assembler;
asm
        movl    $1,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


procedure HideMouse;assembler;
asm
        movl    $2,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


function GetMouseX:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movzwl  %cx,%eax
        shrl    $3,%eax
        incl    %eax
end;


function GetMouseY:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movzwl  %dx,%eax
        shrl    $3,%eax
        incl    %eax
end;


function GetMouseButtons:word;assembler;
asm
        movl    $3,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
        movw    %bx,%ax
end;


procedure SetMouseXY(x,y:word);assembler;
asm
        movw    x,%cx
        movw    y,%dx
        movl    $4,%eax
        pushl   %ebp
        int     $0x33
        popl    %ebp
end;


procedure GetMouseEvent(var MouseEvent: TMouseEvent);
begin
  repeat until PendingMouseEvents>0;
  MouseEvent:=PendingMouseHead^;
  inc(PendingMouseHead);
  if longint(PendingMouseHead)=longint(@PendingMouseEvent)+sizeof(PendingMouseEvent) then
   PendingMouseHead:=@PendingMouseEvent;
  dec(PendingMouseEvents);
  if (LastMouseEvent.x<>MouseEvent.x) or (LastMouseEvent.y<>MouseEvent.y) then
   MouseEvent.Action:=MouseActionMove;
  if (LastMouseEvent.Buttons<>MouseEvent.Buttons) then
   begin
     if (LastMouseEvent.Buttons=0) then
      MouseEvent.Action:=MouseActionDown
     else
      MouseEvent.Action:=MouseActionUp;
   end;
  LastMouseEvent:=MouseEvent;
end;


function PollMouseEvent(var MouseEvent: TMouseEvent):boolean;
begin
  if PendingMouseEvents>0 then
   begin
     MouseEvent:=PendingMouseHead^;
     PollMouseEvent:=true;
   end
  else
   PollMouseEvent:=false;
end;

{
  $Log: mouse.inc,v $
  Revision 1.6  1999/03/03 16:42:27  pierre
   + test for NT compatibility

  Revision 1.5  1999/02/19 16:44:48  peter
    * fixed (esi) which also got the 0xffff limit under NT

  Revision 1.4  1999/02/19 12:28:39  pierre
    + Uses now v2prt0_ds_alias for RMCB regs
      regs are located in text section of v2prt0.as
      so that its offset is below $ffff limit (for window NT !)

  Revision 1.3  1999/02/08 09:39:13  pierre
   * added exitproc to avoid real mode crash with function 12 of mouse interrupt

  Revision 1.2  1998/12/11 00:13:19  peter
    + SetMouseXY
    * use far for exitproc procedure

  Revision 1.1  1998/12/04 12:48:27  peter
    * moved some dirs

  Revision 1.2  1998/10/28 21:18:25  peter
    * more fixes

  Revision 1.1  1998/10/28 00:02:08  peter
    + mouse
    + video.clearscreen, video.videobufsize

}
