/*
 * Copyright (c) 1998, 1999 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>

#include <mom/compiler.h>
#include <mom/c/libcast.h>

void cast_w_scoped_name(cast_scoped_name *scname)
{
	cast_template_arg_array *ta;
	unsigned int i;
	unsigned int j;
	
	for (i = 0; i < scname->cast_scoped_name_len; i++) {
		if (i > 0)
			w_printf("::");
		w_printf("%s", scname->cast_scoped_name_val[i].name);
		ta = &(scname->cast_scoped_name_val[i].args);
		if (ta->cast_template_arg_array_len) {
			w_printf("<");
			for (j = 0;
			     j < ta->cast_template_arg_array_len;
			     j++) {
				if (j > 0)
					w_printf(", ");
				cast_w_template_arg(
					ta->cast_template_arg_array_val[j],
					0);
			}
			w_printf(">");
		}
	}
}

/* End of file. */

