#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fcomp -e option
#

work=/tmp/$$
PAGER=cat
export PAGER

fail()
{
	set +x
	echo FAILED test of the fcomp -e option 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test for deletion
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
two
four
five
six
seven
eight
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
A test.first
B test.second
D 1 1
D 3 2
D 9-10 7
T 0 4 6
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -e test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for insertion
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
one
two
three
four
five
six
six and a half
seven
eight
nine
ten
eleven
twelve
thirteen
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
A test.first
B test.second
I 7 7
I 11 12-14
T 4 0 10
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -e test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for replace
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
one
two
three
ruof
evif
xis
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
A test.first
B test.second
R 4-6 4-6
T 3 3 7
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -e test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
